{***********************************************************************}
{									}
{ UNIT_WIN Window Management Functions					}
{									}
{ This unit implements the POWER TOOLS PLUS window management routines. }
{ These routines provide the capability to create, display, access,	}
{ remove, and destroy screen windows.					}
{									}
{  _NOBORD_WIN	No border request for window		    (constant)	}
{  _SLBORD_WIN	Single line border			    (constant)	}
{  _DLBORD_WIN	Double line border			    (constant)	}
{  _BLANKBORD_WIN							}
{		Border of blank characters		    (constant)	}
{									}
{  _WindowDim	Window dimensions			    (type)	}
{  _WinBorder	Window border description		    (type)	}
{  _WinTitlePos Window title positions on the border	    (type)	}
{  _WinTitleStr Window title strings			    (type)	}
{  _WinTitle	Window title descriptors		    (type)	}
{  _WindowPtr	Pointer to a _Window record		    (type)	}
{  _Window	Window description record		    (type)	}
{									}
{  _WinRoot	Window list root			    (variable)	}
{  _WinCur	Pointer to current window.		    (variable)	}
{  _CurWindow	Current window dimension		    (variable)	}
{									}
{ __InitWin	Initialize the window descriptor list			}
{ __MakeWin	Construct a window descriptor record			}
{ __ZapWin	Delete a window descriptor				}
{ __DispWin	Display and make a window current			}
{ __TitleWin	Add a title to a window 				}
{ __CurWin	Make an active window current				}
{ __TopWin	Make a hidden visible					}
{ __RemWin	Remove the current window				}
{ __GotoWin	Position the cursor in a window 			}
{ __WhereWin	Return the cursor position and size			}
{ __AttrWin	Position the cursor in a window 			}
{ __WCharWin	Display characters in a window				}
{ __FastWin	Write to the current window directly			}
{ __WrAttWin	Write attributes only to a window directly		}
{ __WriteWin	Write a string in a window				}
{ __ReadWin	Read a string from a window				}
{ __VertWin	Vertically scroll text in a window			}
{ __ClearWin	Clear the current window				}
{ __HorzWin	Horizontally scroll text in a window			}
{									}
{ Version 4.00 (C)Copyright Blaise Computing Inc.  1987 		}
{_______________________________________________________________________}

Unit Unit_Win;

interface
  uses DOS,			       { Turbo DOS unit 		}
       CRT,			       { Turbo CRT unit 		}
       Unit_Sup,		       { POWER TOOLS PLUS Support unit	}
       Unit_Scn;		       { POWER TOOLS PLUS Screen unit	}

  const
    _NOBORD_WIN    = 255;	       { No border request for window	}
    _SLBORD_WIN    =   0;	       { Single line border		}
    _DLBORD_WIN    =  15;	       { Double line border		}
    _BLANKBORD_WIN =   0;	       { Border of blank characters	}


  type

    _WindowDim	 = record		   { Window dimension		}
		     _XUpper   : byte;	   { Upper left and lower right }
		     _YUpper   : byte;	   { coordinates of the window. }
		     _XLower   : byte;
		     _YLower   : byte;
		   end;

    _WinBorder	 = record		   { Window border description	}
		     _BorType  : byte;
		     _BorFore  : byte;
		     _BorBack  : byte;
		   end;

    _WinTitlePos = (_TopCenter, 	   { Window title positions	}
		    _TopRight,
		    _TopLeft,
		    _BottomCenter,
		    _BottomRight,
		    _BottomLeft);
    _WinTitleStr = string[80];
    _WinTitle	 = record
		     _TitlePos : _WinTitlePos;
		     _TitleStr : _WinTitleStr;
		     _TFore    : byte;
		     _TBack    : byte;
		   end;

    _WindowPtr	 = ^_Window;
    _Window	 = record		   { Window description record	}
		     _Dim	: _WindowDim;
		     _XCursor	: byte;    { Cursor position within the }
		     _YCursor	: byte;    { window.			}
		     _TopScan	: byte;    { Scan lines for cursor size }
		     _BotScan	: byte;
		     _Fore	: byte;    { Foreground and background	}
		     _Back	: byte;    { attributes within window	}
		     _Border	: _WinBorder;
		     _Title	: _WinTitle;
		     _Image	: pointer; { Location and size of screen}
		     _ImageSize : word;    { image below this window.	}
		     _Active	: boolean; { Is the window active?	}
		     _WinUnder	: _WindowPtr;	{ Window underneath	}
		     _WinTop	: _WindowPtr;	{ Window on top 	}
		   end;

  var
    _WinRoot	 : _WindowPtr;	       { Window list root		}
    _WinCur	 : _WindowPtr;	       { Pointer to current window	}
    _CurWindow	 : _WindowDim;	       { Current window dimension	}

  procedure __InitWin;
  function  __MakeWin (X1,Y1,X2,Y2,
		       TopScan,BotScan,Fore,Back,
		       BorType,BorFore,BorBack : byte) : _WindowPtr;
  function  __ZapWin  (var WinPtr : _WindowPtr) : boolean;
  function  __DispWin (WinPtr : _WindowPtr) : boolean;
  function  __TitleWin(WinPtr : _WindowPtr;
			Title : _WinTitleStr;
		    Fore,Back : byte;
			 TPos : _WinTitlePos) : boolean;
  function  __CurWin  (WinPtr : _WindowPtr) : boolean;
  function  __Topwin  (WinPtr : _windowPtr) : boolean;
  function  __RemWin : boolean;
  procedure __GotoWin (X,Y : byte);
  procedure __WhereWin(var X,Y,TopScan,BotScan : byte);
  procedure __AttrWin (DispCh : char; Count : word; Fore,Back : byte);
  procedure __WCharWin(DispCh : char; Count : word);
  procedure __FastWin (X,Y : byte; BufferPtr : pointer;
				     NoChars : word;
			      Fore,Back,Mode : byte);
  procedure __WrAttWin(X,Y : byte; Count : word; Fore,Back : byte);
  procedure __WriteWin(X,Y : byte; BufferPtr : pointer;
				     NoChars : word;
			      Fore,Back,Mode : byte);
  procedure __ReadWin (X,Y : byte; BufferPtr : pointer;
				     NoChars : word;
					Mode : byte);
  procedure __VertWin (NumRows,Fore,Back : byte;   Up : boolean);
  procedure __ClearWin(Fore,Back : byte);
  procedure __HorzWin (NumCols,Fore,Back : byte; Left : boolean);

implementation

  var
    WinLast_ : _WindowPtr;	       { Pointer to last window in list }
    EntScn_  : _Window; 	       { Record for the entire screen	}

  {$I initwin.imp }
  {$I makewin.imp }
  {$I zapwin.imp  }
  {$I fasttwin.imp}		       { Used by __TitleWin and 	}
  {$I dispwin.imp }		       { __DispWin.			}
  {$I titlewin.imp}
  {$I curwin.imp  }
  {$I topwin.imp  }
  {$I remwin.imp  }
  {$I gotowin.imp }
  {$I wherewin.imp}
  {$I attrwin.imp }
  {$I wcharwin.imp}
  {$I fastwin.imp }
  {$I wrattwin.imp}
  {$I writewin.imp}
  {$I readwin.imp }
  {$I vertwin.imp }
  {$I clearwin.imp}
  {$I horzwin.imp }

  begin {Initialization}

    with _CurWindow do		       { Initialize _CurWindow record	}
      begin			       { to be the entire screen.	}
	_XUpper := 1;
	_YUpper := 1;
	_XLower := _CurColumns;
	_YLower := _CurRows
      end;
    WindMin  := 0;		       { Set Turbo Pascal Window	}
    WindMax  := __2WordSup(_CurRows - 1,_CurColumns - 1);
    _WinRoot := NIL;		       { Initialize all pointers.	}
    WinLast_ := NIL;
    _WinCur  := NIL

  end. {Unit_Win}
