{***********************************************************************}
{									}
{ UNIT_UTL	DOS utilities						}
{									}
{ This unit provides DOS support utilities. DOS use flags, process	}
{ identification, disk space utilitization, DOS error reporting, and	}
{ program environment maintenance are supported.			}
{									}
{  _EnvPtr	Pointer to environment table		     (variable) }
{  _CFlagPtr	Pointer to InDOS (critical section) flag     (variable) }
{									}
{ __CBrkUtl	Return or set the DOS Ctrl/Break flag			}
{ __CFlagUtl	Return the address of the DOS critical section flag	}
{ __SpaceUtl	Report disk space utilization and parameters		}
{ __RetEnUtl	Return the next environment string			}
{ __GetEnUtl	Return an environment variable value			}
{ __PutEnUtl	Place a string in the environment			}
{ __RetIDUtl	Return the current process identification		}
{ __SetIDUtl	Set the current process identification			}
{ __IdStrUtl	Return a string identifying the process 		}
{ __RetErUtl	Return the last DOS error information (3.00 or later)	}
{ __StrErUtl	Return a text description for a DOS error code		}
{									}
{ Version 4.00	(C)Copyright Blaise Computing Inc.  1987		}
{_______________________________________________________________________}

unit Unit_Utl;

interface
  uses DOS,			       { Turbo Pascal DOS unit		}
       Unit_Sup;		       { POWER TOOLS general support	}

  var
    _EnvPtr   : pointer;	       { Pointer to environment table	}
    _CFlagPtr : _BytePtr;	       { Pointer to InDOS flag		}

  function  __CBrkUtl(SetFlag,Flag : boolean) : boolean;
  function  __CFlagUtl : _BytePtr;
  function  __SpaceUtl(Drive : byte;
			  var AvailClus,TotalClus,
			      BytesPerSec,SecsPerClus : word) : longint;
  function  __RetEnUtl(var  EnvPos : word)   : string;
  function  __GetEnUtl(    EnvName : string) : string;
  function  __PutEnUtl(     EnvStr : string) : string;
  procedure __RetIDUtl(var ProgSeg : word);
  procedure __SetIDUtl(    ProgSeg : word);
  function  __IdStrUtl(ProgSeg : word; var   HomeDir : _Path;
				       var ErrorCode : word): string;
  function  __RetErUtl(var Class,Action,Locus : word) : word;
  function  __StrErUtl(ErrorCode : word) : string;

implementation

  var
    EnvMemPtr_ : pointer;	       { Allocated space for the copy	}
    EnvSize_   : word;		       { of the environment.		}

  {$I cbrkutl.imp }
  {$I cflagutl.imp}
  {$I spaceutl.imp}
  {$I retenutl.imp}
  {$I getenutl.imp}
  {$I putenutl.imp}
  {$I retidutl.imp}
  {$I setidutl.imp}
  {$I reterutl.imp}
  {$I strerutl.imp}
  {$I idstrutl.imp}

  begin {Initialization}

    { The initial value of the environment pointer is the _EnvSeg seg-	}
    { ment and offset zero.  If the environment is altered using	}
    { __PutEnUtl, the environment is copied to the local heap.		}
    { _EnvSeg is set in the initialization section of the support unit	}
    { Unit_Sup. 							}

    _EnvPtr    := Ptr(_EnvSeg,0);
    EnvMemPtr_ := NIL;		       { No space allocated yet.	}
    EnvSize_   := 0;

    _CFlagPtr  := __CFlagUtl	       { Initialize the InDOS flag	}

  end.	{Initialization}
