{***********************************************************************}
{									}
{ UNIT_STR String Functions						}
{									}
{ This unit implements the POWER TOOLS PLUS String manipulation 	}
{ routines.  These routines enhance the string functions provided by	}
{ Turbo Pascal.  All routines in this unit are functions  which return	}
{ the generic string type.						}
{									}
{ __LeftStr   Extract the left most characters of a string		}
{ __RightStr  Extract the right most characters of a string		}
{ __SubStr    Extract substring from a string				}
{ __MidStr    Place characters within a string				}
{ __FillStr   Fill a string with copies of a character. 		}
{ __XlateStr  String translation					}
{ __JustStr   Justify a string within a field.				}
{ __CvtStr    Conversion of a string					}
{ __EnTabStr  Return a string with spaces converted to tab characters	}
{ __DeTabStr  Return a string with tabs expanded to space characters	}
{ __ToRadStr  Return the radix representation of an integer type	}
{ __ToDecStr  Return the unsigned decimal representation of an integer	}
{ __ToHexStr  Return the hexadecimal representation of an integer	}
{ __Ptr2Str   Return a string representing a pointer value		}
{ __DateStr   Return the system date					}
{ __TimeStr   Return the system time					}
{									}
{ Version 4.00 (C)Copyright Blaise Computing Inc. 1985, 1986, 1987	}
{_______________________________________________________________________}

Unit Unit_Str;

interface
  uses DOS,			       { Turbo Pascal DOS unit		}
       Unit_Sup;		       { POWER TOOLS Support unit	}

  const

    { Justification constants for __JustStr.				}

    _LEFT_JUST_STR	 = 0;	       { Left justify			}
    _RIGHT_JUST_STR	 = 1;	       { Right justify			}
    _CENTER_STR 	 = 2;	       { Center within the field	}

    { String converstion constants for __CvtStr.			}

    _REM_WHITE_STR	 = $0001;      { Remove all white space 	}
    _REM_LEAD_WHITE_STR  = $0002;      { Remove leading white space	}
    _REM_TRAIL_WHITE_STR = $0004;      { Remove trailing white space	}
    _REDUCE_WHITE_STR	 = $0008;      { Reduce white space to one blank}
    _SAVE_QUOTED_STR	 = $0010;      { Preserve quoted string 	}
    _TO_UPCASE_STR	 = $0020;      { Convert to upper case		}
    _TO_LOWCASE_STR	 = $0040;      { Convert to lower case		}
    _DISCARD_STR	 = $0080;      { Discard excess characters	}

  function __LeftStr (Source : string;	 Num : word) : string;
  function __RightStr(Source : string; ChPos : word) : string;
  function __SubStr  (Source : string;	 ChPos, Num : word) : string;
{  function __MidStr  (Source,Target : string; ChPos : word) : string;
  function __FillStr (FillCh : char; Target : string;
				  ChPos,Num : word) : string;
  function __XlateStr(Source,Table,Trans : string) : string;
  function __JustStr (Source : string;	FillCh : char;
				     FieldSize : word;
				      JustCode : word) : string;
  function __CvtStr  (Source : string; CvtCode : word) : string;
  function __EnTabStr(Source : string; Incr : byte) : string;
  function __DeTabStr(Source : string; Incr : byte;
				 var RemStr : string) : string;
  function __ToRadStr(IntValue : longint;
			      Size,Radix,Width : word) : string;
  function __ToDecStr(IntValue : longint; Size : word) : string;
  function __ToHexStr(IntValue : longint; Size : word) : string;
  function __Ptr2Str ( ThisPtr : pointer) : string;          }
  function __DateStr (var Year,Month,Day : word) : string;
  function __TimeStr (var Hours,Minutes,Seconds,Tics : word) : string;

implementation

  const
  MAXSTR_ = 255;		       { Maximum string length		}

  {$I leftstr.imp }
  {$I rightstr.imp}
  {$I substr.imp  }
  {I midstr.imp  }
  {I fillstr.imp }
  {I xlatestr.imp}
  {I juststr.imp }
  {I cvtstr.imp  }
  {I entabstr.imp}
  {I detabstr.imp}
  {I toradstr.imp}
  {I todecstr.imp}
  {I tohexstr.imp}
  {I ptr2str.imp }
  {$I datestr.imp }
  {$I timestr.imp }

  end.
