{***********************************************************************}
{									}
{ UNIT_PRT	Printer support 					}
{									}
{ This unit provides both BIOS printer control and interface to the	}
{ PC-DOS PRINT spooler utility. 					}
{									}
{ _TIMEOUT_PRT	BIOS timeout return code		     (constant) }
{ _IOERROR_PRT	BIOS I/O error return code		     (constant) }
{ _ONLINE_PRT	BIOS printer is online return code	     (constant) }
{ _NOPAPER_PRT	BIOS printer is out of paper return code     (constant) }
{ _ACK_PRT	BIOS printer acknowledge return code	     (constant) }
{ _NOTBUSY_PRT	BIOS printer is not busy return code	     (constant) }
{									}
{ _NOTINSTALLED_PRT					     (constant) }
{		PRINT is not installed					}
{ _QUEUEEMPTY_PRT					     (constant) }
{		The PRINT queue is empty				}
{ _RANGE_PRT	Item number is not in the PRINT queue	     (constant) }
{ _QUEUEFULL_PRT					     (constant) }
{		The PRINT queue is full 				}
{ _SPOOLBUSY_PRT					     (constant) }
{		The PRINT spooler is busy				}
{									}
{ __InitPrt	Initialize the printer port (BIOS)			}
{ __StatPrt	Return the printer port status (BIOS)			}
{ __BytePrt	Send a single byte (character) to the printer (BIOS)	}
{ __WrtPrt	Write a string to the printer (BIOS)			}
{ __SpInsPrt	Detect PRINT presence					}
{ __SpSubPrt	Submit a file to the PRINT spooler			}
{ __SpCanPrt	Remove an entry from the PRINT spooler queue		}
{ __SpLisPrt	Return information about a PRINT spooler queue entry	}
{									}
{ Version 4.00	(C)Copyright Blaise Computing Inc.  1987		}
{_______________________________________________________________________}

unit Unit_Prt;

interface
  uses DOS,			       { Turbo Pascal DOS unit		}
       Unit_Sup;		       { POWER TOOLS PLUS Support unit	}

  const
    _TIMEOUT_PRT      = $01;	       { Printer timeout		}
    _IOERROR_PRT      = $08;	       { I/O error			}
    _ONLINE_PRT       = $10;	       { Printer is online		}
    _NOPAPER_PRT      = $20;	       { Printer is out of paper	}
    _ACK_PRT	      = $40;	       { Printer acknowledged		}
    _NOTBUSY_PRT      = $80;	       { Printer is not busy		}

    _NOTINSTALLED_PRT = 1;	       { PRINT is not installed 	}
    _QUEUEEMPTY_PRT   = 6;	       { The queue is empty		}
    _RANGE_PRT	      = 7;	       { Queue item is out of range	}
    _QUEUEFULL_PRT    = 8;	       { The queue is full		}
    _SPOOLBUSY_PRT    = 9;	       { PRINT spooler is busy		}

  procedure __InitPrt ( PortNo : byte; var Status : byte);
  procedure __StatPrt ( PortNo : byte; var Status : byte);
  procedure __BytePrt ( PortNo,
		       ByteVal : byte; var Status : byte);
  procedure __WrtPrt(	    PortNo : byte;
			       Str : string;
		     var NoWritten : byte;
			var Status : byte);
  function  __SpInsPrt : boolean;
  procedure __SpSubPrt(PathName : _Path; var ErrorCode : word);
  procedure __SpCanPrt(PathName : _Path; var ErrorCode : word);
  function  __SpLisPrt(  ItemNo : word;
		       var Size,
		      ErrorCode : word) : _Path;

implementation

  {$I initprt.imp }
  {$I statprt.imp }
  {$I byteprt.imp }
  {$I wrtprt.imp  }
  {$I spinsprt.imp}
  {$I spsubprt.imp}
  {$I spcanprt.imp}
  {$I splisprt.imp}

  end.
