{***********************************************************************}
{									}
{ UNIT_KEY Keyboard Functions						}
{									}
{ This unit implements the POWER TOOLS PLUS keyboard handling routines. }
{									}
{  _KeyStatus	Keyboard shift status record		     (type)	}
{  _Keys	Enumeration of key stroke combinations	     (type)	}
{  _KeyTable	Array of character and scan codes	     (constant) }
{									}
{ __ExInKey	Return a character and scan code			}
{ __ExRdyKey	Return a character and scan code if one is available	}
{ __Statkey	Return the keyboard status				}
{ __CtrlKey	Set the keyboard status 				}
{ __ReptKey	Set keyboard wait and repeat times			
{ __DosInKey	Return a character or extended character code (DOS)	}
{ __FlushKey	Flush the keyboard buffer (DOS) 			}
{ __FFlushKey	Fast flush of the keyboard buffer			}
{ __StuffKey	Place characters in the keyboard buffer directly	}
{ __QueueKey	Report the available space in the keyboard buffer	}
{ __PauseKey	Display a message and wait for a keystroke		}
{									}
{ Version 4.00 (C)Copyright Blaise Computing Inc.  1987 		}
{_______________________________________________________________________}

Unit Unit_Key;

interface
  uses DOS,			       { Turbo Pascal DOS unit		}
       Unit_Sup;		       { POWER TOOLS PLUS Support Unit	}

  type
    _KeyStatus = record 	     { Keyboard shift status record	}
		   _RightCtrlShift: boolean;  { Right Ctrl depressed	}
		   _RightAltShift : boolean;  { Right Alt  depressed	}
		   _InsState	  : boolean;  { Insert state is active	}
		   _CapsState	  : boolean;  { Caps Lock key toggled	}
		   _NumState	  : boolean;  { Num Lock key toggled	}
		   _ScrollState   : boolean;  { Scroll Lock key toggled }
		   _AltShift	  : boolean;  { Alt shift key depressed }
		   _CtrlShift	  : boolean;  { Ctrl shift depressed	}
		   _LeftShift	  : boolean;  { Left shift key depressed}
		   _RightShift	  : boolean;  { Right shift depressed	}
		   _InsShift	  : boolean;  { Ins key depressed	}
		   _CapsShift	  : boolean;  { Caps Lock key depressed }
		   _NumShift	  : boolean;  { Num Lock key depressed	}
		   _ScrollShift   : boolean;  { Scroll Lock depressed	}
		   _HoldState	  : boolean;  { Suspend state toggled	}
		   _SysShift	  : boolean;  { SysReq depressed & held }
		   _LeftCtrlShift : boolean;  { Left Ctrl depressed	}
		   _LeftAltShift  : boolean;  { Left Alt depressed	}
		 end;

    { The type _Keys enumerates all possible key combinations on the	}
    { IBM standard and enhanced (101/102) keyboard.  The naming 	}
    { convention is as follows: 					}
    {									}
    {		   _Key_X_name						}
    {									}
    { where _Key is a common prefix identifying the type, _X is the key }
    { combination type (it is not present for unshifted keys, and is	}
    { _s for Shift, _a for Alt, and _c for Ctrl combinations). _name is }
    { the key name and for the most part parallels the physical name on }
    { the keyboard.  For example					}
    {									}
    {		  _Key_a	:  a, lower case 'a' key		}
    {		  _Key_s_a	:  A, Shift/a				}
    {		  _Key_c_a	:  SOH, Ctrl/a combination		}
    {		  _Key_a_a	:  Alt/a  combination			}
    {		  _Key_pad_Home :  Home key on numeric keypad		}
    {		  _Key_Home	:  separate Home key on the enhanced	}
    {				   keyboard.				}
    {									}
    { Note that each member of _Keys represents a combination having a	}
    { unique character and scan code.  Thus key combinations having the }
    { same character and scan code are represented by the same _Keys	}
    { member.  For example the space bar and shift/space bar are repre- }
    { sented by _Key_space since both combination produce precisely the }
    { same character and scan code.					}
    {									}
    { _Keys together with _KeyTable makes it easy to recover the	}
    { character and scan code for any key combination; just index	}
    { _KeyTable with the appropriate _Keys member.  For example 	}
    {									}
    {	 _KeyTable[_Key_a]  is character $61 and scan code $1E		}
    {	 _KeyTable[_Key_F1] is character 0 and scan code $3B		}
    {									}
    { Finally, for convenience, the key combinations that produce the	}
    { standard (0 to 127) ASCII codes are enumerated first.  Therefore, }
    { if you wish the character and scan codes for the standard key	}
    { combination that produces the character with ASCII code N,	}
    { _KeyTable can be indexed as _KeyTable[_Keys(N)].			}

    _Keys = (_Key_c_2,		       { NUL	   Ctrl/2		}
	     _Key_c_a,		       { SOH	   Ctrl/a		}
	     _Key_c_b,		       { STX	   Ctrl/b		}
	     _Key_c_c,		       { ETX	   Ctrl/c		}
	     _Key_c_d,		       { EOT	   Ctrl/d		}
	     _Key_c_e,		       { ENQ	   Ctrl/e		}
	     _Key_c_f,		       { ACK	   Ctrl/f		}
	     _Key_c_g,		       { BEL	   Ctrl/g		}
	     _Key_c_h,		       { BS	   Ctrl/h		}
	     _Key_c_i,		       { HT	   Ctrl/i		}
	     _Key_c_j,		       { LF	   Ctrl/j		}
	     _Key_c_k,		       { VT	   Ctrl/k		}
	     _Key_c_l,		       { FF	   Ctrl/l		}
	     _Key_c_m,		       { CR	   Ctrl/m		}
	     _Key_c_n,		       { SO	   Ctrl/n		}
	     _Key_c_o,		       { SI	   Ctrl/o		}
	     _Key_c_p,		       { DLE	   Ctrl/p		}
	     _Key_c_q,		       { DC1	   Ctrl/q		}
	     _Key_c_r,		       { DC2	   Ctrl/r		}
	     _Key_c_s,		       { DC3	   Ctrl/s		}
	     _Key_c_t,		       { DC4	   Ctrl/t		}
	     _Key_c_u,		       { NAK	   Ctrl/u		}
	     _Key_c_v,		       { SYN	   Ctrl/v		}
	     _Key_c_w,		       { ETB	   Ctrl/w		}
	     _Key_c_x,		       { CAN	   Ctrl/x		}
	     _Key_c_y,		       { EM	   Ctrl/y		}
	     _Key_c_z,		       { SUB	   Ctrl/z		}
	     _Key_c_lbracket,	       { ESC	   Ctrl/[		}
	     _Key_c_backslash,	       { FS	   Ctrl/\		}
	     _Key_c_rbracket,	       { GS	   Ctrl/]		}
	     _Key_c_6,		       { RS	   Ctrl/6		}
	     _Key_c_minus,	       { US	   Ctrl/-		}
	     _Key_space,	       { space				}
	     _Key_s_1,		       { !				}
	     _Key_s_quote,	       { "				}
	     _Key_s_3,		       { #				}
	     _Key_s_4,		       { $				}
	     _Key_s_5,		       { %				}
	     _Key_s_7,		       { &				}
	     _Key_quote,	       { '				}
	     _Key_s_9,		       { (				}
	     _Key_s_0,		       { )				}
	     _Key_s_8,		       { *				}
	     _Key_s_equals,	       { +				}
	     _Key_comma,	       { ,				}
	     _Key_minus,	       { -				}
	     _Key_period,	       { .				}
	     _Key_slash,	       { /				}
	     _Key_0,		       { 0				}
	     _Key_1,		       { 1				}
	     _Key_2,		       { 2				}
	     _Key_3,		       { 3				}
	     _Key_4,		       { 4				}
	     _Key_5,		       { 5				}
	     _Key_6,		       { 6				}
	     _Key_7,		       { 7				}
	     _Key_8,		       { 8				}
	     _Key_9,		       { 9				}
	     _Key_s_semi,	       { :				}
	     _Key_semi, 	       { ;				}
	     _Key_s_comma,	       { <				}
	     _Key_equals,	       { =				}
	     _Key_s_period,	       { >				}
	     _Key_s_slash,	       { ?				}
	     _Key_s_2,		       { @				}
	     _Key_s_a,		       { A				}
	     _Key_s_b,		       { B				}
	     _Key_s_c,		       { C				}
	     _Key_s_d,		       { D				}
	     _Key_s_e,		       { E				}
	     _Key_s_f,		       { F				}
	     _Key_s_g,		       { G				}
	     _Key_s_h,		       { H				}
	     _Key_s_i,		       { I				}
	     _Key_s_j,		       { J				}
	     _Key_s_k,		       { K				}
	     _Key_s_l,		       { L				}
	     _Key_s_m,		       { M				}
	     _Key_s_n,		       { N				}
	     _Key_s_o,		       { O				}
	     _Key_s_p,		       { P				}
	     _Key_s_q,		       { Q				}
	     _Key_s_r,		       { R				}
	     _Key_s_s,		       { S				}
	     _Key_s_t,		       { T				}
	     _Key_s_u,		       { U				}
	     _Key_s_v,		       { V				}
	     _Key_s_w,		       { W				}
	     _Key_s_x,		       { X				}
	     _Key_s_y,		       { Y				}
	     _Key_s_z,		       { Z				}
	     _Key_lbracket,	       { [				}
	     _Key_backslash,	       { \				}
	     _Key_rbracket,	       { ]				}
	     _Key_s_6,		       { ^				}
	     _Key_s_minus,	       { _				}
	     _Key_backquote,	       { `				}
	     _Key_a,		       { a				}
	     _Key_b,		       { b				}
	     _Key_c,		       { c				}
	     _Key_d,		       { d				}
	     _Key_e,		       { e				}
	     _Key_f,		       { f				}
	     _Key_g,		       { g				}
	     _Key_h,		       { h				}
	     _Key_i,		       { i				}
	     _Key_j,		       { j				}
	     _Key_k,		       { k				}
	     _Key_l,		       { l				}
	     _Key_m,		       { m				}
	     _Key_n,		       { n				}
	     _Key_o,		       { o				}
	     _Key_p,		       { p				}
	     _Key_q,		       { q				}
	     _Key_r,		       { r				}
	     _Key_s,		       { s				}
	     _Key_t,		       { t				}
	     _Key_u,		       { u				}
	     _Key_v,		       { v				}
	     _Key_w,		       { w				}
	     _Key_x,		       { x				}
	     _Key_y,		       { y				}
	     _Key_z,		       { z				}
	     _Key_s_lbracket,	       { left curly brace		}
	     _Key_s_backslash,	       { |				}
	     _Key_s_rbracket,	       { right curly brace		}
	     _Key_s_backquote,	       { ~				}
	     _Key_c_Backspace,	       { DEL				}
				       { End of standard ASCII sequence }
	     _Key_Enter,	       { Enter				}
	     _Key_Esc,		       { Esc				}
	     _Key_Backspace,	       { Backspace			}
	     _Key_Tab,		       { Tab				}
	     _Key_F1,		       { F1				}
	     _Key_F2,		       { F2				}
	     _Key_F3,		       { F3				}
	     _Key_F4,		       { F4				}
	     _Key_F5,		       { F5				}
	     _Key_F6,		       { F6				}
	     _Key_F7,		       { F7				}
	     _Key_F8,		       { F8				}
	     _Key_F9,		       { F9				}
	     _Key_F10,		       { F10				}
	     _Key_F11,		       { F11		     (enhanced) }
	     _Key_F12,		       { F12		     (enhanced) }
	     _Key_asterisk,	       { *				}
	     _Key_pad_Home,	       { Home				}
	     _Key_pad_up,	       { Up arrow			}
	     _Key_pad_PgUp,	       { PgUp				}
	     _Key_pad_minus,	       { -				}
	     _Key_pad_left,	       { Left arrow			}
	     _Key_pad_center,	       { Center 	     (enhanced) }
	     _Key_pad_right,	       { Right arrow			}
	     _Key_pad_plus,	       { +				}
	     _Key_pad_End,	       { End				}
	     _Key_pad_down,	       { Down arrow			}
	     _Key_pad_PgDn,	       { PgDn				}
	     _Key_pad_Ins,	       { Ins				}
	     _Key_pad_Del,	       { Del				}
	     _Key_pad_45,	       { key45		     (enhanced) }
	     _Key_pad_Enter,	       { Enter		     (enhanced) }
	     _Key_pad_slash,	       { /		     (enhanced) }
	     _Key_Home, 	       { Home		     (enhanced) }
	     _Key_up,		       { Up		     (enhanced) }
	     _Key_PgUp, 	       { PgUp		     (enhanced) }
	     _Key_left, 	       { <-		     (enhanced) }
	     _Key_right,	       { ->		     (enhanced) }
	     _Key_End,		       { End		     (enhanced) }
	     _Key_down, 	       { Down		     (enhanced) }
	     _Key_PgDn, 	       { PgDn		     (enhanced) }
	     _Key_Ins,		       { Ins		     (enhanced) }
	     _Key_Del,		       { Del		     (enhanced) }
	     _Key_s_Tab,	       { Backtab			}
	     _Key_s_F1, 	       { Shift/F1			}
	     _Key_s_F2, 	       { Shift/F2			}
	     _Key_s_F3, 	       { Shift/F3			}
	     _Key_s_F4, 	       { Shift/F4			}
	     _Key_s_F5, 	       { Shift/F5			}
	     _Key_s_F6, 	       { Shift/F6			}
	     _Key_s_F7, 	       { Shift/F7			}
	     _Key_s_F8, 	       { Shift/F8			}
	     _Key_s_F9, 	       { Shift/F9			}
	     _Key_s_F10,	       { Shift/F10			}
	     _Key_s_F11,	       { Shift/F11	     (enhanced) }
	     _Key_s_F12,	       { Shift/F12	     (enhanced) }
	     _Key_s_pad_Home,	       { Shift/Home	   7		}
	     _Key_s_pad_up,	       { Shift/Up	   8		}
	     _Key_s_pad_PgUp,	       { Shift/PgUp	   9		}
	     _Key_s_pad_left,	       { Shift/left arrow  4		}
	     _Key_s_pad_center,        { Shift/center	     (enhanced) }
	     _Key_s_pad_right,	       { Shift/right arrow 6		}
	     _Key_s_pad_End,	       { Shift/End	   1		}
	     _Key_s_pad_down,	       { Shift/down arrow  2		}
	     _Key_s_pad_PgDn,	       { Shift/PgDn	   3		}
	     _Key_s_pad_Ins,	       { Shift/Ins	   0		}
	     _Key_s_pad_Del,	       { Shift/Del	   .		}
	     _Key_s_pad_45,	       { Shift/Key45	     (enhanced) }
	     _Key_c_Enter,	       { Ctrl/Enter Linefeed		}
	     _Key_c_Tab,	       { Ctrl/Tab	     (enhanced) }
	     _Key_c_F1, 	       { Ctrl/F1			}
	     _Key_c_F2, 	       { Ctrl/F2			}
	     _Key_c_F3, 	       { Ctrl/F3			}
	     _Key_c_F4, 	       { Ctrl/F4			}
	     _Key_c_F5, 	       { Ctrl/F5			}
	     _Key_c_F6, 	       { Ctrl/F6			}
	     _Key_c_F7, 	       { Ctrl/F7			}
	     _Key_c_F8, 	       { Ctrl/F8			}
	     _Key_c_F9, 	       { Ctrl/F9			}
	     _Key_c_F10,	       { Ctrl/F10			}
	     _Key_c_F11,	       { Ctrl/F11	     (enhanced) }
	     _Key_c_F12,	       { Ctrl/F12	     (enhanced) }
	     _Key_c_asterisk,	       { Ctrl/* 	     (enhanced) }
	     _Key_c_pad_Home,	       { Ctrl/Home			}
	     _Key_c_pad_up,	       { Ctrl/up arrow	     (enhanced) }
	     _Key_c_pad_PgUp,	       { Ctrl/PgUp			}
	     _Key_c_pad_minus,	       { Ctrl/- 	     (enhanced) }
	     _Key_c_pad_left,	       { Ctrl/left arrow		}
	     _Key_c_pad_center,        { Ctrl/center	     (enhanced) }
	     _Key_c_pad_right,	       { Ctrl/right arrow		}
	     _Key_c_pad_plus,	       { Ctrl/+ 	     (enhanced) }
	     _Key_c_pad_End,	       { Ctrl/End			}
	     _Key_c_pad_down,	       { Ctrl/down arrow     (enhanced) }
	     _Key_c_pad_PgDn,	       { Ctrl/PgDn			}
	     _Key_c_pad_Ins,	       { Ctrl/Ins	     (enhanced) }
	     _Key_c_pad_Del,	       { Ctrl/Del	     (enhanced) }
	     _Key_c_pad_Enter,	       { Ctrl/Enter	     (enhanced) }
	     _Key_c_pad_slash,	       { Ctrl/slash	     (enhanced) }
	     _Key_c_PrtSc,	       { Ctrl/PrtSc	     (enhanced) }
	     _Key_c_Break,	       { Ctrl/Break	     (enhanced) }
	     _Key_c_Home,	       { Ctrl/Home	     (enhanced) }
	     _Key_c_up, 	       { Ctrl/Up	     (enhanced) }
	     _Key_c_PgUp,	       { Ctrl/PgUp	     (enhanced) }
	     _Key_c_left,	       { Ctrl/left arrow     (enhanced) }
	     _Key_c_right,	       { Ctrl/right arrow    (enhanced) }
	     _Key_c_End,	       { Ctrl/End	     (enhanced) }
	     _Key_c_down,	       { Ctrl/down arrow     (enhanced) }
	     _Key_c_PgDn,	       { Ctrl/PgDn	     (enhanced) }
	     _Key_c_Ins,	       { Ctrl/Ins	     (enhanced) }
	     _Key_c_Del,	       { Ctrl/Del	     (enhanced) }
	     _Key_a_0,		       { Alt/0				}
	     _Key_a_1,		       { Alt/1				}
	     _Key_a_2,		       { Alt/2				}
	     _Key_a_3,		       { Alt/3				}
	     _Key_a_4,		       { Alt/4				}
	     _Key_a_5,		       { Alt/5				}
	     _Key_a_6,		       { Alt/6				}
	     _Key_a_7,		       { Alt/7				}
	     _Key_a_8,		       { Alt/8				}
	     _Key_a_9,		       { Alt/9				}
	     _Key_a_a,		       { Alt/A				}
	     _Key_a_b,		       { Alt/B				}
	     _Key_a_c,		       { Alt/C				}
	     _Key_a_d,		       { Alt/D				}
	     _Key_a_e,		       { Alt/E				}
	     _Key_a_f,		       { Alt/F				}
	     _Key_a_g,		       { Alt/G				}
	     _Key_a_h,		       { Alt/H				}
	     _Key_a_i,		       { Alt/I				}
	     _Key_a_j,		       { Alt/J				}
	     _Key_a_k,		       { Alt/K				}
	     _Key_a_l,		       { Alt/L				}
	     _Key_a_m,		       { Alt/M				}
	     _Key_a_n,		       { Alt/N				}
	     _Key_a_o,		       { Alt/O				}
	     _Key_a_p,		       { Alt/P				}
	     _Key_a_q,		       { Alt/Q				}
	     _Key_a_r,		       { Alt/R				}
	     _Key_a_s,		       { Alt/S				}
	     _Key_a_t,		       { Alt/T				}
	     _Key_a_u,		       { Alt/U				}
	     _Key_a_v,		       { Alt/V				}
	     _Key_a_w,		       { Alt/W				}
	     _Key_a_x,		       { Alt/X				}
	     _Key_a_y,		       { Alt/Y				}
	     _Key_a_z,		       { Alt/Z				}
	     _Key_a_Esc,	       { Alt/Esc	     (enhanced) }
	     _Key_a_minus,	       { Alt/-				}
	     _Key_a_equals,	       { Alt/=				}
	     _Key_a_Backspace,	       { Alt/Backspace	     (enhanced) }
	     _Key_a_Tab,	       { Alt/Tab	     (enhanced) }
	     _Key_a_lbracket,	       { Alt/[		     (enhanced) }
	     _Key_a_rbracket,	       { Alt/]		     (enhanced) }
	     _Key_a_Enter,	       { Alt/Enter	     (enhanced) }
	     _Key_a_semi,	       { Alt/;		     (enhanced) }
	     _Key_a_quote,	       { Alt/'		     (enhanced) }
	     _Key_a_backquote,	       { Alt/`		     (enhanced) }
	     _Key_a_backslash,	       { Alt/\		     (enhanced) }
	     _Key_a_comma,	       { Alt/,		     (enhanced) }
	     _Key_a_period,	       { Alt/.		     (enhanced) }
	     _Key_a_slash,	       { Alt/slash	     (enhanced) }
	     _Key_a_asterisk,	       { Alt/*		     (enhanced) }
	     _Key_a_F1, 	       { Alt/F1 			}
	     _Key_a_F2, 	       { Alt/F2 			}
	     _Key_a_F3, 	       { Alt/F3 			}
	     _Key_a_F4, 	       { Alt/F4 			}
	     _Key_a_F5, 	       { Alt/F5 			}
	     _Key_a_F6, 	       { Alt/F6 			}
	     _Key_a_F7, 	       { Alt/F7 			}
	     _Key_a_F8, 	       { Alt/F8 			}
	     _Key_a_F9, 	       { Alt/F9 			}
	     _Key_a_F10,	       { Alt/F10			}
	     _Key_a_F11,	       { Alt/F11	     (enhanced) }
	     _Key_a_F12,	       { Alt/F12	     (enhanced) }
	     _Key_a_pad_minus,	       { Alt/-		     (enhanced) }
	     _Key_a_pad_plus,	       { Alt/+		     (enhanced) }
	     _Key_a_pad_Enter,	       { Alt/Enter	     (enhanced) }
	     _Key_a_pad_slash,	       { Alt/slash	     (enhanced) }
	     _Key_a_Home,	       { Alt/Home	     (enhanced) }
	     _Key_a_Up, 	       { Alt/up arrow	     (enhanced) }
	     _Key_a_PgUp,	       { Alt/PgUp	     (enhanced) }
	     _Key_a_left,	       { Alt/left arrow      (enhanced) }
	     _Key_a_right,	       { Alt/right arrow     (enhanced) }
	     _Key_a_End,	       { Alt/End	     (enhanced) }
	     _Key_a_down,	       { Alt/down arrow      (enhanced) }
	     _Key_a_PgDn,	       { Alt/PgDn	     (enhanced) }
	     _Key_a_Ins,	       { Alt/Ins	     (enhanced) }
	     _Key_a_Del);	       { Alt/Del	     (enhanced) }


  { _KeyTable is an array of character and scan codes generated by the	}
  { key combinations on the IBM keyboards.  The index is of type _Keys. }
  { _KeyTable provides an easy way to lookup the character and scan	}
  { codes for any key combination.					}

  const
    _KeyTable : array[_Keys] of _KeySeq =
		 ((_ChScan : $0300),   { _Key_c_2			}
		  (_ChScan : $1E01),   { _Key_c_a			}
		  (_ChScan : $3002),   { _Key_c_b			}
		  (_ChScan : $2E03),   { _Key_c_c			}
		  (_ChScan : $2004),   { _Key_c_d			}
		  (_ChScan : $1205),   { _Key_c_e			}
		  (_ChScan : $2106),   { _Key_c_f			}
		  (_ChScan : $2207),   { _Key_c_g			}
		  (_ChScan : $2308),   { _Key_c_h			}
		  (_ChScan : $1709),   { _Key_c_i			}
		  (_ChScan : $240A),   { _Key_c_j			}
		  (_ChScan : $250B),   { _Key_c_k			}
		  (_ChScan : $260C),   { _Key_c_l			}
		  (_ChScan : $320D),   { _Key_c_m			}
		  (_ChScan : $310E),   { _Key_c_n			}
		  (_ChScan : $180F),   { _Key_c_o			}
		  (_ChScan : $1910),   { _Key_c_p			}
		  (_ChScan : $1011),   { _Key_c_q			}
		  (_ChScan : $1312),   { _Key_c_r			}
		  (_ChScan : $1F13),   { _Key_c_s			}
		  (_ChScan : $1414),   { _Key_c_t			}
		  (_ChScan : $1615),   { _Key_c_u			}
		  (_ChScan : $2F16),   { _Key_c_v			}
		  (_ChScan : $1117),   { _Key_c_w			}
		  (_ChScan : $2D18),   { _Key_c_x			}
		  (_ChScan : $1519),   { _Key_c_y			}
		  (_ChScan : $2C1A),   { _Key_c_z			}
		  (_ChScan : $1A1B),   { _Key_c_lbracket		}
		  (_ChScan : $2B1C),   { _Key_c_backslash		}
		  (_ChScan : $1B1D),   { _Key_c_rbracket		}
		  (_ChScan : $071E),   { _Key_c_6			}
		  (_ChScan : $0C1F),   { _Key_c_minus			}
		  (_ChScan : $3920),   { _Key_space			}
		  (_ChScan : $0221),   { _Key_s_1			}
		  (_ChScan : $2822),   { _Key_s_quote			}
		  (_ChScan : $0423),   { _Key_s_3			}
		  (_ChScan : $0524),   { _Key_s_4			}
		  (_ChScan : $0625),   { _Key_s_5			}
		  (_ChScan : $0826),   { _Key_s_7			}
		  (_ChScan : $2827),   { _Key_quote			}
		  (_ChScan : $0A28),   { _Key_s_9			}
		  (_ChScan : $0B29),   { _Key_s_0			}
		  (_ChScan : $092A),   { _Key_s_8			}
		  (_ChScan : $0D2B),   { _Key_s_equals			}
		  (_ChScan : $332C),   { _Key_comma			}
		  (_ChScan : $0C2D),   { _Key_minus			}
		  (_ChScan : $342E),   { _Key_period			}
		  (_ChScan : $352F),   { _Key_slash			}
		  (_ChScan : $0B30),   { _Key_0 			}
		  (_ChScan : $0231),   { _Key_1 			}
		  (_ChScan : $0332),   { _Key_2 			}
		  (_ChScan : $0433),   { _Key_3 			}
		  (_ChScan : $0534),   { _Key_4 			}
		  (_ChScan : $0635),   { _Key_5 			}
		  (_ChScan : $0736),   { _Key_6 			}
		  (_ChScan : $0837),   { _Key_7 			}
		  (_ChScan : $0938),   { _Key_8 			}
		  (_ChScan : $0A39),   { _Key_9 			}
		  (_ChScan : $273A),   { _Key_s_semi			}
		  (_ChScan : $273B),   { _Key_semi			}
		  (_ChScan : $333C),   { _Key_s_comma			}
		  (_ChScan : $0D3D),   { _Key_equals			}
		  (_ChScan : $343E),   { _Key_s_period			}
		  (_ChScan : $353F),   { _Key_s_slash			}
		  (_ChScan : $0340),   { _Key_s_2			}
		  (_ChScan : $1E41),   { _Key_s_a			}
		  (_ChScan : $3042),   { _Key_s_b			}
		  (_ChScan : $2E43),   { _Key_s_c			}
		  (_ChScan : $2044),   { _Key_s_d			}
		  (_ChScan : $1245),   { _Key_s_e			}
		  (_ChScan : $2146),   { _Key_s_f			}
		  (_ChScan : $2247),   { _Key_s_g			}
		  (_ChScan : $2348),   { _Key_s_h			}
		  (_ChScan : $1749),   { _Key_s_i			}
		  (_ChScan : $244A),   { _Key_s_j			}
		  (_ChScan : $254B),   { _Key_s_k			}
		  (_ChScan : $264C),   { _Key_s_l			}
		  (_ChScan : $324D),   { _Key_s_m			}
		  (_ChScan : $314E),   { _Key_s_n			}
		  (_ChScan : $184F),   { _Key_s_o			}
		  (_ChScan : $1950),   { _Key_s_p			}
		  (_ChScan : $1051),   { _Key_s_q			}
		  (_ChScan : $1352),   { _Key_s_r			}
		  (_ChScan : $1F53),   { _Key_s_s			}
		  (_ChScan : $1454),   { _Key_s_t			}
		  (_ChScan : $1655),   { _Key_s_u			}
		  (_ChScan : $2F56),   { _Key_s_v			}
		  (_ChScan : $1157),   { _Key_s_w			}
		  (_ChScan : $2D58),   { _Key_s_x			}
		  (_ChScan : $1559),   { _Key_s_y			}
		  (_ChScan : $2C5A),   { _Key_s_z			}
		  (_ChScan : $1A5B),   { _Key_lbracket			}
		  (_ChScan : $2B5C),   { _Key_backslash 		}
		  (_ChScan : $1B5D),   { _Key_rbracket			}
		  (_ChScan : $075E),   { _Key_s_6			}
		  (_ChScan : $0C5F),   { _Key_s_minus			}
		  (_ChScan : $2960),   { _Key_backquote 		}
		  (_ChScan : $1E61),   { _Key_a 			}
		  (_ChScan : $3062),   { _Key_b 			}
		  (_ChScan : $2E63),   { _Key_c 			}
		  (_ChScan : $2064),   { _Key_d 			}
		  (_ChScan : $1265),   { _Key_e 			}
		  (_ChScan : $2166),   { _Key_f 			}
		  (_ChScan : $2267),   { _Key_g 			}
		  (_ChScan : $2368),   { _Key_h 			}
		  (_ChScan : $1769),   { _Key_i 			}
		  (_ChScan : $246A),   { _Key_j 			}
		  (_ChScan : $256B),   { _Key_k 			}
		  (_ChScan : $266C),   { _Key_l 			}
		  (_ChScan : $326D),   { _Key_m 			}
		  (_ChScan : $316E),   { _Key_n 			}
		  (_ChScan : $186F),   { _Key_o 			}
		  (_ChScan : $1970),   { _Key_p 			}
		  (_ChScan : $1071),   { _Key_q 			}
		  (_ChScan : $1372),   { _Key_r 			}
		  (_ChScan : $1F73),   { _Key_s 			}
		  (_ChScan : $1474),   { _Key_t 			}
		  (_ChScan : $1675),   { _Key_u 			}
		  (_ChScan : $2F76),   { _Key_v 			}
		  (_ChScan : $1177),   { _Key_w 			}
		  (_ChScan : $2D78),   { _Key_x 			}
		  (_ChScan : $1579),   { _Key_y 			}
		  (_ChScan : $2C7A),   { _Key_z 			}
		  (_ChScan : $1A7B),   { _Key_s_lbracket		}
		  (_ChScan : $2B7C),   { _Key_s_backslash		}
		  (_ChScan : $1B7D),   { _Key_s_rbracket     (enhanced) }
		  (_ChScan : $297E),   { _Key_s_backquote		}
		  (_ChScan : $0E7F),   { _Key_c_backspace		}
		  (_ChScan : $1C0D),   { _Key_Enter			}
		  (_ChScan : $011B),   { _Key_Esc			}
		  (_ChScan : $0E08),   { _Key_Backspace 		}
		  (_ChScan : $0F09),   { _Key_Tab			}
		  (_ChScan : $3B00),   { _Key_F1			}
		  (_ChScan : $3C00),   { _Key_F2			}
		  (_ChScan : $3D00),   { _Key_F3			}
		  (_ChScan : $3E00),   { _Key_F4			}
		  (_ChScan : $3F00),   { _Key_F5			}
		  (_ChScan : $4000),   { _Key_F6			}
		  (_ChScan : $4100),   { _Key_F7			}
		  (_ChScan : $4200),   { _Key_F8			}
		  (_ChScan : $4300),   { _Key_F9			}
		  (_ChScan : $4400),   { _Key_F10			}
		  (_ChScan : $8500),   { _Key_F11	     (enhanced) }
		  (_ChScan : $8600),   { _Key_F12	     (enhanced) }
		  (_ChScan : $372A),   { _Key_asterisk			}
		  (_ChScan : $4700),   { _Key_pad_Home			}
		  (_ChScan : $4800),   { _Key_pad_up			}
		  (_ChScan : $4900),   { _Key_pad_PgUp			}
		  (_ChScan : $4A2D),   { _Key_pad_minus 		}
		  (_ChScan : $4B00),   { _Key_pad_left			}
		  (_ChScan : $4C00),   { _Key_pad_center		}
		  (_ChScan : $4D00),   { _Key_pad_right 		}
		  (_ChScan : $4E2B),   { _Key_pad_plus			}
		  (_ChScan : $4F00),   { _Key_pad_End			}
		  (_ChScan : $5000),   { _Key_pad_down			}
		  (_ChScan : $5100),   { _Key_pad_PgDn			}
		  (_ChScan : $5200),   { _Key_pad_Ins			}
		  (_ChScan : $5300),   { _Key_pad_Del			}
		  (_ChScan : $565C),   { _Key_pad_45	     (enhanced) }
		  (_ChScan : $E00D),   { _Key_pad_Enter      (enhanced) }
		  (_ChScan : $E02F),   { _Key_pad_slash      (enhanced) }
		  (_ChScan : $47E0),   { _Key_Home	     (enhanced) }
		  (_ChScan : $48E0),   { _Key_up	     (enhanced) }
		  (_ChScan : $49E0),   { _Key_PgUp	     (enhanced) }
		  (_ChScan : $4BE0),   { _Key_left	     (enhanced) }
		  (_ChScan : $4DE0),   { _Key_right	     (enhanced) }
		  (_ChScan : $4FE0),   { _Key_End	     (enhanced) }
		  (_ChScan : $50E0),   { _Key_down	     (enhanced) }
		  (_ChScan : $51E0),   { _Key_PgDn	     (enhanced) }
		  (_ChScan : $52E0),   { _Key_Ins	     (enhanced) }
		  (_ChScan : $53E0),   { _Key_Del	     (enhanced) }
		  (_ChScan : $0F00),   { _Key_s_Tab			}
		  (_ChScan : $5400),   { _Key_s_F1			}
		  (_ChScan : $5500),   { _Key_s_F2			}
		  (_ChScan : $5600),   { _Key_s_F3			}
		  (_ChScan : $5700),   { _Key_s_F4			}
		  (_ChScan : $5800),   { _Key_s_F5			}
		  (_ChScan : $5900),   { _Key_s_F6			}
		  (_ChScan : $5A00),   { _Key_s_F7			}
		  (_ChScan : $5B00),   { _Key_s_F8			}
		  (_ChScan : $5C00),   { _Key_s_F9			}
		  (_ChScan : $5D00),   { _Key_s_F10			}
		  (_ChScan : $8700),   { _Key_s_F11	     (enhanced) }
		  (_ChScan : $8800),   { _Key_s_F12	     (enhanced) }
		  (_ChScan : $4737),   { _Key_s_pad_Home		}
		  (_ChScan : $4838),   { _Key_s_pad_up			}
		  (_ChScan : $4939),   { _Key_s_pad_PgUp		}
		  (_ChScan : $4B34),   { _Key_s_pad_left		}
		  (_ChScan : $4C35),   { _Key_s_pad_center		}
		  (_ChScan : $4D36),   { _Key_s_pad_right		}
		  (_ChScan : $4F31),   { _Key_s_pad_End 		}
		  (_ChScan : $5032),   { _Key_s_pad_down		}
		  (_ChScan : $5133),   { _Key_s_pad_PgDn		}
		  (_ChScan : $5230),   { _Key_s_pad_Ins 		}
		  (_ChScan : $532E),   { _Key_s_pad_Del 		}
		  (_ChScan : $567C),   { _Key_s_pad_45	     (enhanced) }
		  (_ChScan : $1C0A),   { _Key_c_Enter			}
		  (_ChScan : $9400),   { _Key_c_Tab	     (enhanced) }
		  (_ChScan : $5E00),   { _Key_c_F1			}
		  (_ChScan : $5F00),   { _Key_c_F2			}
		  (_ChScan : $6000),   { _Key_c_F3			}
		  (_ChScan : $6100),   { _Key_c_F4			}
		  (_ChScan : $6200),   { _Key_c_F5			}
		  (_ChScan : $6300),   { _Key_c_F6			}
		  (_ChScan : $6400),   { _Key_c_F7			}
		  (_ChScan : $6500),   { _Key_c_F8			}
		  (_ChScan : $6600),   { _Key_c_F9			}
		  (_ChScan : $6700),   { _Key_c_F10			}
		  (_ChScan : $8900),   { _Key_c_F11	     (enhanced) }
		  (_ChScan : $8A00),   { _Key_c_F12	     (enhanced) }
		  (_ChScan : $9600),   { _Key_c_asterisk     (enhanced) }
		  (_ChScan : $7700),   { _Key_c_pad_Home		}
		  (_ChScan : $8D00),   { _Key_c_pad_up	     (enhanced) }
		  (_ChScan : $8400),   { _Key_c_pad_PgUp		}
		  (_ChScan : $8E00),   { _Key_c_pad_minus    (enhanced) }
		  (_ChScan : $7300),   { _Key_c_pad_left		}
		  (_ChScan : $8F00),   { _Key_c_pad_center   (enhanced) }
		  (_ChScan : $7400),   { _Key_c_pad_right		}
		  (_ChScan : $9000),   { _Key_c_pad_plus     (enhanced) }
		  (_ChScan : $7500),   { _Key_c_pad_End 		}
		  (_ChScan : $9100),   { _Key_c_pad_down     (enhanced) }
		  (_ChScan : $7600),   { _Key_c_pad_PgDn		}
		  (_ChScan : $9200),   { _Key_c_pad_Ins      (enhanced) }
		  (_ChScan : $9300),   { _Key_c_pad_Del      (enhanced) }
		  (_ChScan : $E00A),   { _Key_c_pad_Enter    (enhanced) }
		  (_ChScan : $9500),   { _Key_c_pad_slash    (enhanced) }
		  (_ChScan : $7200),   { _Key_c_PrtSc	     (enhanced) }
		  (_ChScan : $0000),   { _Key_c_Break	     (enhanced) }
		  (_ChScan : $77E0),   { _Key_c_Home	     (enhanced) }
		  (_ChScan : $8DE0),   { _Key_c_up	     (enhanced) }
		  (_ChScan : $84E0),   { _Key_c_PgUp	     (enhanced) }
		  (_ChScan : $73E0),   { _Key_c_left	     (enhanced) }
		  (_ChScan : $74E0),   { _Key_c_right	     (enhanced) }
		  (_ChScan : $75E0),   { _Key_c_End	     (enhanced) }
		  (_ChScan : $91E0),   { _Key_c_down	     (enhanced) }
		  (_ChScan : $76E0),   { _Key_c_PgDn	     (enhanced) }
		  (_ChScan : $92E0),   { _Key_c_Ins	     (enhanced) }
		  (_ChScan : $93E0),   { _Key_c_Del	     (enhanced) }
		  (_ChScan : $8100),   { _Key_a_0			}
		  (_ChScan : $7800),   { _Key_a_1			}
		  (_ChScan : $7900),   { _Key_a_2			}
		  (_ChScan : $7A00),   { _Key_a_3			}
		  (_ChScan : $7B00),   { _Key_a_4			}
		  (_ChScan : $7C00),   { _Key_a_5			}
		  (_ChScan : $7D00),   { _Key_a_6			}
		  (_ChScan : $7E00),   { _Key_a_7			}
		  (_ChScan : $7F00),   { _Key_a_8			}
		  (_ChScan : $8000),   { _Key_a_9			}
		  (_ChScan : $1E00),   { _Key_a_a			}
		  (_ChScan : $3000),   { _Key_a_b			}
		  (_ChScan : $2E00),   { _Key_a_c			}
		  (_ChScan : $2000),   { _Key_a_d			}
		  (_ChScan : $1200),   { _Key_a_e			}
		  (_ChScan : $2100),   { _Key_a_f			}
		  (_ChScan : $2200),   { _Key_a_g			}
		  (_ChScan : $2300),   { _Key_a_h			}
		  (_ChScan : $1700),   { _Key_a_i			}
		  (_ChScan : $2400),   { _Key_a_j			}
		  (_ChScan : $2500),   { _Key_a_k			}
		  (_ChScan : $2600),   { _Key_a_l			}
		  (_ChScan : $3200),   { _Key_a_m			}
		  (_ChScan : $3100),   { _Key_a_n			}
		  (_ChScan : $1800),   { _Key_a_o			}
		  (_ChScan : $1900),   { _Key_a_p			}
		  (_ChScan : $1000),   { _Key_a_q			}
		  (_ChScan : $1300),   { _Key_a_r			}
		  (_ChScan : $1F00),   { _Key_a_s			}
		  (_ChScan : $1400),   { _Key_a_t			}
		  (_ChScan : $1600),   { _Key_a_u			}
		  (_ChScan : $2F00),   { _Key_a_v			}
		  (_ChScan : $1100),   { _Key_a_w			}
		  (_ChScan : $2D00),   { _Key_a_x			}
		  (_ChScan : $1500),   { _Key_a_y			}
		  (_ChScan : $2C00),   { _Key_a_z			}
		  (_ChScan : $0100),   { _Key_a_Esc	     (enhanced) }
		  (_ChScan : $8200),   { _Key_a_minus			}
		  (_ChScan : $8300),   { _Key_a_equals			}
		  (_ChScan : $0E00),   { _Key_a_Backspace    (enhanced) }
		  (_ChScan : $A500),   { _Key_a_Tab	     (enhanced) }
		  (_ChScan : $1A00),   { _Key_a_lbracket     (enhanced) }
		  (_ChScan : $1B00),   { _Key_a_rbracket     (enhanced) }
		  (_ChScan : $1C00),   { _Key_a_Enter	     (enhanced) }
		  (_ChScan : $2700),   { _Key_a_semi	     (enhanced) }
		  (_ChScan : $2800),   { _Key_a_quote	     (enhanced) }
		  (_ChScan : $2900),   { _Key_a_backquote    (enhanced) }
		  (_ChScan : $2B00),   { _Key_a_backslash    (enhanced) }
		  (_ChScan : $3300),   { _Key_a_comma	     (enhanced) }
		  (_ChScan : $3400),   { _Key_a_period	     (enhanced) }
		  (_ChScan : $3500),   { _Key_a_slash	     (enhanced) }
		  (_ChScan : $3700),   { _Key_a_asterisk     (enhanced) }
		  (_ChScan : $6800),   { _Key_a_F1			}
		  (_ChScan : $6900),   { _Key_a_F2			}
		  (_ChScan : $6A00),   { _Key_a_F3			}
		  (_ChScan : $6B00),   { _Key_a_F4			}
		  (_ChScan : $6C00),   { _Key_a_F5			}
		  (_ChScan : $6D00),   { _Key_a_F6			}
		  (_ChScan : $6E00),   { _Key_a_F7			}
		  (_ChScan : $6F00),   { _Key_a_F8			}
		  (_ChScan : $7000),   { _Key_a_F9			}
		  (_ChScan : $7100),   { _Key_a_F10			}
		  (_ChScan : $8B00),   { _Key_a_F11			}
		  (_ChScan : $8C00),   { _Key_a_F12			}
		  (_ChScan : $4A00),   { _Key_a_pad_minus    (enhanced) }
		  (_ChScan : $4E00),   { _Key_a_pad_plus     (enhanced) }
		  (_ChScan : $A600),   { _Key_a_pad_Enter    (enhanced) }
		  (_ChScan : $A400),   { _Key_a_pad_slash    (enhanced) }
		  (_ChScan : $9700),   { _Key_a_Home	     (enhanced) }
		  (_ChScan : $9800),   { _Key_a_up	     (enhanced) }
		  (_ChScan : $9900),   { _Key_a_PgUp	     (enhanced) }
		  (_ChScan : $9B00),   { _Key_a_left	     (enhanced) }
		  (_ChScan : $9D00),   { _Key_a_right	     (enhanced) }
		  (_ChScan : $9F00),   { _Key_a_End	     (enhanced) }
		  (_ChScan : $A000),   { _Key_a_down	     (enhanced) }
		  (_ChScan : $A100),   { _Key_a_PgDn	     (enhanced) }
		  (_ChScan : $A200),   { _Key_a_Ins	     (enhanced) }
		  (_ChScan : $A300));  { _Key_a_Del	     (enhanced) }


  function  __ExInKey (UseExtended: boolean;var ScanCode : byte) : char;
  function  __ExRdyKey(UseExtended : boolean;
			var ThisCh : char;
		      var ScanCode : byte) : boolean;
  function  __StatKey (var Status : _KeyStatus) : longint;
  function  __CtrlKey (Status : _KeyStatus) : longint;
  procedure __ReptKey (Rate, Delay: real);
  function  __DosInKey(var ExtendedCode : byte) : char;
  procedure __FlushKey;
  procedure __FFlshKey;
  function  __StuffKey(CharStr : string) : string;
  function  __QueueKey : word;
  function  __PauseKey(Message : string) : word;

implementation

  {$I exinkey.imp}
  {$I exrdykey.imp}
  {$I statkey.imp}
  {$I ctrlkey.imp}
  {$I reptkey.imp}
  {$I dosinkey.imp}
  {$I flushkey.imp}
  {$I fflshkey.imp}
  {$I stuffkey.imp}
  {$I queuekey.imp}
  {$I pausekey.imp}

  end.
