{***********************************************************************}
{									}
{ UNIT_FIL  File Handling						}
{									}
{ This unit provides support for general file handling and directory	}
{ maintenance.								}
{									}
{  _STDIN	Standard input file handle		     (constant) }
{  _STDOUT	Standard output file handle		     (constant) }
{  _STDERR	Standard error file handle		     (constant) }
{  _STDAUX	Standard auxiliary (COM1) file handle	     (constant) }
{  _STDPRN	Standard printer (PRN) file handle	     (constant) }
{									}
{  _GENERAL	General, no special file attribute	     (constant) }
{  _READ	Read only file				     (constant) }
{  _HIDDEN	Hidden file				     (constant) }
{  _SYSTEM	System file				     (constant) }
{  _VOLUME	Volume label				     (constant) }
{  _DIR 	Subdirectory				     (constant) }
{  _ARCHIVE	File altered since last backed up	     (constant) }
{  _ANYFILE	Combination of all attributes		     (constant) }
{									}
{  _READONLY	Read only file access			     (constant) }
{  _WRITEONLY	Write only file access			     (constant) }
{  _READWRITE	Read and write file access		     (constant) }
{  _COMPATIBLE	Compatibility file sharing mode 	     (constant) }
{  _EXCLUSIVE	Exclusive (deny read/write) sharing mode     (constant) }
{  _DENYWRITE	Deny write file opens			     (constant) }
{  _DENYREAD	Deny read file opens			     (constant) }
{  _DENYNONE	Allow read and write file opens 	     (constant) }
{  _INHERIT	File is inherited by child processes	     (constant) }
{  _PRIVATE	File is private to the process		     (constant) }
{									}
{ __HandlFil	Return the DOS file handle of a Pascal file		}
{ __StdIOFil	Open a text file as a standard DOS device		}
{ __StdIFil	Reopen Input as standard input				}
{ __StdOFil	Reopen Output as standard output			}
{ __IsConFil	Detect if a file is associated with the console 	}
{ __ExistFil	Detect the presence of a file				}
{ __ExEnvFil	Detect the presence of a file in a subdirectory list	}
{ __FlushFil	Flush all buffered data to be written to the file	}
{ __SetAtFil	Set file attributes					}
{ __RetAtFil	Return file attributes					}
{ __VerfyFil	Inspect or alter the verify flag			}
{ __MaxHnFil	Set the maximum number of available file handles	}
{ __IsDrvFil	Determine if a physical drive is available and ready	}
{ __SetDrFil	Set the default disk drive				}
{ __RetDrFil	Return the default disk drive				}
{ __SetDTFil	Set the disk transfer area (DTA)			}
{ __RetDTFil	Return the disk transfer area (DTA)			}
{ __SetVlFil	Create or alter the volume label			}
{ __RetVlFil	Return the volume label 				}
{ __RetryFil	Set the number of sharing retry operations		}
{ __LockFil	Lock a portion of a file				}
{ __UnLocFil	Release a lock on a portion of a file			}
{									}
{ Version 4.00	(C)Copyright Blaise Computing Inc.  1987		}
{_______________________________________________________________________}

unit Unit_Fil;

interface
  uses DOS,			       { Turbo Pascal DOS unit		}
       Unit_Sup,		       { POWER TOOLS PLUS Support unit	}
       Unit_Utl;		       { POWER TOOLS PLUS Utility unit	}

  const
    _STDIN	= 0;		       { Standard input 		}
    _STDOUT	= 1;		       { Standard output		}
    _STDERR	= 2;		       { Standard error 		}
    _STDAUX	= 3;		       { Standard auxiliary (COM1)	}
    _STDPRN	= 4;		       { Standard printer (PRN or LST1) }
				       { File attributes		}
    _GENERAL	= $00;		       { General, no attribute		}
    _READ	= $01;		       { Read only  file		}
    _HIDDEN	= $02;		       { Hidden file			}
    _SYSTEM	= $04;		       { System file			}
    _VOLUME	= $08;		       { Volume label			}
    _DIR	= $10;		       { Subdirectory			}
    _ARCHIVE	= $20;		       { File altered since last backup }
    _ANYFILE	= $3F;		       { Combination of all attributes	}

				       { File access modes		}
    _READONLY	= $00;		       { Read only			}
    _WRITEONLY	= $01;		       { Write only			}
    _READWRITE	= $02;		       { Read and write 		}
				       { File sharing modes		}
    _COMPATIBLE = $00;		       { Compatibility mode		}
    _EXCLUSIVE	= $10;		       { Exclusive (Deny read/write)	}
    _DENYWRITE	= $20;		       { Deny write file opens		}
    _DENYREAD	= $30;		       { Deny read file opens		}
    _DENYNONE	= $40;		       { Allow read and write file open }
				       { File inheritance modes 	}
    _INHERIT	= $00;		       { File is inherited by child	}
    _PRIVATE	= $80;		       { File is private to process	}

  function  __HandlFil(var FileVar) : word;
  procedure __StdIOFil(var TextFile : text;
			  StdDevice : word;
		      var ErrorCode : word);
  procedure __StdIFil;
  procedure __StdOFil;
  function  __IsConFil(  Handle : word)  : boolean;
  function  __ExistFil(PathName : _Path) : boolean;
{  function  __ExEnvFil(FileName : _Path;
			 EnvVar : string;
		   var FilePath : _Path) : boolean;}
  procedure __FlushFil(  Handle : word; var ErrorCode : word);
  procedure __SetAtFil(PathName : _Path;
		       FileAttr : byte;
		  var ErrorCode : word);
  procedure __RetAtFil(PathName : _Path;
		   var FileAttr : byte;
		  var ErrorCode : word);
  function  __VerfyFil(SetFlag,FlagValue : boolean) : boolean;
  procedure __MaxHnFil(NoHandles : word; var ErrorCode : word);
  function  __IsDrvFil(Drive : char; var ErrorCode : word) : boolean;
  function  __SetDrFil(Drive : char) : word;
  function  __RetDrFil : char;
  procedure __SetDTFil(DTAAddress : pointer);
  function  __RetDTFil : pointer;
  function  __SetVlFil(Drive : char; VolLabel : string) : boolean;
  function  __RetVlFil(Drive : char; var VolStamp : longint) : string;
  procedure __RetryFil(TimeLoops,Retries : word;
			   var ErrorCode : word);
  procedure __LockFil (Handle : word; FilePos,FileLen : longint;
					var ErrorCode : word);
  procedure __UnLocFil(Handle: word; FilePos, FileLen : longint;
					var ErrorCode : word);

implementation

  {$I handlfil.imp}
  {$I stdiofil.imp}
  {$I stdifil.imp }
  {$I stdofil.imp }
  {$I isconfil.imp}
  {$I existfil.imp}
  {I exenvfil.imp}
  {$I flushfil.imp}
  {$I setatfil.imp}
  {$I retatfil.imp}
  {$I verfyfil.imp}
  {$I maxhnfil.imp}

  {$L rdsector.obj}		       { Used by __IsDrvFil		}
  procedure RdSector(DriveNo : word; var ErrorCode : word); external;
  {$I isdrvfil.imp}

  {$I setdrfil.imp}
  {$I retdrfil.imp}
  {$I setdtfil.imp}
  {$I retdtfil.imp}
  {$I setvlfil.imp}
  {$I retvlfil.imp}
  {$I retryfil.imp}
  {$I lockfil.imp }
  {$I unlocfil.imp}

  end.
