{
			  T P L U S   U N I T
 }

UNIT TPlus;
{$S-}
INTERFACE

USES Crt,Dos;



{    This file is the interface section for the compiled TPLUS UNIT.
     The second part of this file contains corrections and additions
     to the printed manual involving the TPLUS UNIT.  Refer to this
     material for the most current information.                          }


	   {++++++++++++++++++++++++++++++++++++++++++++++++}
	   {                                                }
	   {               Turbo Plus Vers 5.5              }
	   {               TPLUS Unit Interface             }
	   {                                                }
	   {       Copyright (c) 1988 by Nostradamus Inc.   }
	   {                                                }
	   {++++++++++++++++++++++++++++++++++++++++++++++++}


TYPE String1  = STRING [1];  { For ReadKb Access }
     String2  = STRING [2];  { For Byte to Hex }
     String6  = STRING [6];  { For key converts, etc. }
     String11 = STRING [11]; { For DOS volume labels, etc. }
     String65 = STRING [65]; { When Accessing DOS paths, max length is 65 }
     String80 = STRING [80]; { Generic, screen-oriented string }
     AnyStr   = STRING [255];{ Max. allowed string length in Turbo }

     { A pointer and array mapping video memory }
     DisplayPointer = ^DisplayArray;
     DisplayArray = ARRAY [1..50] OF ARRAY [1..80] OF ARRAY [1..2] OF BYTE;

     InterventionProc = Procedure;
     BorderStyle = Byte;


CONST { MAPFIELD Exit Key (Return Code) Constants }
      EscKey      =  1;      { Escape Key }
      EnterKey    = 28;      { RETURN Key }
      PageUpKey   = 73;      { PageUp Key }
      PageDnKey   = 81;      { PageDown Key }
      ArrowUpKey  = 72;      { Up Arrow Key }
      ArrowDnKey  = 80;      { Down Arrow Key }
      ArrowLfKey  = 75;      { Left Arrow Key, force exit if Menu option only }
      ArrowRtKey  = 77;      { Right Arrow Key, force exit if Menu option only }
      SpaceBarKey = 57;      { Space bar }
      F1Key       = 59;      { F1 - F10 function Keys }
      F2Key       = 60;
      F3Key       = 61;
      F4Key       = 62;
      F5Key       = 63;
      F6Key       = 64;
      F7Key       = 65;
      F8Key       = 66;
      F9Key       = 67;
      F10Key      = 68;
      TabKey      = 15;      { TAB key }
      ShiftTabKey = 150;     { Shift-TAB key }


      LBracket : CHAR = '['; { Left bracket for menus }
      RBracket : CHAR = ']'; { Right bracket for menus }


      { Cursor OFF scan line settings}
      StartScanOff : Byte = $20;
      StopScanOff  : Byte = $00;

     { DrawFrame border line styles available are: }
      NoLine     = 0;
      ThinLine   = 1;
      FatLine    = 2;
      DoubleLine = 3;
      DoubleTop  = 4;
      DoubleSide = 5;

      TPBorders : ARRAY [0..5] OF String [10] = ('          ',
						 'Ŀ',
						 '',
						 'ͻȺ',
						 '͸Գ',
						 'ķӺ');



VAR SType       : CHAR;                { Screen type:  M=mono, C=color }

    BackGroundColor : INTEGER;         { Global colors set by SetColorsN }
    ForeGroundColor : INTEGER;         { along with Textattr             }
    ShadeColor      : BYTE;            { Color to use for shading        }

    TPHandle    : INTEGER;             { DOS Handle number for files }

    Display     : DisplayPointer;      { Pointer to Screen mem, color or mono }

    TPMaxXw     : INTEGER;             { Max/min window coords for }
    TPMaxYw     : INTEGER;             { current physical display adapter }
    TPMinXw     : INTEGER;
    TPMinYw     : INTEGER;

    IStartLine, IStopLine : INTEGER;   { Initial cursor shape }

    Computer_Type,                     { Type of Computer
					 $FF = PC
					 $FE = XT
					 $FD = PCjr
					 $FC = AT
					 ELSE PS/2  }
    Major_DOS_Version,                 { DOS Version Number }
    Minor_DOS_Version,
    Active_Video,                      { Active Video Display
					 0 = No Card
					 1 = Color/Color
					 2 = Mono/Mono
					 3 = EGA/Color
					 4 = EGA/Mono
					 5 = EGA/ECM
					 6 = VGA  }
    Alternate_Video,                   { Alternate Video Display }
    Display_Mode,                      { Current Display Mode, See IBM Tech Ref}
    Ega_Memory,                        { Available EGA/VGA memory }
    Number_Of_Disks,                   { Maximum Drives }
    Number_Of_Printers,                { Available Printers }
    Number_Of_Serial_Adapters : BYTE;  { Available Adapters }
    System_Ram,                        { Total Computer Ram }
    Available_Ram,                     { Unused Ram }
    Extended_System_Ram : INTEGER;     { Extended 286/386 Memory }


    {MousePresent is set to TRUE by the MouseInit procedure if a mouse is
    present}
    MousePresent : Boolean;

    {The UserMapRoutine is entered upon each and every key struck when
    the Display Mapping procedures are used.  When UserMapRoutine is Nil,
    no user routine is expected.  If the UserMapRoutine feature is used, it
    becomes the responsibility of the UserMapRoutine to determine when the
    field should be exited.  The Scan and Ascii for the active key are
    placed in UserMapScan, and UserMapAscii respectively.  When it is
    determined that the field should be exited,  the UserMapExit flag
    should be set to TRUE.  Upon exit, the scan code only is returned to
    the applications return code variable.  The application could check
    both the scan and ascii for any exit key by referring to UserMapScan
    and UserMapAscii values. Keyboard re-direction is possible by changing
    the values in UserMapScan and UserMapAscii.  In order to disable specific
    keys, place a value of 0 in UserMapScan.

    UserMapRoutine must be a FAR Procedure.                                 }

    UserMapRoutine : InterventionProc;
    UserMapScan : Byte;
    UserMapAscii : Char;
    UserMapCursor : Integer;
    UserMapExit : Boolean;

{
		    S C R E E N    S U P P O R T
 }

    { Fast string writing with attributes within Turbo Window }
    { Uses Turbo's Textattr for scrolling attribute }
PROCEDURE FastWrite (Msg : AnyStr;
		     FgColor, BgColor, SCursor : INTEGER);

    { Move to the next line (like "WRITELN;", or "FastString ('', 2);" }
    { Uses Turbo's Textattr for scrolling attribute }
PROCEDURE NewLine;

    { Fast string write, without attributes within Turbo Window }
    { Uses Turbo's Textattr for scrolling attribute }
PROCEDURE FastString (Msg : AnyStr;
		      SCursor : INTEGER);

    { Fast string write, with attributes changed within Turbo Window }
    { Uses Turbo's Textattr for scrolling attribute }
PROCEDURE FastAtt (Msg : AnyStr;
		   FgColor, BgColor, SCursor : INTEGER);

    { Change foreground attributes for Len bytes from cursor within Turbo Window }
    { Uses Turbo's Textattr for scrolling attribute }
PROCEDURE ChangeAtt (Len, FgA, BgA : INTEGER);

    { Change background attributes for Len bytes from cursor within Turbo Window }
    { Uses Turbo's Textattr for scrolling attribute }
PROCEDURE ChangeBatt (Len, BgA : INTEGER);

    { Get attributes at the current cursor position }
PROCEDURE GetAtt (VAR FgA, BgA : INTEGER);

    { Fast string read, from specified position within Turbo Window }
PROCEDURE FastRead (XPos, YPos, Length : INTEGER;
		    Msg : AnyStr);

    { Clear Full Screen }
PROCEDURE ClearScn;

    { Clear Full Screen and Home Cursor }
PROCEDURE ClearScnHome;

    { Clear the currently defined Turbo window, using Textattr colors }
PROCEDURE ClearWindow;

    { Clear the currently defined Turbo window, using Textattr colors and Home Cursor }
PROCEDURE ClearWindowHome;

    { Take a snapshot and restore of the full screen }
PROCEDURE SnapShot (Option : INTEGER);

    { SnapShot and Restore full screen using SaveArea }
PROCEDURE NestSnap (Option : INTEGER;
		    VAR SaveArea);

    { SnapShot and Restore window area specified by StartX,Starty,
      EndX, and EndY using SaveArea }
PROCEDURE NestSnapWindow (Option : INTEGER;
			  VAR Savearea;
			  StartX,Starty,EndX,EndY: INTEGER);

    { Draw a frame around a window area }
PROCEDURE DrawFrame (Border : BorderStyle;
		     UpperLeftX, UpperLeftY,
		     LowerRightX, LowerRightY : INTEGER);

    { Draw a frame and place the title at the top center of it }
PROCEDURE WindowFrame (Border : BorderStyle;
		       x1, y1,
		       x2, y2 : INTEGER;
		       Title  : String80);

    { Determine screen type, color or mono }
PROCEDURE ScreenType (VAR SType : CHAR);

    { Turn off screen output }
PROCEDURE ScreenOff;

    { Turn on screen output }
PROCEDURE ScreenOn;

    { Turn off cursor }
PROCEDURE CursorOff;

    { Turn on cursor by setting it to the value when the program started
      This routine is useful for restoring a cursor to the original value
      before the program started.  To always be sure the cursor in on, use
      CursorNormal }
PROCEDURE CursorOn;

    { Turn on cursor by setting normal values based on the video type }
PROCEDURE CursorNormal;

    { Get cursor style info }
PROCEDURE GetCursor (VAR StartLine, StopLine : INTEGER);

    { Set cursor style }
PROCEDURE SetCursor (StartLine, StopLine : INTEGER);

    { Find cursor location on selected video page within Turbo Window }
PROCEDURE FindCursor (VAR Xpos, Ypos : INTEGER);

    { Find cursor location on selected video page relative to full screen }
PROCEDURE FindCursorF (VAR Xpos, Ypos : INTEGER);

    { Move cursor on selected video page within Turbo Window }
PROCEDURE MoveCursor (Xpos, Ypos : INTEGER);

    { Move cursor on selected video page relative to full screen }
PROCEDURE MoveCursorF (Xpos, Ypos : INTEGER);

    { Get video page indicator }
PROCEDURE GetPage (VAR PageNum : INTEGER);

    { Set a video page for display }
PROCEDURE SetPage (PageNum : INTEGER);

    { Convert color attributes to byte }
PROCEDURE Cva (    FgA, BgA : INTEGER;
	       VAR AByte    : BYTE);

    { Convert byte to color attributes }
PROCEDURE Exa (VAR FgA, BgA : INTEGER;
		   AByte    : BYTE);

    { Move data from the screen area defined by FromArea, to ToArea }
PROCEDURE MoveScreen (VAR FromArea, ToArea;
			  Length : INTEGER);

    { Same as above, but fast-move, i.e., two bytes at a time }
PROCEDURE FMoveScreen (VAR FromArea, ToArea;
			   Length : INTEGER);

    { Same as above, but with transparency check }
PROCEDURE TMoveScreen (VAR FromArea, ToArea;
			   Length : INTEGER);

    { Move Characters Only}
PROCEDURE CMoveScreen (VAR FromArea, ToArea;
			   Length : INTEGER);

    { Move Attributes Only}
PROCEDURE AMoveScreen (VAR FromArea, ToArea;
			   Length : INTEGER);

    { Set EGA/VGA Font8x8 Above 25 Line Mode, updates TpMaxyw }
    { Does Not Clear Screen }
PROCEDURE Above25 (OnOff : BOOLEAN);

    { Set EGA/VGA Font8x8 Above 25 Line Mode, updates TpMaxyw }
    { Use this if you want to use any window routines. }
PROCEDURE Above25Clear (OnOff : BOOLEAN);

    { Use Bright backgrounds (turns off blinking) }
PROCEDURE Bright;

    { Use Blinking backgrounds (turns off bright) }
PROCEDURE Blink;


{
		 K E Y B O A R D    S U P P O R T
 }

    { Read scan code, character, from keyboard }
PROCEDURE ReadKb (VAR Scan : BYTE;
		  VAR ASCII : String1);

    { Read scan code, character, from keyboard.  Stores the ASCII value
      in a character variable }
PROCEDURE ReadKbC (VAR Scan : BYTE;
		  VAR ASCII : CHAR);

    { Read scan code, character, from keyboard and leave in buffer}
    { ReadKbLeave does not wait for a character to be struck }
    { If no character is available, both scan and ascii are unchanged }
PROCEDURE ReadKbLeave (VAR Scan : BYTE;
		  VAR ASCII : String1);

    { Translate scan and ascii to string description, example "SPACE" }
PROCEDURE ShowKb (VAR Scan : BYTE;
		  VAR ASCII : String1;
		  VAR Image : String6);

    { Wait for a key to be pressed }
PROCEDURE PauseKb;

    { Clear any pending keystrokes from the keyboard buffer }
PROCEDURE ClearKb;

    { Check for keypress - better than Turbo Pascal, no "Spacebar" trouble }
FUNCTION KeyStruck : BOOLEAN;



{
		 D I A G N O S T I C     S U P P O R T
 }

    { Display memory window beginning at VarName position in memory }
PROCEDURE RamWindow (VAR VarName);



{
	    C R I T I C A L   E R R O R   H A N D L E R
 }

    { Install a full-function critical error handler }
PROCEDURE CritError;

    { Install critical error handler that always passes the
      error on to the application without error message automatically
      displayed.  Usefull for graphics applications.}

PROCEDURE CritErrorPass;

{
		  M E N U I N G    S U P P O R T
 }

    { Set global colors and TextAttr for other color routines }
PROCEDURE SetColorsN (Foreground, Background : INTEGER);

    { Set foreground to background, background to foreground color }
PROCEDURE ReverseOn;

    { Restore foreground, background colors }
PROCEDURE ReverseOff;

    { Scan across a menu on the screen }
PROCEDURE MenuMaker (    Option : CHAR;
			 Fg, Bg : INTEGER;
			 LBracket, RBracket : CHAR; { or BYTE }
			 SearchItem : CHAR;
		     VAR Item, Position : INTEGER;
		     VAR SaveArea);

    { Same as MenuMaker, but allow movement only in Sx,Sy,Ex,Ey window }
PROCEDURE RMenuMaker (    Sx, Sy, Ex, Ey : INTEGER;
			  Option : CHAR;
			  Fg, Bg : INTEGER;
			  LBracket, RBracket : CHAR; { or BYTE }
			  SearchItem : CHAR;
		      VAR Item, Position : INTEGER;
		      VAR SaveArea);

    { Implements a standard moving-bar menu subsystem }
PROCEDURE MenuPick (    Sx, Sy, Ex, Ey : INTEGER;
			LBracket, RBracket : CHAR;
		    VAR Item     : INTEGER;
			Fg, Bg   : INTEGER;
			NumItems : INTEGER;
			ItemsPerLine : INTEGER);

    { Like MenuPick but more dynamic. }
Procedure WMenuMaker(    sx,sy,ex,ey : integer;  { Area do Scan }
			 option      : char;     { Same as RMenuMaker  Plus: }
			 { G = Move based on scan code, 'W' = wait for key }
			 fg,bg       : integer;  { Color of bar }
			 lbrac,rbrac : char;     { Left/right brackets }
			 search      : string65; { String of chars user can press }
		     var item,                   { Menu item number }
			 position    : integer;  { Menu save position }
		     var savearea;               { Menu save buffer }
		     var scan        : byte;     { Scan of key pressed }
		     var ascii       : string1;  { Ascii of key pressed }
			 OneColumn   : Boolean); { If one column then exit on }
						 { right/left arrow keys }

{
		   S Y S T E M   R E S O U R C E S
 }

    { Get system resource information list }
PROCEDURE System_Resources;

{  ** System_Resources sets the following Turbo-Plus (Tplus) Global Values ** }

{         Computer_Type,
	  Major_DOS_Version,
	  Minor_DOS_Version,
	  Active_Video,
	  Alternate_Video,
	  Display_Mode,
	  Ega_Memory,
	  Number_of_Disks,
	  Number_of_Printers,
	  Number_of_Serial_Adapters,
	  System_RAM,
	  Available_RAM,
	  Extended_System_RAM,
	  Display,               ( Pointer to Screen mem, color or mono )
	  TPMaxXw,               ( Max/min window coords for
	  TPMaxYw,                 active video and mode )
	  TPMinXw,
	  TPMinYw

	  CheckSnow is also set TRUE for CGA color monitors
}



{
	    F I L E    H A N D L I N G    F A C I L I T I E S
 }

    { Create a file, and return a "Handle" to it }
PROCEDURE CreateF (    Path : String65;
		   VAR Attribute, Handle, Error : INTEGER);

    { Delete a file }
PROCEDURE DeleteF (    Path  : String65;
		   VAR Error : INTEGER);

    { Open a file, using Handles }
PROCEDURE OpenF (    Path : String65;
		 VAR Access, Handle, Error : INTEGER);

    { Write to a Handle-style file }
PROCEDURE WriteF (VAR Handle : INTEGER;
		  VAR Area;
		  VAR RecLen : WORD;
		  VAR Error  : INTEGER);

    { Read from a Handle-style file }
PROCEDURE ReadF (VAR Handle : INTEGER;
		 VAR Area;
		 VAR RecLen : WORD;
		 VAR Error  : INTEGER);

    { Move pointer around in Handle-style file }
PROCEDURE PointF (VAR Handle: INTEGER;
		  VAR RecLen: WORD;
		  VAR RecNum,
		      POption,
		      Error : INTEGER);

     { Move pointer directly and return position relative to beginning }
Procedure PointD (VAR Handle : INTEGER;
		  VAR DispIn, DispOut : LONGINT;
		  VAR Option, Error : INTEGER);

    { Close a Handle-style file }
PROCEDURE CloseF (VAR Handle, Error : INTEGER);

    { Duplicate the handle for a Handle-style file }
PROCEDURE DupHandle (    OldHandle : INTEGER;
		     VAR NewHandle : INTEGER;
		     VAR ErrorCode : INTEGER);

    { Make a new directory }
PROCEDURE MkDirN (    Path  : String65;
		  VAR Error : INTEGER);

    { Remove an existing directory }
PROCEDURE RmDirN (    Path  : String65;
		  VAR Error : INTEGER);

    { Change to another directory }
PROCEDURE ChgDirN (    Path  : String65;
		   VAR Error : INTEGER);

    { Get the letter designator of the current disk }
PROCEDURE CurDisk (VAR Disk : CHAR);

    { Get the full name of the current directory, and the drive ID }
PROCEDURE CurDirN (VAR Path  : String65;
		   VAR Drive : CHAR;
		   VAR Error : INTEGER);

    { Change the attributes of a file }
PROCEDURE ChangeN (    Path : String65;
		   VAR Option, Attribute, Error : INTEGER);

    { Get the current disk Volume name }
PROCEDURE VolumeGet (    ID : CHAR;
		     VAR Volume : String11);

    { Set the current disk Volume name }
PROCEDURE VolumeSet (    ID : CHAR;
		     VAR Volume : String11);

    { Return directory path from where the current program was loaded }
FUNCTION LoadDir : String65;

    { Determine if the specified file exists }
FUNCTION FileExists (PathName : String65) : BOOLEAN;

    { Determine Size of File from PathName (file is closed) }
FUNCTION SizeOfFile (PathName : String65) : LONGINT;

    { Determine the size of an open file using the handle - leave file open }
FUNCTION SizeOfOpenFile (Handle : INTEGER) : LONGINT;


    { Return the path for an Environment Variable }
FUNCTION EnviroPath (VarName : STRING) : STRING;

    { Return the Path for a requested File }
FUNCTION FindPath (FileName : String65) : String65;

    { Select the disk drive to use as default ('A', 'B', etc.) }
PROCEDURE SelectDisk (VAR Disk : CHAR);



{
			     S O U N D S
 }

    { The sound routines give results that are described by name }
PROCEDURE Screeches;

PROCEDURE Birds;

PROCEDURE ClockSound;

PROCEDURE Machinery1;

PROCEDURE Chirps;

PROCEDURE CrashAndBurn;

PROCEDURE Generator1;

PROCEDURE DialBusyPhone;

PROCEDURE RandomSounds;

PROCEDURE InvadersSaucer;

PROCEDURE Siren1;

PROCEDURE DrippingSpigot;

PROCEDURE Train;

PROCEDURE Siren2;

PROCEDURE ElectronicSounds;

PROCEDURE Screeches2;

PROCEDURE Machinery3;

PROCEDURE Click;

PROCEDURE Zoink;

PROCEDURE WolfWhistle;

PROCEDURE DoorBuzzer;

PROCEDURE Phaser;

PROCEDURE PhoneRing;

PROCEDURE PhotonTorpedo;



{
		  D I S P L A Y    M A P P I N G
 }

    { General mapping routine used by MapInt, MapReal, etc. }
PROCEDURE MapField (    Option,
			FType    : CHAR;
			XPos, YPos,    {Relative to Turbo Window}
			MsgLine,
			Fg, Bg,
			AFg, ABg : INTEGER;
		    VAR RCode, CPos : INTEGER;
		    VAR Vf, Mask    : String80);

    { Read or write a string, according to an I/O mask }
PROCEDURE MapString (    Option       : CHAR;
			 XPos, YPos,    {Relative to Turbo Window}
			 MsgLine,
			 Fg, Bg,
			 AFg, ABg     : INTEGER;
		     VAR RCode, CPos  : INTEGER;
		     VAR Vf           : String80;
			 Mask         : String80);

    { Read or write a real (floating point) number, using a mask }
PROCEDURE MapReal   (    Option       : CHAR;
			 XPos, YPos,   {Relative to Turbo Window}
			 MsgLine,
			 Fg, Bg,
			 AFg, ABg     : INTEGER;
		     VAR RCode, CPos  : INTEGER;
		     VAR Vf           : REAL;
			 Mask         : String80);

    { Read or write an integer (16-bit), using a mask }
PROCEDURE MapInt (    Option       : CHAR;
		      XPos, YPos,      {Relative to Turbo Window}
		      MsgLine,
		      Fg, Bg,
		      AFg, ABg     : INTEGER;
		  VAR RCode, CPos  : INTEGER;
		  VAR Vf           : INTEGER;
		      Mask         : String80);

    { Read or write a byte (8-bit) using a mask }
PROCEDURE MapByte (   Option       : CHAR;
		      XPos, YPos,      {Relative to Turbo Window}
		      MsgLine,
		      Fg, Bg,
		      AFg, ABg     : INTEGER;
		  VAR RCode, CPos  : INTEGER;
		  VAR Vf           : BYTE;
		      Mask         : String80);

    { Read or write an short integer (8-bit), using a mask }
PROCEDURE MapShortInt (   Option       : CHAR;
			  XPos, YPos,  {Relative to Turbo Window}
			  MsgLine,
			  Fg, Bg,
			  AFg, ABg     : INTEGER;
		      VAR RCode, CPos  : INTEGER;
		      VAR Vf           : SHORTINT;
			  Mask         : String80);

    { Read or write a word (16-bit), using a mask }
PROCEDURE MapWord (   Option       : CHAR;
		      XPos, YPos,      {Relative to Turbo Window}
		      MsgLine,
		      Fg, Bg,
		      AFg, ABg     : INTEGER;
		  VAR RCode, CPos  : INTEGER;
		  VAR Vf           : WORD;
		      Mask         : String80);

    { Read or write a long integer (32-bit), using a mask }
PROCEDURE MapLongInt (    Option       : CHAR;
			  XPos, YPos,  {Relative to Turbo Window}
			  MsgLine,
			  Fg, Bg,
			  AFg, ABg     : INTEGER;
		      VAR RCode, CPos  : INTEGER;
		      VAR Vf           : LONGINT;
			  Mask         : String80);

    { Read or write a byte (8-bit), with hex digits allowed }
PROCEDURE MapHexByte (    Option       : CHAR;
			  XPos, YPos,  {Relative to Turbo Window}
			  MsgLine,
			  Fg, Bg,
			  AFg, ABg     : INTEGER;
		      VAR RCode, CPos  : INTEGER;
		      VAR Vf           : BYTE;
			  Mask         : String80);

    { Read or write a word (16-bit), with hex digits allowed }
PROCEDURE MapHexWord (    Option       : CHAR;
			  XPos, YPos,  {Relative to Turbo Window}
			  MsgLine,
			  Fg, Bg,
			  AFg, ABg     : INTEGER;
		      VAR RCode, CPos  : INTEGER;
		      VAR Vf           : WORD;
			  Mask         : String80);

    { Call mapfield procedures based on scanning the screen for locations. }
PROCEDURE ScanMap(    X1,Y1,X2,Y2 : integer;
		      Option : Char ;  {OPtions: I,R}
		  var X,Y,Item : integer;
		      Marker : Char;
		      RetCode : integer;
		  var Buf);
{
		      M O U S E    S U P P O R T
 }

    {  Initialize the Mouse routines and return the number of buttons
       on the mouse. If Buttons is zero then no mouse is installed.  }
PROCEDURE MouseInit (VAR Buttons : INTEGER);

    { Restrict mouse movement to area defined by paramaters }
PROCEDURE MouseArea (XMin, YMin, XMax, YMax : INTEGER);

    { Find the location of the mouse and button status }
PROCEDURE MouseFind (VAR XPos, YPos : INTEGER;
		     VAR BStat      : WORD);

    { Move the mouse cursor to specifed location, 0,0 is upper-left }
PROCEDURE MouseMove (XPos, YPos : INTEGER);

    { Return the number of times a button was pressed and its location }
PROCEDURE MousePress (    Button   : INTEGER;
		      VAR Presses,
			  LastX,
			  LastY    : INTEGER;
		      VAR BStat    : WORD);

    { Return the number of times a button was released and its location }
PROCEDURE MouseRelease (    Button    : INTEGER;
			VAR Releases,
			    LastX,
			    LastY     : INTEGER;
			VAR BStat     : WORD);

    { Make the mouse cursor visible }
PROCEDURE MouseShowCursor;

    { Make the mouse cursor invisible }
PROCEDURE MouseHideCursor;

    { Return how far the mouse has moved since the last call }
PROCEDURE MouseMotion (VAR XDist,
			   YDist : INTEGER);

    { Set the sensitivity of the mouse }
PROCEDURE MouseMickey (XMickey,
		       YMickey  : INTEGER);

    { Create or customize your own graphics mouse cursor }
PROCEDURE MouseMakeCursor (    XHot,
			       YHot : INTEGER;
			   VAR Masks);

    { Create the shape of the text-mode mouse cursor }
PROCEDURE MouseMakeHardCursor (StartLine,
			       StopLine   : INTEGER);

    { Create a software cursor for the mouse }
PROCEDURE MouseMakeSoftCursor (ScreenMask,
			       CursorMask : INTEGER);

{
		      T I M E R    S U P P O R T
 }

	  { Optain direct time from BIOS data areas }

{ Hours = TimeHigh,
  Min = round(TimeLow/60*18.2),
  Sec = round(TimeLow/18.2) mod 60
  100th = round(frac(TimeLow/18.2) * 100)) }

PROCEDURE QuerryTime (VAR TIMEHIGH,TIMELOW:WORD);

    { Calculate elapsed time using BIOS data areas }
PROCEDURE ELAPSEDTIME (VAR ELAPHIGH,ELAPLOW:WORD;TIMEHIGH,TIMELOW:WORD);

{
		     P R I N T E R  S U P P O R T
 }
     { Check to see if the printer is ready for use }
Function PrinterReady(lpt:byte):boolean;

     { Initialize the printer }
Procedure PrinterInitialize(lpt:byte);

{
		     S T R I N G  S U P P O R T
 }

     { Delete all white space at the beginning and end of strings. }
FUNCTION DelLstSpcs(S :String; Max : Byte) : String;

     { Pad the end of a string with the given char for the given length. }
FUNCTION PadString(S : String; Size : Byte; CharType : Char) : String;

     { Convert a string to all upper case. }
FUNCTION  StrUPCase(Str : String) : String;

    { Repeat a given character and return the resulting string }
FUNCTION Replicate (Count : BYTE;
		    ASCII : CHAR) : AnyStr;

    { Left justify a string in a field of specified width }
FUNCTION LeftJustify ( Width : BYTE;
		       Str   : AnyStr) : AnyStr;

    { Center justify a string in a field of specified width }
FUNCTION CenterJustify (Width  : BYTE;
			Center_String : AnyStr) : AnyStr;

    { Right justify a string in a field of specified width }
FUNCTION RightJustify (Width  : BYTE;
		       Str : AnyStr) : AnyStr;

    { Extract a Token item from a string }
FUNCTION TokenInStr (    Item : INTEGER;
		     VAR S;
			 Check : CHAR) : STRING;

     { Add a back slash to DOS paths if needed. }
FUNCTION AddBackSlash (PathName : String65) : String65;

     { Given a file known to exist, complete the path to the file. }
FUNCTION AddFrontPath (PathName : String65) : String65;

     { Given a complete path -- return just the path }
FUNCTION PathOnly (Path : String65) : String65;

     { Given a complete path -- return just the filename }
FUNCTION FileOnly (Path : String65) : String65;

     { Return just the extension of a file name. }
FUNCTION ExtensionOnly (PathName : String65) : String65;

     { Return just the name out of a complete pathname. }
FUNCTION NamePartOnly (PathName : String65) : String65;

{
	 E N D   O F   T P L U S   I N T E R F A C E   S E C T I O N
 }

{
	      ------- -- --------- ------ --- --- ----- ----
	      UPDATES TO REFERENCE MANUAL FOR THE TPLUS UNIT
	      ------- -- --------- ------ --- --- ----- ----
 }

{  The following are *NEW* procedures and functions.  Please refer to the
   descriptions above. }

{
Procedure CursorNormal;
This routine sets the cursor to a normal ON value based on the video type.
Whereas CursorOn turns the cursor on by setting it to the value at the time
the program was started, CursorNormal will always turn the cursor on.
CursorOn is useful for restoring a cursor to, the start-up value.  The problem
is that the cursor may have been turned off before the program was started.

}
{-------------------------- Manual Whoops -----------------------------------}
{
MenuPick description should refer to Nsamp6.pas.
}
