{$S-,R-,I-,V-,B-}

  {*********************************************************}
  {*                    TP8087.PAS 4.03                    *}
  {*        Copyright (c) TurboPower Software 1987.        *}
  {* Portions copyright (c) Sunny Hill Software 1985, 1986 *}
  {*     and used under license to TurboPower Software     *}
  {*                 All rights reserved.                  *}
  {*********************************************************}

unit Tp8087;
  {-Routines to add 80x87 support to pop-up routines}

interface

type
  SaveBuffer8087 = array[1..94] of Byte;

procedure Save8087(var SaveBuf : SaveBuffer8087);
  {-Saves the 80x87 registers in the save buffer.}

procedure Restore8087(var SaveBuf : SaveBuffer8087);
  {-Restores the 80x87 registers from the save buffer.}

function Installed8087 : Boolean;
  {-Returns true if an 80x87 coprocessor is installed.}

procedure Exceptions8087(On : Boolean);
  {-Turn exception interrupts on or off}

function Error8087 : Word;
  {-Return (and clear) the error status of the 80x87}

  {==========================================================================}

implementation

  {$L TP8087.OBJ}

  procedure Save8087(var SaveBuf : SaveBuffer8087);
    external;

  procedure Restore8087(var SaveBuf : SaveBuffer8087);
    external;

  function Installed8087 : Boolean;
    external;

  procedure Exceptions8087(On : Boolean);
    external;

  function Error8087 : Word;
    external;

end.
