{$R-,S+,I+,D+,F-,V-,B-,N-,L+ }
{$M 16384,120000,120000}
Program SFLManager;  {Sequential Files Library Utility}

uses dos,crt,tplus,tpwindow,tpsfl,tperror,nsamp9a;

type
  Fr =  record
          fname:string12;
          ftag:boolean;
          lname:string12;
          ltag:boolean;
        end;
var
    Item:integer;
    Search : CHAR;
    MPosition,PItem,PPosition : INTEGER;
    MSaveArea : ARRAY [1..80] OF BYTE;
    sx,sy,ex,ey:integer;
    Mfg,Mbg:integer;
    scan:byte;
    asciichar:string1;
    MapOption:char;
    CursorPos:integer;
    ReturnCode:integer;
    NumReturnCode:integer;
    Pathname:string65;
    ActiveSfl:string65;
    MaxNum: integer;
    SFL:SflPtr;
    SflError:integer;
    buf:pointer;
    dupflag:boolean;
    itemfg,itembg,barfg,barbg,bordfg,bordbg,pfg,pbg:integer;
    filevar:file;
    Showing:boolean;
    fake:Fr;

Const
    handle:integer = 0;

{$F+}
Procedure UniversalHelp;
var
  itemlen:word;
  itemnum,blanknum:integer;
  name:string12;
  window:windowpointer;
begin
  if universalhelpscan <> 0 then
  begin
    if showing = false then exit;
    if universalhelpscan = enterkey then
    begin
      universalhelpscan := 0;
      move(universalHelpPtr^,name[1],12);
      byte(name[0]):=12;
      If Name <> '' Then
      Begin
        Window:=Nil;
        ReadSflWindow(name,window,sfl,handle);
        if Window_Error = 0 then PushShowWindow(CurtainOpen,window)
        else PushShowWindow(CurtainOpen,getmenu(20));
        if window <> nil then tpfreemem(pointer(window),window^.complen-TPwhdr);
        pausekb;
        PopWindow(CurtainClose);
      end;
    end;
  end else
  begin {display item size}
    begin
      move(universalHelpPtr^,name[1],12);
      byte(name[0]):=12;
      if item in[3,4,8] then
      DataSflItem(Name,itemlen,itemnum,blanknum,sfl,sflerror)
      else
      if item in[2,5] then
      itemlen:=sizeoffile(Name)
      else exit;
      movecursor(73,20);
      write('     ');
      Movecursor(73,20);
      write(itemlen);
    end;
  end;
end;
{$F-}

Function Wilds:boolean;
begin
  if ((pos('*',pathname) <> 0) or (pos('?',pathname) <> 0)) then
  begin
    Wilds:=true;
    exit;
  end else
  begin
    fake.fname:=pathname;
    fake.ftag:=true;
    fake.ltag:=false;
    AutoDirTagPtr:=@fake;
    wilds:=false;
    Window_Error:=0;
  end;
end;

procedure showdirectory;
var
  error:integer;
  disk:char;
  curdirectory:string65;
begin
  curdisk(disk);
  curdirn(curdirectory,disk,error);
  curdirectory:=padstring(curdirectory,59,' ');
  curdirectory:=disk+':'+curdirectory;
  curdirectory:=StrUpCase(curdirectory);
  movecursor(21,24);
  fastwrite(curdirectory,lightgreen,black,3);
end;

procedure ShowActiveSfl;
var
  ShowSFl:string[59];
begin
  ShowSFL:=padstring(ActiveSFL,59,' ');
  ShowSfl:=StrUpCase(ShowSfl);
  movecursor(21,23);
  fastwrite(ShowSFL,white,black,3);
end;

procedure ShowNoSfl;
var
  ShowSFl:string[59];
begin
  ShowSFL:=padstring(' ',59,' ');
  movecursor(21,23);
  fastwrite(ShowSFL,white,black,3);
end;

Function ErrorWindow(error:integer;name:string12):boolean;
var
  scan:byte;
  answer:char;
begin
  pushshowwindow(normal,getmenu(21));
  movecursor(curwindowx1+2,curwindowy1+1);
  write(errortable(error));
  movecursor(Curwindowx1+7,curwindowy1+2);
  write(name);
  repeat
    readkbc(scan,answer);
  until upcase(answer) in['Y','N'];
  if upcase(answer) = 'N' then ErrorWindow:=True else ErrorWindow:=False;
  PopWindow(normal);
end;

Function DupWindow:boolean;
var
  scan:byte;
  answer:char;
begin
  pushshowwindow(normal,getmenu(22));
  repeat
    readkbc(scan,answer);
  until upcase(answer) in['Y','N'];
  if upcase(answer) = 'N' then DupWindow:=True else DupWindow:=False;
  PopWindow(normal);
end;

Procedure PopHelp;
begin
  PopWindow(normal);
  case item of
    1:  PushShowWindow(normal,getmenu(2));
    2:  PushShowWindow(normal,getmenu(3));
    3:  PushShowWindow(normal,getmenu(4));
    4:  PushShowWindow(normal,getmenu(5));
    5:  PushShowWindow(normal,getmenu(6));
    6:  PushShowWindow(normal,getmenu(7));
    7:  PushShowWindow(normal,getmenu(8));
    8:  PushShowWindow(normal,getmenu(9));
    9:  PushShowWindow(normal,getmenu(10));
  end; {end case}
end;

PROCEDURE MENUMAKERMAIN(Option:CHAR);

BEGIN
   RMenuMaker (sx,sy,ex,ey,Option,MFg,MBg,LBracket,RBracket,Search,Item,
               MPosition,MSaveArea);
END;

PROCEDURE GETPATH;
var
  i:integer;
begin
  PushShowWindow(CurtainOpen,getmenu(14));
  if item in[2,3,4] then
  begin
    MoveCursor(25,23);
    FastString('Wild Cards Accepted (Example *.WIN)',3);
  end;
  CursorOn;
  Mapoption:='R';
  CursorPos:=1;
  Pathname:='';
  repeat
  MapString(MapOption,curwindowx1+1,curwindowy1+3,25,pfg,pbg,pfg,pbg,ReturnCode,CursorPos,PathName,
      '>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>');
  until returncode in [enterkey,esckey];
  pathname:=dellstspcs(pathname,65);
  Cursoroff;
end;

Procedure GetMaxNum;
begin
  PushShowWindow(Fadein,getmenu(15));
  CursorOn;
  CursorPos:=1;
  MaxNum:=800;
  MapInt('W',Curwindowx1+12,curwindowy1+3,25,15,0,15,0,NumReturnCode,
         CursorPos,Maxnum,'[###]');
  repeat
  MapInt('L',Curwindowx1+12,curwindowy1+3,25,15,0,15,0,NumReturnCode,
         CursorPos,Maxnum,'[###]');
  If NumReturnCode = enterkey then
  begin
    if (Maxnum < 3) or (Maxnum > 800) then
    begin
      phaser;
      NumReturnCode := 0;
    end;
  end;
  until NumReturnCode in [enterkey,esckey];
  cursoroff;
  PopWindow(Fadeout);
end;

procedure ErrorMessage;
begin
  movecursor(curwindowx1+25,curwindowy1+5);
  fastwrite(ErrorTable(SflError),white,red,3);
  pausekb;
end;

Procedure ActivateSfl;
var
  itemlen:word;
  itemnum,blanknum:integer;
  name:string12;
  ftime:longint;
  dt:datetime;

begin
  if returncode = esckey then
  exit;
  if handle <> 0 then
  begin
    WriteSFLDIr(handle,sfl,SflError);
    CloseSFL(handle,sfl,SflError);
    if sflerror <> 0 then
    begin
      handle:=0;
      ActiveSFL:='';
      ErrorMessage;
    end;
  end;
  OpenSFL(pathname,handle,sfl,SflError);
  if SflError = 0 then
  begin
    ActiveSfl:=pathname;
    PushShowWindow(CurtainOpen,getmenu(23));
    movecursor(35,9);
    write(SizeOfOpenFile(handle));
    movecursor(45,10);
    write(Sfl^.len);
    movecursor(46,11);
    write(Sfl^.usermax);
    DataSflItem(Name,itemlen,itemnum,blanknum,sfl,sflerror);
    movecursor(44,12);
    write(blanknum-1);
    movecursor(40,13);
    write(Sfl^.usermax - (blanknum-1));
    movecursor(43,14);
    write(FindMaxSflEntryName(Sfl));
    movecursor(43,15);
    write(FindMaxSFlEntry(Sfl));
    Assign(filevar,pathname);
    reset(filevar);
    getftime(filevar,ftime);
    unpacktime(ftime,dt);
    movecursor(35,16);
    write(dt.day,'/',dt.month,'/',dt.year);
    movecursor(35,17);
    write(dt.hour,':',dt.min,':',dt.sec);
    close(filevar);
    Pausekb;
    PopWindow(CurtainClose);
  end else
  begin
    handle:=0;
    ActiveSfl:='';
    ErrorMessage;
  end;
 end;

Procedure AddToSFL(InName:string12);
var temp : string65;
    access,tphandle : integer;
    len : word;
begin
  Access := 0;                   { Open for READ access }
  OpenF (InName, Access, TPHandle, SflError); { Open Window file }
  IF SflError = 0 THEN
  BEGIN
    Len := WORD (SizeOfOpenFile (TPHandle));
    if len > maxsize then
    begin
      sflerror:=75;
      exit;
    end;
    ReadF (TPHandle, buf^, Len, SflError);
    if Sflerror = 0 then
    begin
      Closef(tphandle,Sflerror);
      if Sflerror = 0 then
      begin
        CheckSFLDups(sfl);
        AddSFLItem(handle,InName,buf^,len,sfl,sflerror);
        if sflerror = 71 then
        begin
          if dupflag then
          begin
            if dupwindow then exit else dupflag:=false;
          end;
          DeleteSflItem(handle,InName,sfl,sflerror);
          if sflerror = 0 then
          AddSFLItem(handle,InName,buf^,len,sfl,sflerror);
        end;
      end;
    end;
  end;
end;


Procedure Copyin;
var
  i:word;
begin
  SflError:=0;
  dupflag:=true;
  AutoDirTagFlag := True;
  AutoDirTagAll:=True;
  UniversalSort:=True;
  if Wilds then
  AutoDir(  ThinLine,             { Style of the Border. }
            31, 5,               { Upper left corner of window. }
            itemfg,itembg,        { Menu items colors. }
            barfg,barbg,          { Menu bar colors. }
            bordfg,bordbg,        { Border colors. }
            1,                    { Number of files per line displayed. }
            14,                   { Height of menu. }
            True,                 { Yes, save the screen behind window. }
            PathName );               { Mask on input, filename on output unless
                                    AutoDirTagFlag is true. In this case you
                                    must extract all of the tagged files out
                                    of memory.                               }
  if Window_Error <> 0 then PathName := '';
  If PathName <> '' Then
  Begin    {Add to SFL}
    I := 0;
    While AutoDirTagPtr^.Entry[I].Tag Do
    Begin
      AddToSfl(AutoDirTagPtr^.Entry[I].FileName);
      if sflerror <> 0 then
      begin
        if (dupflag) and (sflerror = 71) then
        begin
          if AutoDirTagPtr <> @fake then
          TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
          exit;
        end else
        if (ErrorWindow(sflerror,AutoDirTagPtr^.Entry[I].FileName)) then
        begin
          if AutoDirTagPtr <> @fake then
          TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
          exit;
        end;
      end;
      Sflerror:=0;
      Inc(I);
    End;
    if AutoDirTagPtr <> @fake then
    TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
  End;
end;

Procedure Deletein;
var
  i:word;
begin
  SflError:=0;
  AutoDirTagFlag := True;
  AutoDirTagAll:=True;
  UniversalSort:=True;
  if wilds then
  AutoSflDir(  ThinLine,             { Style of the Border. }
            31, 5,               { Upper left corner of window. }
            itemfg,itembg,        { Menu items colors. }
            barfg,barbg,          { Menu bar colors. }
            bordfg,bordbg,        { Border colors. }
            SFL,
            1,                    { Number of files per line displayed. }
            14,                   { Height of menu. }
            True,                 { Yes, save the screen behind window. }
            PathName );               { Mask on input, filename on output unless
                                    AutoDirTagFlag is true. In this case you
                                    must extract all of the tagged files out
                                    of memory.                               }
  if Window_Error <> 0 then PathName := '';
  If PathName <> '' Then
  Begin
    I := 0;
    While AutoDirTagPtr^.Entry[I].Tag Do
    Begin
      DeleteSflItem(handle,AutoDirTagPtr^.Entry[I].FileName,Sfl,SflError);
      if sflerror <> 0 then
      begin
        if (ErrorWindow(sflerror,AutoDirTagPtr^.Entry[I].FileName)) then
        begin
          if AutoDirTagPtr <> @fake then
          TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
          exit;
        end;
      end;
      Sflerror:=0;
      Inc(I);
    End;
    if AutoDirTagPtr <> @fake then
    TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
  End;
end;

Procedure Copyout;
var
  i,itemlen:word;
  error,attri,thandle:integer;

begin
  SflError:=0;
  dupflag:=true;
  AutoDirTagFlag := True;
  AutoDirTagAll:=True;
  UniversalSort:=True;
  if wilds then
  AutoSflDir(  ThinLine,             { Style of the Border. }
            31, 5,               { Upper left corner of window. }
            itemfg,itembg,        { Menu items colors. }
            barfg,barbg,          { Menu bar colors. }
            bordfg,bordbg,        { Border colors. }
            SFL,
            1,                    { Number of files per line displayed. }
            14,                   { Height of menu. }
            True,                 { Yes, save the screen behind window. }
            PathName );               { Mask on input, filename on output unless
                                    AutoDirTagFlag is true. In this case you
                                    must extract all of the tagged files out
                                    of memory.                               }
  if Window_Error <> 0 then PathName := '';
  If PathName <> '' Then
  Begin
    I := 0;
    While AutoDirTagPtr^.Entry[I].Tag Do
    Begin
      if fileexists(AutoDirTagPtr^.Entry[I].FileName) then
      if dupflag then if dupwindow then
      begin
        sflerror:=71;
        if AutoDirTagPtr <> @fake then
        TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
        exit;
      end else dupflag:=false;
      GetSflItem(handle,AutoDirTagPtr^.Entry[I].FileName,buf^,itemlen,sfl,sflerror);
      if sflerror <> 0 then
      begin
        if (ErrorWindow(sflerror,AutoDirTagPtr^.Entry[I].FileName)) then
        begin
          if AutoDirTagPtr <> @fake then
          TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
          exit;
        end;
      end;
      if sflerror = 0 then
      Begin
        attri :=0;
        CreateF(AutoDirTagPtr^.Entry[I].FileName,attri,thandle,error);
        If error = 0 then
        Begin
          WriteF(thandle,buf^,itemlen,error);
          if error <> 0 then
          begin
            if ErrorWindow(error,AutoDirTagPtr^.Entry[I].FileName) then
            begin
              sflerror:=error;
              if AutoDirTagPtr <> @fake then
              TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
              exit;
            end;
          end;
          CloseF(thandle,error);
        End;
      end;
      Sflerror:=0;
      Inc(I);
    End;
    if AutoDirTagPtr <> @fake then
    TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
  End;
end;

Procedure DeleteTagged;
var
  i,itemlen:word;
  error,attri,thandle:integer;

begin
  SflError:=0;
  AutoDirTagFlag := True;
  AutoDirTagAll:=True;
  UniversalSort:=True;
  If Wilds then
  AutoDir(  ThinLine,             { Style of the Border. }
            31, 5,               { Upper left corner of window. }
            itemfg,itembg,        { Menu items colors. }
            barfg,barbg,          { Menu bar colors. }
            bordfg,bordbg,        { Border colors. }
            1,                    { Number of files per line displayed. }
            14,                   { Height of menu. }
            True,                 { Yes, save the screen behind window. }
            PathName );               { Mask on input, filename on output unless
                                    AutoDirTagFlag is true. In this case you
                                    must extract all of the tagged files out
                                    of memory.                               }
  if Window_Error <> 0 then PathName := '';
  If PathName <> '' Then
  Begin
    I := 0;
    While AutoDirTagPtr^.Entry[I].Tag Do
    Begin
      Deletef(AutoDirTagPtr^.Entry[I].FileName,sflerror);
      if sflerror <> 0 then
      begin
        if (ErrorWindow(sflerror,AutoDirTagPtr^.Entry[I].FileName)) then
        begin
          if AutoDirTagPtr <> @fake then
          TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
          exit;
        end;
      end;
      Sflerror:=0;
      Inc(I);
    End;
    if AutoDirTagPtr <> @fake then
    TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
  End;
end;

Procedure DisplayItem;
var
  i,itemlen:word;
  itemnum,blanknum:integer;
  error,attri,thandle:integer;

begin
  SflError:=0;
  AutoDirTagFlag := False;
  UniversalSort:=True;
  AutoSflDir(  ThinLine,             { Style of the Border. }
            31, 5,               { Upper left corner of window. }
            itemfg,itembg,        { Menu items colors. }
            barfg,barbg,          { Menu bar colors. }
            bordfg,bordbg,        { Border colors. }
            SFL,
            1,                    { Number of files per line displayed. }
            14,                   { Height of menu. }
            True,                 { Yes, save the screen behind window. }
            PathName );           { Mask on input, filename on output unless
                                    AutoDirTagFlag is true. In this case you
                                    must extract all of the tagged files out
                                    of memory.                               }

  if AutoDirTagPtr <> @fake then
  TpFreeMem(pointer(AutoDirTagPtr), AutoDirTagPtrSize );
end;


procedure ShowOk;
begin
  PushShowWindow(normal,getmenu(17));
  pausekb;
  PopWindow(Fadeout);
end;

procedure ShowBad;
begin
  PushShowWindow(normal,getmenu(18));
  pausekb;
  PopWindow(Fadeout);
end;

procedure ShowNoActiveSfl;
begin
  PushShowWindow(normal,getmenu(19));
  pausekb;
  PopWindow(Fadeout);
end;

Procedure DoOptions;
var
  error:integer;
  window:windowpointer;
  backpop:boolean;
begin
  case item of
    1:  begin
          getpath;
          ActivateSfl;
          PopWindow(CurtainClose);
          if handle <> 0 then  ShowActiveSfl else
          ShowNoSfl;
        end;
    2:  begin
          if handle = 0 then
          begin
            ShowNoActiveSfl;
            exit;
          end;
          backpop:=false;
          getpath;
          if pathname <> '' then
          Begin
            PopWindow(CurtainClose);
            if wilds then
            begin
              backpop:=true;
              PushShowWindow(Fadein,getmenu(16));
            end;
            Copyin;
            if backpop then PopWindow(Fadeout);
            if pathname = '' then exit;
            EnsureSfl(handle,Sfl,error);
            if Sflerror = 0 then ShowOk else ShowBad;
          end else PopWindow(normal);
        end;
    3:  begin
          if handle = 0 then
          begin
            ShowNoActiveSfl;
            exit;
          end;
          backpop:=false;
          getpath;
          if pathname <> '' then
          Begin
            PopWindow(CurtainClose);
            if wilds then
            begin
              backpop:=true;
              PushShowWindow(Fadein,getmenu(16));
            end;
            Copyout;
            if backpop then PopWindow(Fadeout);
            if pathname = '' then exit;
            if Sflerror = 0 then ShowOk else ShowBad;
          end else PopWindow(normal);
        end;
    4:  begin
          if handle = 0 then
          begin
            ShowNoActiveSfl;
            exit;
          end;
          backpop:=false;
          getpath;
          if pathname <> '' then
          Begin
            PopWindow(CurtainClose);
            if wilds then
            begin
              backpop:=true;
              PushShowWindow(Fadein,getmenu(16));
            end;
            Deletein;
            if backpop then PopWindow(Fadeout);
            if pathname = '' then exit;
            EnsureSfl(handle,Sfl,error);
            if Sflerror = 0 then ShowOk else ShowBad;
          end else PopWindow(normal);
        end;
    5:  begin
          backpop:=false;
          getpath;
          if pathname <> '' then
          Begin
            PopWindow(CurtainClose);
            if wilds then
            begin
              backpop:=true;
              PushShowWindow(Fadein,getmenu(16));
            end;
            DeleteTagged;
            if backpop then PopWindow(Fadeout);
            if pathname = '' then exit;
            if Sflerror = 0 then ShowOk else ShowBad;
          end else PopWindow(normal);
        end;
    6:  begin
          getpath;
          if pathname = '' then
          begin
            PopWindow(CurtainClose);
            exit
          end;
          getmaxnum;
          if NumReturnCode = Esckey then
          begin
            PopWindow(CurtainClose);
            exit
          end;
          MakeSFL(pathname,sfl,sflerror,maxnum);
          if sflerror <> 0 then ErrorMessage;
          PopWindow(CurtainClose);
          if sflerror = 0 then ShowOk;
        end;
    7:  begin
          getpath;
          if pathname = '' then
          begin
            PopWindow(CurtainClose);
            exit
          end;
          if pathname = activesfl then
          begin
            PopWindow(curtainClose);
            phaser;
            MoveCursor(3,22);
            FastWrite(Chr(25),LightRed,Black,3);
            Delay(1500);
            FastWrite(' ',white,black,3);
            exit;
          end;
          DeleteSfl(pathname,sfl,sflerror);
          if sflerror <> 0 then ErrorMessage;
          PopWindow(curtainClose);
          if sflerror = 0 then ShowOk;
         end;
    8:  begin
          if handle = 0 then
          begin
            ShowNoActiveSfl;
            exit;
          end;
          getpath;
          PopWindow(curtainClose);
          if wilds = false then
          begin
            Window:=Nil;
            ReadSflWindow(pathname,window,sfl,handle);
            if Window_Error = 0 then PushShowWindow(CurtainOpen,window)
            else PushShowWindow(CurtainOpen,getmenu(20));
            if window <> nil then tpfreemem(pointer(window),window^.complen-TPwhdr);
            pausekb;
            PopWindow(CurtainClose);
          end else
          begin
            PushShowWindow(Fadein,getmenu(16));
            Showing:=true;
            DisplayItem;
            Showing:=false;
            PopWindow(CurtainClose);
          end;
        end;
    9:  begin
          getpath;
          PopWindow(curtainClose);
          if pathname = '' then exit;
          if pathname[2] = ':' then
          Selectdisk(pathname[1]);
          ChgDirN(pathname,error);
          if error <> 0 then phaser;
          ShowDirectory;
        end;
  end; {end case}
end;

Procedure MenuMake;
begin
  MenuMakerMain ('I');     {Activate with first pull down}
  WHILE Scan = Scan DO
  BEGIN
    ReadKb (Scan,ASCIIChar);
    IF Scan IN [ArrowRtKey,ArrowLfKey,ArrowUpKey,ArrowDnKey,
                PageupKey,PagednKey,EscKey,EnterKey,F1key] THEN
     BEGIN
       if scan = f1key then
       begin
         pushshowwindow(VerticalBlinds,getmenu(12));
         pausekb;
         popwindow(verticalblinds);
       end;
       IF Scan = ArrowUpKey THEN
       begin
         MenuMakerMain('U');   {Move pull down menu bar}
         PopHelp;
       end;
       IF Scan = ArrowDnKey THEN
       begin
         MenuMakerMain('D');   {up and down}
         PopHelp;
       end;
       if Scan = PageupKey then
       begin
         Item := 1;
         MenuMakerMain('M');
         PopHelp;
       end;
       if Scan = PagednKey then
       begin
         Item := 9;
         MenuMakerMain('M');
         PopHelp;
       end;
       if Scan = Enterkey then DoOptions;
       IF Scan = EscKey THEN
       BEGIN
         Clearscn;
         CursorOn;
         Halt;
       END;
     END;
  END;
END;

procedure MoveBar;
begin
  sx:=1; sy:=1; ex:=80; ey:=25;
  MenuMake;
end;

Procedure PrepareColors;
var
  i: Integer;
  Window: Windowpointer;

begin
  SetColorsn(yellow,black);
  if stype = 'M' then
  begin
    itemfg:=lightgray; itembg:=black;
    barfg:= black; barbg:=lightgray;
    bordfg:= white; bordbg:=black;
    pfg:=black; pbg:=lightgray;
    for i := 1 to 30 do    {MonoMap Windows}
    begin
      window:=getmenu(i);
      if window <> nil      { may be tgenie gaps }
      then MonoMap(window);
    end;
  end else
  begin
    itemfg:=white; itembg:=green;
    barfg:= white; barbg:=black;
    bordfg:= white; bordbg:=black;
    pfg:=white; pbg:=black;
  end;
end;

begin
  TpGetMem(pointer(Sfl),sizeof(SflHeader));  {Get enough for maximum sized header}
  TpGetMem(buf,maxsize);
  PrepareColors;
  Showing:=false;
  Cursoroff;
  UniversalHelpRoutine:=UniversalHelp;
  ActiveSfl:='';
  CVA(Lightgray, Black, ShadeColor);
  ShowWindow(normal,getmenu(1));
  ShowDirectory;
  PushShowWindow(normal,getmenu(2));
  Mfg:=black; Mbg:=lightgray;
  MoveBar;
  Clearscn;
  CursorOn;
end.
