PROGRAM NSamp7;   { RamWindow Demonstration }

USES Crt, TPlus;

{ ******   Turbo-Genie RamWindow Debugging Aid Demonstration   ****** }

{ This program requires IBM or compatible hardware. }


TYPE MsgString = STRING [255];


{ The following is a sample User-Declared definition for the RamWindow
  procedure. The RamWindow will accept any valid field type but the VAR
  option must be included.  The VAR option notifies Pascal that the
  RamWindow procedure expects the address of the field to be passed on
  the stack and not the actual data.  The address of the field will
  then become the starting address for the RamWindow memory display.
  You can display your Turbo Pascal data areas containing your variables
  at any time within your program.  Just insert a RamWindow instruction
  anywhere and observe dynamically the changes your program makes to your
  variables.}


VAR ACharacter : CHAR;
    AByte      : BYTE;
    AInteger   : INTEGER;
    AMsg       : MsgString;


BEGIN
   ClearScn;
   FastWrite ('This program is about to load some values into some variables,',
               3, 0, 2);
   FastWrite ('and then use RamWindow to examine them in memory', 3, 0, 2);
   FastWrite ('Press RETURN to continue', 3, 0, 2);
   READLN;

   ACharacter := '$';        { The $ has a hex value of 24 }
   AByte := 3;               { A byte is a byte and the 3 is a 03 in memory }
   AInteger := 7;            { An integer requires 2 bytes.  You would think }
                             { that the integer 7 would look like 00 07 in }
                             { memory but infact it looks loke 07 00. This is }
                             { because INTEL designed their 16 bit register }
                             { to store in memory the low order byte first. }
                             { Though we may not agree with their reasoning, }
                             { that is the way they did it. }

   AMsg := 'Turbo-Genie';    { This message will follow after the AInteger
                               variable.  The first byte you will see will
                               not be the T.  Turbo Pascal reserves a 1 byte
                               length field in front of the string variables
                               to keep track of the current length of the string
                               it contains.  You should see a 0A (length of ten)
                               just in front of the "T". }

   { If you were to look in the memory of the computer starting at variable
     ACharacter you would see the following:  24 03 07 00 0A 54    etc.  }

   { We will now use RamWindow to see if we're right.  After the RamWindow has
     executed, the screen and cursor will be restored and the program will
     continue on with the next  instruction. }

   { You can place RamWindow anywhere in your program and see what's going on.}
   RamWindow (ACharacter);

   { Now let's change some of the variables and see what happens. }
   WRITELN ('The program will now change the variables and use RamWindow');
   WRITELN ('to look at them again.  Press RETURN to continue..');
   READLN;

   ACharacter := '!';
   AByte := 4;
   AMsg := 'With RamWindow';

   { Now let's use RamWindow to look at the changes. }
   RamWindow (ACharacter);

   WRITELN ('This message is displayed after RamWindow restores the screen');
   WRITELN ('Press RETURN to end program...');
   READLN;
END.
