PROGRAM NSamp6;     { NoBlink HELP Facility Shell }

USES Crt, tplus, TPWindow, Nsamp6a;

{ This program demonstrates an easy way to build menus.  See the HelpMenu
  procedure. The Menu was created with Screen Genie and converted to a
  Unit(NSAMP6A.TPU) with Turbo Genie. For more information on Menus refer
  to Nsamp14, and Nsamp15.}


CONST Head1 : String80 = '    ********************* NoBlink  HELP  Menu ***********************';
      Head2 : String80 = '           (keep your NoBlink diskette for future reference)';
      Head3 : String80 = '              You May Choose Any of The Following Topics';

      CPos : INTEGER = 0;         { CURSOR POSITION }
      MsgLine : INTEGER = 0;      { Menu Selects don't display message line }

VAR HAnswer : STRING[10];
    Total_Fields :  INTEGER;      { TOTAL NUMBER OF FIELDS BEING MAPPED }
    Current_Field : INTEGER;      { CURRENT FIELD BEING MAPPED }
    Option  : CHAR;               { MAPPING OPTION }
    RCode   : INTEGER;            { RETURN CODE }
    Answer  : STRING1;
    Scan    : BYTE;
    SType   : CHAR;
    startline,endline:integer;
    item:integer;

PROCEDURE GWriteLn (Msg : string);

BEGIN
   FastWrite (Msg, 15, 0, 2);
END;


PROCEDURE GWriteLnY (Msg : string);

BEGIN
   FastWrite (Msg, 14, 0, 2);
END;


PROCEDURE GWrite (Msg : string);

BEGIN
   FastWrite (Msg, 15, 0, 1)
END;


PROCEDURE GClrScn;

BEGIN
  ClearScn;
  movecursor(1,1);
END;



{ Topic for Option 1.  You can fill in your own topic information to match
  your menu }

PROCEDURE DOC1;

BEGIN
   GClrScn;
   GWriteLnY ('                           OVERVIEW');
   GWriteLn ('');
   GWriteLn ('NoBlink provides an anytime POP-UP WINDOW with a wide choice NON-BLINKING');
   GWriteLn ('or CONDITIONALLY-BLINKING cursors.');
   GWriteLn ('');
   GWriteLn ('It also gives you the ability to ACCELERATE or increase the speed with');
   GWriteLn ('which your cursor moves around your display.  The accelerator also');
   GWriteLn ('applies to key repeats, and is very useful in decreasing the time it');
   GWriteLn ('takes to move around in your Spread Sheets such as Quattro.');
   GWriteLn ('The acceletator can be active with any cursor including the Standard');
   GWriteLn ('Blinking cursor.');
END;


{ Topic 2.  Again you can replace this with your own GWriteLn statements }

PROCEDURE DOC2;

BEGIN
   GClrScn;

   GWriteLnY ('                          HOW TO INSTALL           ');
   GWriteLn ('');
   GWriteLn ('More stuff.');
END;


{ Topic 3 }

PROCEDURE DOC3;

BEGIN
   GClrScn;

   GWriteLnY ('                       HOW TO USE NOBLINK');
   GWriteLn ('');
   GWriteLn ('More stuff.');
END;


{ Topic 4 }

PROCEDURE DOC4;

BEGIN
   GClrScn;

   GWriteLnY ('                   HOW TO DISABLE OR REMOVE NOBLINK');
   GWriteLn ('');
   GWrite ('More stuff.');
END;


{ Topic 5 }

PROCEDURE DOC5;

BEGIN
   GClrScn;

   GWriteLnY ('                          HARDWARE REQUIREMENTS');
   GWriteLn ('');
   GWriteLn ('More Stuff');
END;


{ Topic 6 }

PROCEDURE DOC6;

BEGIN
   GClrScn;

   GWriteLnY ('                          SOFTWARE COMPATIBILITY');
   GWriteLn ('More stuff.');
END;


{ Topic 7 }

PROCEDURE DOC7;

BEGIN
   GClrScn;

   GWriteLnY ('                    WHO TO CALL OR WRITE');
   GWriteLn  ('');
   GWriteLnY (' Nostradamus, 801-487-9662 ');
END;


{--------------------------------------------------------------------------}
{                          H E L P   M E N U                               }
{--------------------------------------------------------------------------}
{ The Following routine displays the main help menu and requests a choice. }

PROCEDURE HelpMenu;

BEGIN
  setcursor($20,$20);                {Turn Cursor Off}
  repeat
  ShowWindow(FadeIn,GetMenu(1));       {Display Menu}
  MenuPick(curwindowx1,curwindowy1,curwindowx2,curwindowy2,lbracket,rbracket,
           item,0,7,8,2);      {Select Item}
  Case Item of
    1: doc1;
    2: doc2;
    3: doc3;
    4: doc4;
    5: doc5;
    6: doc6;
    7: doc7;
  end; {end case}
  if (item <> 8) and (item <> 0) then pausekb;
  until (item = 8) or (item = 0);
  setcursor(startline,endline);      {Turn Cursor Back On}
END;


{ The following procedure is used when NoBlink install determines that the
  user wants help.

  The SnapShot is used to restore the screen upon exit from the help facility.}


PROCEDURE NBHELP;

BEGIN
   SnapShot (2);                  { SnapShot screen with clear screen Option }
   HelpMenu;                      { mapgen menu }
   SnapShot (3)                   { restore screen }
END;


                    {************ MAINLINE *************}


BEGIN
   Getcursor(startline,endline);
   setcolorsn(lightgray,black);  {Turbo Pascal has a bad habit of guessing}
   item:=1;       {MenuPick requires initial value}
   ClearScn;
   WRITELN;
   WRITELN;
   WRITELN ('=========================================================================');
   WRITELN ('   ** NoBlink(tm)  Information and Installation  Utility **');
   WRITELN;
   WRITELN ('                  Copyright (C) 1985-87');
   WRITELN ('                    Nostradamus Inc.  ');
   WRITELN ('                  All Rights Reserved');
   WRITELN;
   WRITELN;
   WRITELN ('NoBlink works with the TURBO PASCAL EDITOR.  I am using a red cursor');
   WRITELN ('that highlights the character within as bright white.  It''s great!!');
   WRITELN ('And instead of taking 8 seconds for my cursor to cross the screen it');
   WRITELN ('only takes 2 seconds.');
   WRITELN;
   Answer:= 'Y';

   WRITELN;
   WRITELN ('Would you like to reference the HELP facility?');
   WRITE ('Y)es or N)o to exit  > ');

   WHILE (ANSWER <> 'N') DO
      BEGIN
         ReadKb (Scan, Answer);
         Answer[1] := UPCASE (Answer[1]);
         IF Answer = 'Y' THEN
            NBHELP;               { Sets "N" on exit, saves re-typing }
      END;

   { ALL DONE; WRITE ENDING MESSAGE }

   ClearScn;
   movecursor(1,8);
   FastWrite ('NoBlink has not really been installed.', white,red,2);
   WRITELN;
   FastWrite ('Remove the NoBlink diskette and Boot (Ctrl-alt-del) ', 2, 0, 2);
   FastWrite ('your system to make NoBlink available.', 2, 0, 2);
   WRITELN;
   FastWrite ('Keep your NoBlink diskette so you can refer to the', 2, 0, 2);
   FastWrite ('informational "HELP" facility.', 2, 0, 2);
   WRITELN;

END.
