PROGRAM NSAMP4; {Advanced Keyboard Control Demonstration}
uses Tplus,tpwindow,nsamp4a;

var kbflag : byte absolute $40:$17 ;
    lsonly : byte;
    fg,bg  : integer;
    msg    : string[255];

{The kbflag contains the current state of the keyboard.  The following
is a list of the state keys and their associated values:

        STATE                         KBFLAG VALUE }

CONST
        Insert       :  byte =            128         ;
        Caps         :  byte =             64         ;
        Numeric      :  byte =             32         ;
        Scroll       :  byte =             16         ;
        Alt_Shift    :  byte =              8         ;
        Ctl_Shift    :  byte =              4         ;
        Left_Shift   :  byte =              2         ;
        Right_Shift  :  byte =              1         ;


{
These code are cummulative.  For example with num-lock and caps lock active
the value in Kbflag would be 64+32 = 96 . }




var scan:byte;
    acode:string1;
    desc:string6;

BEGIN
fg:=0;
bg:=7;
SetCursor($20,$20);  {Hide Cursor}
scan:=0;
ShowWindow(Exploding,GetScreens(1));
REPEAT
ReadKb(scan,acode);
IF scan <> Esckey then
BEGIN
  MoveCursor(44,14);    str(kbflag,msg);  fastwrite(msg+'     ',fg,bg,1);
  MoveCursor(44,16);    str(scan,msg);  fastwrite(msg+'    ',fg,bg,1);
  MoveCursor(44,18);      fastwrite(acode,fg,bg,1);
  MoveCursor(44,20);    str(ord(acode[1]),msg);  fastwrite(msg+'   ',fg,bg,1);
  {Next let's check to see if the  BACK SPACE was pressed along with the
  LEFT-SHIFT KEY.}

  IF scan = 14 THEN       {If back space then check for left shift}
    BEGIN
      lsonly := kbflag and (left_shift);     {remove other states}
      if lsonly = left_shift then            {see if left-shift is present}
        BEGIN
          MoveCursor(20,21);
          fastwrite('Bingo, Left Shift with Back Space recognized!!',fg,bg,1);
        END;
    END
    else
    begin
      MoveCursor(20,21);
      fastwrite('                                                 ',15,1,1);
     end;
  ShowKb(scan,acode,desc);
  MoveCursor(44,22);    FastWrite(desc,0,7,1);
END;
UNTIL scan = EscKey;
setcursor(istartline,istopline); {Restore Cursor to program start values}
if paramstr(1) <> 'DEMO' then ClearScn;   {Used by Nsamp9}
END.