PROGRAM Nsamp3;

USES Crt, TPlus, TpWindow, Nsamp3a;


{************************************************************************}
{                                                                        }
{         Nsamp3 demonstrates a Screen Genie Screen placed into a        }
{         Turbo Pascal Unit with Turbo Genie. Nsamp3a.udf was created    }
{         by Turbo Genie.  It contains an entry for the Screen Genie     }
{         screen Nsamp3.scn.  UDF stands for Unit Definition File.       }
{         Normally, UDF's contain entries for more than one screen,      }
{         window, or menu. While in Turbo Genie, F4 is used to create    }
{         the pascal source code based on information in the UDF.        }
{         The Turbo Pascal compiler was used to compile Nsamp3a.pas      }
{         into Nsamp3a.tpu.                                              }
{                                                                        }
{         To view the screen used in this example use Screen Genie by    }
{         entering SGEDIT at the DOS prompt.  Then provide a Work File   }
{         name of NSAMP3.SCN.  To view the UDF for this example use      }
{         Turbo Genie by entering TGENIE at the DOS prompt.  Then        }
{         provide a UDF name of NSAMP3A.UDF.                             }
{                                                                        }
{         Screens, Windows and Menus are displayed with ShowWindow.      }
{         In this example, ShowWindow is used to display Nsamp3.scn      }
{         using the CurtainClose display option.                         }
{                                                                        }
{         This program also demonstrates the Display Mapping routines    }
{         in a simple order entry application.                           }
{                                                                        }
{************************************************************************}


CONST {******** Product Descriptions ********}
      IRDesc = 'Instant Replay(s)        ';
      NBDesc = 'NoBlink/Accelerator(s)   ';
      TPDesc = 'Turbo-Plus Version 5.5   ';

      {*********** Product Prices ***********}
      IRPrice = 149.95;
      NBPrice = 49.95;
      TPPrice = 149.95;

      { Attribute BYTEs for Display Procedure}
      cyanblack         : BYTE = $03;
      greenblack        : BYTE = $02;
      lightmagentablack : BYTE = $0d;

TYPE Str1      = STRING [1];
     Str2      = STRING [2];
     Str4      = STRING [4];
     Str6      = STRING [6];
     Str8      = STRING [8];
     Str10     = STRING [10];
     Str20     = STRING [20];
     Str25     = STRING [25];
     Str30     = STRING [30];
     Str80     = STRING [80];

     OrderType = RECORD
                    Quantity    : INTEGER;
                    Code        : Str2;
                    Description : Str25;
                    UnitCost    : REAL;
                    LineTotal   : REAL;
                 END;
     CustType  = RECORD
                    Date       : Str6;
                    Name       : Str30;
                    Phone      : Str10;
                    Company    : Str25;
                    Street1    : Str25;
                    Street2    : Str25;
                    City       : Str25;
                    State      : Str2;
                    ZipCode    : Str10;
                    Order      : ARRAY [1..3] OF OrderType;
                    SubTotal   : REAL;
                    ShipCosts  : REAL;
                    Taxes      : REAL;
                    Total      : REAL;
                    CCType     : Str1;
                    CCNumb     : Str20;
                    ExpDate    : Str4;
                 END;

VAR
    SType     : CHAR;
    OK        : BOOLEAN;
    Customer  : CustType;

{*********************************************************************}
{          GetDescrip returns the description of a product            }
{*********************************************************************}

FUNCTION GetDescrip (Code : Str2) : Str25;

BEGIN
   GetDescrip := '';
   IF Code = 'IR' THEN
      GetDescrip := IRDesc
   ELSE IF Code = 'NB' THEN
      GetDescrip := NBDesc
   ELSE IF Code = 'TP' THEN
      GetDescrip := TPDesc;
END;


{*********************************************************************}
{        GetPrice returns the Unit Cost of a product                  }
{*********************************************************************}

FUNCTION GetPrice (Code : Str2) : REAL;

BEGIN
   GetPrice := 0.0;
   IF Code = 'IR' THEN
      GetPrice := IRPrice
   ELSE IF Code = 'NB' THEN
      GetPrice := NBPrice
   ELSE IF Code = 'TP' THEN
      GetPrice := TPPrice;
END;

{*********************************************************************}
{           InitCustomer initializes the values of Customer           }
{*********************************************************************}

PROCEDURE InitCustomer (VAR Customer : CustType);

VAR Counter : INTEGER;

BEGIN
   WITH Customer DO
      BEGIN
         FOR Counter := 1 TO 3 DO
            BEGIN
               Order [Counter].Quantity := 0;
               Order [Counter].Code     := '';
               Order [Counter].Description := '                           ';
               Order [Counter].UnitCost    := 0.0;
               Order [Counter].LineTotal   := 0.0;
            END;
         Date       := '000000';
         Name       := '';
         Phone      := '**********';
         Company    := '';
         Street1    := '';
         Street2    := '';
         City       := '';
         State      := '';
         ZipCode    := '';
         SubTotal   := 0.0;
         ShipCosts  := 0.0;
         Taxes      := 0.0;
         Total      := 0.0;
         CCType     := '';
         CCNumb     := '';
         ExpDate    := '0000';
      END;
END;  { InitCustomer }


{*********************************************************************}
{  DspBackground generates the Background Image for the Entry Screen  }
{*********************************************************************}

{ Refer to Nsamp3a.udf with Turbo Genie }

PROCEDURE DspBackground;           {Screen is in Nsamp3a.tpu}
BEGIN
  ShowWindow(CurtainClose,getscreen(1));    {Built with Screen Genie,}
END;                               {made into a Unit with Turbo Genie}


{*********************************************************************}
{                    EntryScreen Procedure                            }
{*********************************************************************}

PROCEDURE EntryScreen (VAR Customer : CustType);
{$V-}

CONST msgline    : INTEGER = 25;
      ftype      : CHAR    = 'S';
      fg         : INTEGER = yellow;
      bg         : INTEGER = black;
      afg        : INTEGER = black;
      abg        : INTEGER = lightgray;
      cpos       : INTEGER = 1;
      numbcurs   : INTEGER = 0;
      rcode      : INTEGER = 0;
      writercode : INTEGER = 0;

VAR StrNum     : Str10;
    Field      : INTEGER;
    Option     : CHAR;
    AutoJump   : CHAR;
    SType      : CHAR;
    TotFields  : INTEGER;
    I, Counter : INTEGER;

BEGIN
   ScreenType (SType);
   IF SType = 'C' THEN
      BEGIN
         afg := white;
         abg := red;
      END;
   Option := 'W';
   AutoJump := 'W';
   WITH Customer DO
      BEGIN
         ClearScn;
         DspBackground;
         TotFields := 27;
         FOR Counter := 1 TO 2 DO
            BEGIN
               Field := 1;
               numbcurs := 0;
               cpos := 1;
               REPEAT
                  CASE Field OF
                     1 : MapString (Option, 6, 5, msgline, lightcyan, bg, afg,
                            abg, rcode, cpos, Date, 'Entry Date: &&/&&/&&');
                     2 : MapString (Option, 3, 6, msgline, lightcyan, bg, afg,
                            abg, rcode, cpos, Name,
                            'Customer Name: ##############################');
                     3 : MapString (Option, 50, 6, msgline, lightcyan, bg, afg,
                            abg, rcode, cpos, Phone, '  Phone: (&&&) &&&-&&&&');
                     4 : MapString (Option, 9, 7, msgline, lightcyan, bg, afg,
                            abg, rcode, cpos, Company,
                            'Company: #########################');
                     5 : MapString (Option, 9, 8, msgline, lightcyan, bg, afg,
                            abg, rcode, cpos, Street1,
                            'Address: #########################');
                     6 : MapString (Option, 9, 9, msgline, lightcyan, bg, afg,
                            abg, rcode, cpos, Street2,
                            '         #########################');
                     7 : MapString (Option, 12, 10, msgline, lightcyan, bg,
                            afg, abg, rcode, cpos, City,
                            'City: #########################');
                     8 : MapString (Option, 44, 10, msgline, lightcyan, bg,
                            afg, abg, rcode, cpos, State, 'State: >>');
                     9 : MapString (Option, 54, 10, msgline, lightcyan, bg,
                            afg, abg, rcode, cpos, ZipCode,
                            'ZipCode: ##########');
                    10 : MapInt (AutoJump, 7, 14, msgline ,lightcyan, bg, afg,
                            abg, rcode, numbcurs, Order[1].Quantity, '##');
                    11 : BEGIN
                           MapString (AutoJump, 15, 14, msgline, lightcyan, bg,
                              afg, abg, rcode, cpos, Order[1].Code,'>>');
                           Order[1].Description := GetDescrip (Order[1].Code);
                           Order[1].UnitCost    := GetPrice (Order[1].Code);
                           MoveCursorF(21,14);
                           FastWrite (Order[1].Description, lightcyan, bg, 3);
                           MapReal ('W', 54, 14, msgline, lightcyan, bg, afg,
                              abg, writercode, cpos,
                              Order[1].UnitCost, '$###.##');
                         END;
                    12 : MapString (Option, 21, 14, msgline, lightcyan, bg,
                            afg, abg, rcode, cpos,
                            Order[1].Description, '#########################');
                    13 : MapReal (Option, 54, 14, msgline, lightcyan, bg, afg,
                            abg, rcode, numbcurs, Order[1].UnitCost,'$###.##');
                    14 : MapInt (AutoJump, 7, 15, msgline, lightcyan, bg, afg,
                            abg, rcode, numbcurs, Order[2].Quantity, '##');
                    15 : BEGIN
                           MapString (AutoJump, 15, 15, msgline, lightcyan, bg,
                              afg, abg, rcode, cpos,
                              Order[2].Code, '>>');
                           Order[2].Description := GetDescrip (Order[2].Code);
                           Order[2].UnitCost    := GetPrice (Order[2].Code);
                           MoveCursorF(21,15);
                           FastWrite (Order[2].Description, lightcyan, bg, 3);
                           MapReal ('W', 54, 15, msgline, lightcyan, bg, afg,
                              abg, writercode, cpos,
                              Order[2].UnitCost, '$###.##');
                         END;
                    16 : MapString (Option, 21, 15, msgline, lightcyan, bg,
                           afg, abg, rcode, cpos,
                           Order[2].Description, '#########################');
                    17 : MapReal (Option, 54, 15, msgline, lightcyan, bg, afg,
                           abg, rcode, numbcurs,
                           Order [2].UnitCost, '$###.##');
                    18 : MapInt (AutoJump, 7, 16, msgline, lightcyan, bg, afg,
                           abg, rcode, numbcurs, Order[3].Quantity, '##');
                    19 : BEGIN
                           MapString (AutoJump, 15, 16, msgline, lightcyan, bg,
                             afg, abg, rcode, cpos, Order[3].Code, '>>');
                           Order[3].Description := GetDescrip (Order[3].Code);
                           Order[3].UnitCost    := GetPrice (Order[3].Code);
                           MoveCursorF (21,16);
                           FastWrite (Order[3].Description, lightcyan, bg, 3);
                           MapReal ('W', 54, 16, msgline, lightcyan, bg, afg,
                             abg, writercode, cpos,
                             Order[3].UnitCost, '$###.##');
                         END;
                    20 : MapString (Option, 21, 16, msgline, lightcyan, bg,
                           afg, abg, rcode, cpos,
                           Order[3].Description, '#########################');
                    21 : MapReal (Option, 54, 16, msgline, lightcyan, bg, afg,
                           abg, rcode, numbcurs,
                           Order[3].UnitCost, '$###.##');
                    22 : MapReal (Option, 52, 18, msgline, lightcyan, bg, afg,
                           abg, rcode, numbcurs, SubTotal,
                           'Sub Total    $#######.##');
                    23 : MapReal (Option, 52, 19, msgline, lightcyan, bg, afg,
                           abg, rcode, numbcurs,
                           ShipCosts, 'Ship/Handling  $#####.##');
                    24 : MapReal (Option, 52, 20, msgline, lightcyan, bg, afg,
                           abg, rcode, numbcurs, Total,
                           'Total Due    $#######.##');
                    25 : MapString (Option, 3, 21, msgline, lightcyan, bg, afg,
                           abg, rcode, cpos, CCType, 'CC: >');
                    26 : MapString (Option, 9, 21, msgline, lightcyan, bg, afg,
                           abg, rcode, cpos, CCNumb,
                           'No: &&&&&&&&&&&&&&&&&&&&');
                    27 : MapString (Option, 35, 21, msgline, lightcyan, bg, afg,
                           abg, rcode, cpos, ExpDate, 'Exp: &&/&&');
                  END; { Case }

                  IF (Option = 'R') OR
                     ((Option = 'W') AND (Field = 1)) THEN
                    BEGIN
                       CursorOff;
                       SubTotal := 0.0;
                       FOR i := 1 to 3 do
                         BEGIN
                           Order[i].LineTotal := Order[i].Quantity *
                               Order[i].UnitCost;
                           MapReal ('W', 67, 13 + i, msgline, lightcyan, bg,
                               afg, abg, writercode, cpos,
                               Order[i].LineTotal, '$#####.##');
                           SubTotal := SubTotal + Order[i].LineTotal;
                        END;
                      MapReal('W', 52, 18, msgline, lightcyan, bg, afg, abg,
                         writercode, cpos,
                         SubTotal, 'Sub Total    $#######.##');
                      Total := SubTotal + ShipCosts;
                      MapReal ('W', 52, 20, msgline, lightcyan, bg, afg, abg,
                         writercode,cpos,
                         Total, 'Total Due    $#######.##');
                      CursorOn;
                    END;

                  CASE rcode OF
                    arrowupkey : BEGIN
                                   numbcurs := 0;
                                   cpos := 1;
                                   IF Field <= 1 THEN
                                     Field := TotFields
                                   ELSE
                                     Field := Field - 1;
                                 END;
                    arrowdnkey,enterkey : BEGIN
                                   numbcurs := 0;
                                   cpos := 1;
                                   IF Field >= TotFields THEN
                                     Field := 1
                                   ELSE
                                     Field := Field + 1;
                                 END;
                    ELSE IF ((Option = 'W') AND
                            (Field <= TotFields)) THEN
                       Field := Field + 1
                       { ELSE Field := 1 };
                 END;
              UNTIL ((Option = 'W') AND (Field > TotFields)) OR
                    (rcode = esckey);
              Option := 'R';
              AutoJump := 'E';
            END;
      END;
END; { EntryScreen }


BEGIN   { MAIN }
   InitCustomer (Customer);
   EntryScreen (Customer);
   ClearScnHome;
   Cursoron;
END. { main }
