PROGRAM NSamp2; { Turbo-Genie Display Mapping Demonstration }

USES TPlus;

{ This program demonstrates the power of the Mapping procedures: MapString,
  MapReal, and Mapint.

  Because MAPFIELD is written in assembler and is supplied in the Nostradamus
  Turbo Plus UNIT, you SAVE ON COMPILATION TIME, and get a more professional
  application program that is at least 15K SMALLER than it would be if you
  wrote the same features in Pascal.  And the routines are FAST, as this
  program demonstrates.

  This program requires an IBM or compatible machine. }


VAR Total_Fields  :  INTEGER;     { TOTAL NUMBER OF FIELDS BEING MAPPED }
  Current_Field : INTEGER;      { CURRENT FIELD BEING MAPPED }
  Option  : CHAR;
  COption : CHAR;               { MAPPING OPTION FOR AUTO CLEAR FIELDS }
  RCode   : INTEGER;            { RETURN CODE }
  Info    : String1;            { USED WITH INFORMATION ONLY MASK }
  MsgLine : INTEGER;
  CPos    : INTEGER;
  Field1  : AnyStr;
  Field2  : AnyStr;
  Field3  : AnyStr;
  Field4  : AnyStr;
  Field5  : REAL;
  Field6  : REAL;
  Field7  : REAL;
  Field8  : REAL;
  Field9  : REAL;
  Field10 : INTEGER;
CONST
  { Foreground and background color constants }
  Black         = 0;
  Blue          = 1;
  Green         = 2;
  Cyan          = 3;
  Red           = 4;
  Magenta       = 5;
  Brown         = 6;
  LightGray     = 7;

  { Foreground color constants }
  DarkGray      = 8;
  LightBlue     = 9;
  LightGreen    = 10;
  LightCyan     = 11;
  LightRed      = 12;
  LightMagenta  = 13;
  Yellow        = 14;
  White         = 15;

{$V-}                             { DO NOT FORCE LENGTH MATCHING ON STRINGS }

BEGIN
  ClearScnHome;
  Field1  := '';                 { Initialize starting values }
  Field2  := '';
  Field3  := '';
  Field4  := '';
  Field5  := 112.61;
  Field6  := 32.00;
  Field7  := 4005.0;
  Field8  := 32.10;
  Field9  := 7.0;
  Field10 := 33;
   Total_Fields := 15;            { NUMBER OF FIELDS BEING MAPPED }
  Current_Field := 1;            { START WITH FIRST FIELD }
  Option := 'W';                 { MAPPING OPTION, START WITH FIELD WRITES }
  COption := 'W';
  MsgLine:=25;
   { DISPLAY ALL MAP FIELDS, AND THEN RETRIEVE DATA FROM OPERATOR }
  REPEAT
    CPos := 0;
    CASE Current_Field of
      1 :  MapString ('W', 23, 2, MsgLine, white, black, white, black,
                      RCode, CPos, Info,
                      'Turbo Plus Display Map Demonstration');
      2 :  MapString (Option, 9, 4, MsgLine, lightgray, black, white, red,
                      RCode, CPos, Field1, 'String Field #############');
      3 :  MapString (Option, 9, 5, MsgLine, green, black, black, lightgray,
                      RCode, CPos, Field2,
                      'String Field ### With ##  Mixed #### Mask');
      4 :  MapString (Option, 9, 6, MsgLine, lightcyan, black, white, red,
                      RCode, CPos, Field3,
                      'String With Upper Case >>> Lower Case <<<');
      5 :  MapString (Option, 9, 7, MsgLine, cyan, black, white, magenta,
                      RCode, CPos, Field4,
                      'String Field With Numerics Only &&&-&&-&&&&');
      6 :  MapReal (Option, 1, 9, MsgLine, white, black, yellow, blue,
                    RCode, CPos, Field5, 'Real Number Field ########.##');
      7 :  MapReal (Option, 1, 10, MsgLine, magenta, lightgray, white, red,
                    RCode, CPos, Field6,
                    'Real Number With Floating Dollar $######.##');
      8 :  MapReal (Option, 1, 11, MsgLine, yellow, cyan, white, red,
                    RCode, CPos, Field7,
                    'Real Number With Zero Fill [@########.####] ');
      9 :  MapReal (Option, 1, 12, MsgLine, lightcyan, black, white, red,
                    RCode, CPos, Field8,
                    'Real Number With Asterisk Fill *#######.#####');
     10 :  MapReal (COption, 1, 13, MsgLine, lightgreen, black, white, red,
                    RCode, CPos, Field9,
                    'Real Number With Auto Clear *#######.##');
     11 :  MapInt (Option, 50, 14, MsgLine, magenta, black, black, lightgray,
                   RCode, CPos, Field10, 'Integer Number #####');
     12 :  MapString ('W', 10, 17, MsgLine, yellow, black, black, lightgray,
                     RCode, CPos, Info,
                     'Try Arrow Keys, and enter data in fields.');
     13 :  MapString ('W', 10, 18, MsgLine, yellow, black, black, lightgray,
                     RCode, CPos, Info, 'Try Insert Key, and Delete Key.');
     14 :  MapString ('W', 10, 19, MsgLine, yellow, black, black, lightgray,
                      RCode, CPos, Info, 'Try Num-Lock and Caps-Lock.');
     15 :  MapString ('W', 10, 20, MsgLine, yellow, black, black, lightgray,
                     RCode, CPos, Info, 'Press Esc Key to Exit.');
    END; { END of CASE }
    movecursor(1,1);

    IF Option = 'W' THEN
      BEGIN                          { WRITING FIELDS }
        IF Current_Field < Total_Fields THEN
           Current_Field := Current_Field + 1
        ELSE
        BEGIN
          Option := 'R';        { FIELDS DISPLAYED, SO SWITCH TO READ }
          COption := 'C';       { AND READ CLEAR FOR SPECIFIC FIELDS }
          Current_Field := 2;   { START WITH SECOND (THE FIRST FIELD IS
                                { A HEADING }
        END;
      END
      ELSE
      BEGIN                          { READING FIELDS }
        { FORWARD FIELD }
        IF (RCode = arrowdnkey) OR (RCode = tabkey) OR
        (RCode = enterkey) THEN
        BEGIN
          IF Current_Field = 11 THEN
          Current_Field := 2  { SKIP HEADING FIELD }
          ELSE
          Current_Field := Current_Field + 1;
        END;

        { BACKWARD FIELD }
        IF (RCode = arrowupkey) OR (RCode = shifttabkey) THEN
        BEGIN
          IF Current_Field = 2 THEN
          Current_Field := 11  { SKIP COMMENT FIELDS }
          ELSE
          Current_Field := Current_Field - 1
        END;

          { OTHERWISE RE-ACTIVATE FIELD }
        CPos := 0;             { LAND CURSOR ON FIRST NON-BLANK }
      END;                      { END READS BLOCK }
  UNTIL RCode = esckey;          { EXIT MAP WHEN EXCAPE KEY STRUCK }
  ClearScnHome;
END.

