PROGRAM NSamp18;

{  This program demonstrates the use of the various Sounds available in the
   Turbo Plus package.  The program uses a UniversalMenu call to build the
   menu, then executes the appropriate sound routine. The background window
   was built using Screen Genie and Turbo Genie. The UNIT is NSamp18a.

   To use TGenie for this program, we built a screen with Screen Genie, and
   then saved it in compressed form.  Next, we called TGenie; it asks for a
   .UDF filename, and we used NSAMP18A.UDF.  A file called NSAMP18A.UDF was
   built, as was one called NSAMP18A.PAS.  To use the resulting UNIT, we put
   a USES statement with NSAMP18A in it, at the top of your program, as you
   see in the next line. }


USES Crt, TPlus, TPWindow, NSamp18a;

VAR Ch : CHAR;
    Choices : ARRAY[1..27] of STRING[15];
    Item : INTEGER;
    Window : WindowPointer;
    I,J : INTEGER;
    Afg,Abg : INTEGER;

{ Create A Sounds Menu with the Universal Menu Maker }
Procedure DoMenu;
VAR Sfg,Sbg : INTEGER;
BEGIN
   if stype = 'C' then
   begin
     afg:=white;
     abg:=green;
   end else
   begin
     afg:=black;
     abg:=lightgray;
   end;
   UniversalMenu ( ThinLine,         { border type }
                   12,8,             { upper left corner}
                   White,brown,       { menu Color }
                   Afg,Abg,          { bar colors }
                   cyan,black,       { border colors }
                   Choices[1][1],    { Start of Items in Memory }
                   16,               { item size }
                   26,               { Number of items }
                   3,                { VisualsPerLine }
                   15,               { VisualsWidth }
                   9,                { Height of menu }
                   'Turbo Plus Sounds',
                   Item);
  SetColorsN (Sfg, Sbg);
  UniversalRedraw:=False;
END;


BEGIN
   CursorOff;
   Clearscn;
   item:=1;
   Window := InfoWindow (1);
   ShowWindow (FadeIn, Window);
   pausekb;
   Choices [1]  := 'Bats #1        ';
   Choices [2]  := 'Birds          ';
   Choices [3]  := 'Clock          ';
   Choices [4]  := 'Machinery #1   ';
   Choices [5]  := 'Crickets       ';
   Choices [6]  := 'Doorbell       ';
   Choices [7]  := 'Explosion      ';
   Choices [8]  := 'Generator #1   ';
   Choices [9]  := 'Machinery #2   ';
   Choices [10] := 'Phaser         ';
   Choices [11] := 'Dial phone     ';
   Choices [12] := 'Ring phone     ';
   Choices [13] := 'Photon Torpedo ';
   Choices [14] := 'Random Sounds  ';
   Choices [15] := 'Invader Saucer ';
   Choices [16] := 'Siren #1       ';
   Choices [17] := 'Leaky faucet   ';
   Choices [18] := 'Train passing  ';
   Choices [19] := 'Siren #2       ';
   Choices [20] := 'Thinking       ';
   Choices [21] := 'Bats #2        ';
   Choices [22] := 'Machinery 3    ';
   Choices [23] := 'Click          ';
   Choices [24] := 'Zoink          ';
   Choices [25] := 'Wolf whistle   ';
   Choices [26] := 'EXIT           ';

   REPEAT
      DoMenu;
      CASE Item OF
         1 : Screeches;
         2 : for i := 1 to 4 do Birds;
         3 : for i:= 1 to 3 do ClockSound;
         4 : Machinery1;
         5 : for i := 1 to 3 do Chirps;
         6 : Doorbuzzer;
         7 : CrashAndBurn;
         8 : Generator1;
         9 : Machinery3;
         10 : Phaser;
         11 : BEGIN
                 FOR I := 1 TO 7 DO
                    BEGIN
                       FOR J := 1 TO RANDOM (8) + 1 DO
                          BEGIN
                             Click;
                             DELAY (100);
                          END;
                       DELAY (500);
                    END;
                 DialBusyPhone;
              END;
         12 : PhoneRing;
         13 : PhotonTorpedo;
         14 : RandomSounds;
         15 : for i := 1 to 3 do InvadersSaucer;
         16 : Siren1;
         17 : for i:= 1 to 4 do DrippingSpigot;
         18 : Train;
         19 : Siren2;
         20 : for i:=1 to 40 do ElectronicSounds;
         21 : Screeches2;
         22 : Machinery3;
         23 : Click;
         24 : Zoink;
         25 : WolfWhistle;
      END;   { CASE }
      NOSOUND;   { Be sure sound is off }
   UNTIL Item = 26;
   SetColorsN(lightgray,black);
   ClearScnHome;
   CursorOn;
END.
