{$R-,S+,I+,D+,F-,V-,B-,N-,L+ }
{$M 8000,15000,15000 }
PROGRAM Nsamp17;

{ This program demonstrates the use of the System_Resources routine within the
  Turbo Genie package.  It displays global variable information that was
  set by the System_Resources procedure. System_Resources is called by the
  TPLUS initialization routine automatically.}


USES Crt, TPlus, TPWindow, Nsamp17a;


TYPE String255 = STRING [255];


VAR InfoWindow : WindowPointer;
    WindowName : String65;
    Ec         : INTEGER;
    SaveX,SaveY: INTEGER;

PROCEDURE ShowVideo (VType : INTEGER);

BEGIN
   CASE VType OF
      0 : WRITE ('No Card');
      1 : WRITE ('Color/Color');
      2 : WRITE ('Mono/Mono');
      3 : WRITE ('EGA/Color');
      4 : WRITE ('EGA/Mono');
      5 : WRITE ('EGA/ECM');
      6 : WRITE ('VGA');
  END;
END;


BEGIN
   FindCursor (SaveX,SaveY);
   SetColorsN (Yellow, Black);
   IF Display_Mode in [2,3,7] THEN
      BEGIN
         PushShowWindow (CurtainOpen, MyWins (1));
      END;
   GOTOXY (66,7);                 { Computer Type }
   CASE Computer_Type OF
      $FF : WRITE ('PC');
      $FE : WRITE ('XT');
      $FD : WRITE ('PCjr');
      $FC : WRITE ('AT');
      ELSE
            WRITE ('PS/2');
   END;
   CursorOff;
   GOTOXY (66,8);                 { DOS Version }
   WRITE (Major_DOS_Version,'.',Minor_DOS_Version);
   GOTOXY (66,9);                 { Active Display }
   ShowVideo (Active_Video);
   GOTOXY (66,10);                { Alternate Display }
   ShowVideo (Alternate_Video);
   GOTOXY (66,11);                { Display Mode }
   WRITE (Display_Mode);
   GOTOXY (66,12);
   WRITE (TpMaxXw,' by ',TpMaxYw);
   GOTOXY (66,13);                { EGA Memory }
   CASE EGA_Memory OF
      0 : WRITE ('None');
      1 : WRITE ('64k');
      2 : WRITE ('120k');
      3 : WRITE ('192k');
      4 : WRITE ('256k');
   END;
   GOTOXY (66,14);                 { Total Disks }
   WRITE (Number_Of_Disks);
   GOTOXY (66,15);                 { Total Printers }
   WRITE (Number_Of_Printers);
   GOTOXY (66,16);                 { Total Serial Adapters }
   WRITE (Number_Of_Serial_Adapters);
   GOTOXY (66,17);                 { Total RAM }
   WRITE (System_RAM, ' K');
   GOTOXY (66,18);                 { Available Ram }
   WRITE (Available_RAM+47,' K');
   GOTOXY (66,19);                 { Available Extended AT Memory }
   WRITE (Extended_System_RAM,' K');
   PauseKb;
   IF Display_Mode IN [2,3,7] THEN
      PopWindow (CurtainClose);
   MoveCursor (SaveX,SaveY);
   CursorOn;
END.
