
          {++++++++++++++++++++++++++++++++++++++++++++++++}
          {                                                }
          {               Turbo Plus Vers 5.0              }
          {             BuildMap Sample Program            }
          {                                                }
          {++++++++++++++++++++++++++++++++++++++++++++++++}

{  This sample program demonstrates the use of the BuildMap procedure.
   The BuildMap procedure displays any window on the screen and allows the
   user to change the colors. The colors are mapped into an array of type
   MapArray which holds the new colors. The MapArray can be used in
   several ways:

     1- Save the Array in a configuration file and ColorMap the Windows
        at run-time as they are displayed.

     2- The Array can be applied to the window and then the window saved to
        disk using the WriteWindow procedure.  This sample program uses this
        method. This method can be used anytime the windows are read in at
        run-time.  Nsamp15 is a sample program that reads the windows at
        run-time.

     3- The Array can be applied to the window and then the window can be
        saved using the UpdateEXEWindow procedure. This works only for
        windows that are compiled into the program using Turbo Genie.

     4- This array is also good for keeping track of colors used by normal
        writes to the screen. A different position in the array could stand
        for a different color needed by the program. Then the Array could
        be saved as part of the configuration file.

   BuildMap has it's own help facility. Just Press F1 to see a help screen that
   describes all of the commands available from within BuildMap. Here is a
   summary:

        Arrow Keys  =  Move Selection Box
        Shift Arrow Keys = Move Sample Window
        F1key = Help Screen
        F2Key = Return to Original Color Mapping
        F3Key = Mono/Color Mapping Mode
        F4Key = High/Blinking Color Toggle
        F10Key = Exit and Submit the Changes
        Esc = Exit without submitting Changes
                                                                              }



{$R-,S+,I+,D+,F-,V+,B-,N-,L+ }
{$M 4096,16384,655356 }
PROGRAM Buildtest;

USES TPlus,
     TPWindow;

VAR
    Map        : MapArray;         { MapArray is an array[0..255] of byte }
    Changed    : BOOLEAN;
    TestWindow : WindowPointer;
    Path       : String65;
    Scan       : BYTE;
    Ascii      : String1;


BEGIN
  setcolorsn(0,7);
  ClearScnHome;

      { Load the first pull down menu of NSamp15 }

  Path := 'WgPull2.win';
  LoadWindow (Path, TestWindow);

      { If successful then call Build Map }

  IF (Window_Error = Success) THEN
    BuildMap (TestWindow, Map, Changed) else
    BEGIN
       NewLine;
       FastWrite ('Unable To Load Window '+path,12,0,2);
       halt;
    END;
      { If successful and user has changed window then ask to save window }
  IF (Window_Error = Success) THEN
  BEGIN
    IF Changed THEN
    BEGIN
      FastWrite ('Do you want to save the changes? (Y or N) ',4,0,1);

       { Repeat until user presses y or n }

      REPEAT
        ReadKB (Scan, Ascii);
      UNTIL UPCASE (Ascii[1]) in ['Y','N'];


      { Yes, change window & apply returned colormap and update the window file }

      IF UPCASE (Ascii[1]) = 'Y' THEN
      BEGIN
        Colormap (TestWindow, Map);           { Apply Color Map to Window }
        WriteWindow (Path, TestWindow);      { Save the Window to file }

        IF (Window_Error = Success) THEN
        BEGIN
          NewLine;
          NewLine;
          FastWrite ('Window Saved!',12,0,2);
          FastWrite ('Now try NSamp15 to see your changes!',14,0,2);
          NewLine;
        END
        ELSE
        BEGIN
          NewLine;
          NewLine;
          FastWrite ('Error While Saving Window!',12,0,2);
          NewLine;
        END;
      END;
    END;
  END
  ELSE
  BEGIN
    NewLine;
    NewLine;
    FastWrite ('Not Enough Memory To Run BuildMap!',12,0,2);
    NewLine;
  END;
END.

