PROGRAM NSAMP15;    {Sample Program 15}
USES Crt, TPlus, TPWindow;

{The following program is the main pull down menu for the text editor
Word Genie.  It demonstrates the following:

   > How to create dynamic pull down menu's that can be taylored
     with Screen Genie in minutes.

   > How to use the Dynamic Menu Maker with Screen Genie.

   > How to load Screen Genie variable size windows into dynamic
     variables at run time allocating only the amount of memory needed
     to hold the window.

   > How to display and remove Screen Genie generated variable length
     windows.

   > That you can change the Pull Down menu's for this program with
     Screen Genie and the program will work with the new Menus without
     even re-compiling the program.

   > The features available with Word Genie from Nostradamus.


  NOTE:  THIS PROGRAM IS THE SAME AS NSAMP13, WITH ONE NOTABLE EXCEPTION.
         HERE, THE "STANDARD" WINDOW PUSH/POP ROUTINES ARE USED.  IN
         NSAMP13, THE "SR"  (PRE-ALLOCATED STACK SPACE) WINDOW PUSH
         AND POP ROUTINES ARE USED INSTEAD.  COMPARE THESE TWO PROGRAMS
         TO SEE THE DIFFERENCE BETWEEN USING PRE-ALLOCATED STORAGE AND
         STANDARD FOR WINDOW OPERATIONS.

}

VAR MainMenu : WindowPointer;              {Main Menu for Pull Downs}
    Pull1 : WindowPointer;                 {Pull Down Window 1}
    Pull2 : WindowPointer;                 {Pull Down Window 2}
    Pull3 : WindowPointer;                 {Pull Down Window 3}
    Pull4 : WindowPointer;                 {Pull Down Window 4}
    Pull5 : WindowPointer;                 {Pull Down Window 5}
    Pull6 : WindowPointer;                 {Pull Down Window 6}
    Pull7 : WindowPointer;                 {Pull Down Window 7}
    Pull8 : WindowPointer;                 {Pull Down Window 8}
    Pull9 : WindowPointer;                 {Pull Down Window 9}
    Disk : CHAR;
    CurrentPath : String65;
    WindPath : String65;
    Scan : BYTE;
    ASCIIChar : String1;
    Option : CHAR;
    Search : CHAR;
    MItem,MPosition,PItem,PPosition : INTEGER;
    MSaveArea : ARRAY [1..80] OF BYTE;
    PSaveArea : ARRAY [1..80] OF BYTE;
    PullFlag : BOOLEAN;
    SOption : ShowMode;


CONST MainName : STRING [12] = 'MAINMENU.WIN';
      P1Name   : STRING [11] = 'WGPULL1.WIN';
      P2Name   : STRING [11] = 'WGPULL2.WIN';
      P3Name   : STRING [11] = 'WGPULL3.WIN';
      P4Name   : STRING [11] = 'WGPULL4.WIN';
      P5Name   : STRING [11] = 'WGPULL5.WIN';
      P6Name   : STRING [11] = 'WGPULL6.WIN';
      P7Name   : STRING [11] = 'WGPULL7.WIN';
      P8Name   : STRING [11] = 'WGPULL8.WIN';
      P9Name   : STRING [11] = 'WGPULL9.WIN';
      Access   : INTEGER = 0;
      MLBracket : CHAR = '';         {Main Menu Brackets}
      MRBracket : CHAR = '';
      PLBracket : CHAR = '';         {Pull Down Menu Brackets}
      PRBracket : CHAR = '';
      MFg : INTEGER = white;
      MBg : INTEGER = red;
      PFg : INTEGER = black;
      PBg : INTEGER = lightgray;


{******************  PROCEDURES START HERE  ********************}
PROCEDURE Beep;

BEGIN
   SOUND (200);
   DELAY (200);
   NOSOUND;
END;


PROCEDURE LOADMENUS;
{Load Screen Genie generated pull down windows into dynamic heap}

BEGIN
   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,MainName);
   LoadWindow (WindPath,MainMenu);         {Load Main Menu}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P1Name);
   LoadWindow (WindPath,Pull1);           {load Pull Down Menu 1}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P2Name);
   LoadWindow (WindPath,Pull2);           {Menu 2}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P3Name);
   LoadWindow (WindPath,Pull3);           {Menu 3}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P4Name);
   LoadWindow (WindPath,Pull4);           {Menu 4}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P5Name);
   LoadWindow (WindPath,Pull5);           {Menu 5}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P6Name);
   LoadWindow (WindPath,Pull6);           {Menu 6}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P7Name);
   LoadWindow (WindPath,Pull7);           {Menu 7}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P8Name);
   LoadWindow (WindPath,Pull8);           {Menu 8}

   WindPath := CurrentPath;
   WindPath := CONCAT (WindPath,P9Name);
   LoadWindow (WindPath,Pull9);           {Menu 9}
END;


PROCEDURE SHOWPULL; {Display Selective Pulldowns}

BEGIN
   SOption  :=  Normal; { Normal }
   CASE MItem of
      1: PushShowWindow (SOption,Pull1);
      2: PushShowWindow (SOption,Pull2);
      3: PushShowWindow (SOption,Pull3);
      4: PushShowWindow (SOption,Pull4);
      5: PushShowWindow (SOption,Pull5);
      6: PushShowWindow (SOption,Pull6);
      7: PushShowWindow (SOption,Pull7);
      8: PushShowWindow (SOption,Pull8);
      9: PushShowWindow (SOption,Pull9);
   END; {END CASE}
END;



PROCEDURE MENUMAKERPULL(Option:CHAR);

BEGIN
   MenuMaker (Option,PFg,PBg,PLBracket,PRBracket,Search,PItem,
              PPosition,PSaveArea);
END;


PROCEDURE MENUMAKERMAIN(Option:CHAR);

BEGIN
   IF PullFlag THEN
      PopWindow (Normal);
   MenuMaker (Option,MFg,MBg,MLBracket,MRBracket,Search,MItem,
              MPosition,MSaveArea);
   IF PullFlag THEN
      BEGIN
         ShowPull;
         MenuMakerPull ('I');   {Initialize New Pull Down}
      END;
END;


PROCEDURE MAINSEARCH;
{This procedure directly selects a main menu item by highlighted CHARacter}
{using the MenuMaker direct Search Option}

BEGIN
   Search := UPCASE (ASCIIChar [1]);
   MenuMakerMain ('S');
END;


PROCEDURE PULLSEARCH;
{This procedure directly selects a pulled menu item by highlighted CHARacter}
{using the MenuMaker direct Search Option}

BEGIN
   Search := UPCASE (ASCIIChar [1]);
   MenuMakerPull ('S');
END;



{************************************************}
{****************  MAINLINE  ********************}
{************************************************}

BEGIN
   PullFlag := FALSE;
   Scan := 0;
   SetColorsn(lightgray,black);
   Clearscn;
   CursorOff;
   CurDisk(disk);               {Access files on current directory}
   CurrentPath := ' :';
   CurrentPath[1] := disk;
   {Initialize Screen Save Area
     SRSetStack (6000);         DONE IN NSAMP13, BUT NOT HERE!! }

   LoadMenus;  {load Main Menu and Pull Down Menu's into dynamic storage}
   SOption  :=  FadeIn;         { Fade in }
   ShowWindow (SOption, MainMenu);   {Display Main Menu}
   MenuMakerMain ('I');     {Activate with first pull down}

   WHILE Scan = Scan DO
      BEGIN
         ReadKb (Scan,ASCIIChar);
         IF Scan IN [ArrowRtKey,ArrowLfKey,ArrowUpKey,ArrowDnKey,
                     EscKey,EnterKey] THEN
            BEGIN
               IF Scan = ArrowRtKey THEN
                  MenuMakerMain('R');   {Move Main Menu Bar}
               IF Scan = ArrowLfKey THEN
                  MenuMakerMain('L');   {and pull down new menus}
               IF Scan = ArrowUpKey THEN
                  MenuMakerPull('U');   {Move pull down menu bar}
               IF Scan = ArrowDnKey THEN
                  MenuMakerPull('D');   {up and down}
               IF Scan = EscKey THEN
                  BEGIN
                     IF PullFlag = TRUE THEN          {Remove Pull Downs}
                        BEGIN
                           PopWindow (Normal);
                           PullFlag := FALSE;
                        END;
                  END;
               IF Scan = EnterKey THEN               {Activate Pull Downs}
                  BEGIN
                     IF PullFlag = FALSE THEN
                        BEGIN
                           ShowPull;
                           MenuMakerPull('I');   {Initialize New Pull Down}
                           PullFlag := TRUE;
                        END
                     ELSE
                        BEGIN
                           ClearScnHome;;
                           WRITELN('Item # ',PItem,' Of Main Menu Choice ',
                                   MItem,' Selected');
                           CursorOn;
                           HALT;
                        END;
                  END;
            END
         ELSE
            BEGIN           {check for direct Search by letter request}
               IF PullFlag = FALSE THEN
                  MainSearch
               ELSE
                  PullSearch;
            END;
     END;
END.

