PROGRAM NSAMP14;    { DYNAMIC MENU AND VISUAL EFFECTS EXAMPLE }

USES Crt, TPlus, TPWindow, NSamp14A;
{                             ^
  This  program  uses  a   screen  created with Screen Genie.  Using Screen
  Genie to build a Dynamic Menu is by far the easiest approach.  However,
  it is possible to use the Dynamic Menu Procedure on screens created
  with other methods, such as FastWrite. But for simplicity, we will use
  a Screen Genie Generated display, via a TGenie UNIT (NSAMP14A in USES
  statement, above).   }


VAR Scan : BYTE;
    ASCII : String1;
    Option : CHAR;
    Pick : String1;
    Fg, Bg, Item, Position : INTEGER;
    SaveArea : ARRAY [1..80] OF BYTE;
    Window : WindowPointer;
    OOption, COption : ShowMode;

CONST Enterkey   : INTEGER = 28;
      ArrowLfKey : INTEGER = 75;
      ArrowRtKey : INTEGER = 77;
      ArrowUpKey : INTEGER = 72;
      ArrowDnKey : INTEGER = 80;
      LBracket   : CHAR = '[';
      RBracket   : CHAR = ']';


PROCEDURE MenuSamp;

BEGIN
   Window := SampleWindow (1);
   ShowDelay := 0;  {Show delay controls the display speed of ShowWindow}
   PushShowWindow (OOption, Window); { Try Venetian, FadeIn or FadeOut,   }
END;                                 { Explode, CurtainOpen, CurtainClose,}
                                     { or Normal }

PROCEDURE Menu (Option : CHAR);

BEGIN
   MenuMaker (Option, Fg, Bg, LBracket, RBracket, ' ',
      Item, Position, SaveArea);
END;


{****************  Main Line ****************}

BEGIN
   CursorOff;
   SetColorsN(Yellow,Black);
   Clearscn;
   WRITELN;
   WRITELN ('This text will be overwritten by the selection window.');
   WRITELN;
   WRITELN ('Enter your window-open choice from the following:');
   WRITELN ('  F - Fade in      C - Curtain open      U - Curtain close');
   WRITELN ('  H - Horiz Blinds E - Exploding         N - Normal (Pop)');
   WRITELN ('  V - Vert  Blinds');
   REPEAT
      GOTOXY (1,7);
      ReadKb (Scan,Pick);
      Pick[1] := UPCASE (Pick[1]);
   UNTIL Pick[1] IN ['F','V','C','U','H','E','N'];
   CASE Pick[1] OF
      'F' : OOption := FadeIn;
      'C' : OOption := CurtainOpen;
      'U' : OOption := CurtainClose;
      'H' : OOption := HorizBlinds;
      'V' : OOption := VerticalBlinds;
      'E' : OOption := Exploding;
      'N' : OOption := Normal;
   END;  { CASE }
   WRITELN;
   WRITELN ('Now select a close-window choice from the same list:');
   REPEAT
      MoveCursor (1,10);
      ReadKb (Scan,Pick);
      Pick[1] := UPCASE (Pick[1]);
   UNTIL Pick[1] IN ['F','V','C','U','H','E','N'];
   CASE Pick[1] OF
      'F' : COption := FadeIn;
      'C' : COption := CurtainOpen;
      'U' : COption := CurtainClose;
      'H' : COption := HorizBlinds;
      'V' : COption := VerticalBlinds;
      'E' : COption := Exploding;
      'N' : COption := Normal;
   END;  { CASE }

   Scan := 0;
   Fg   := black;
   Bg   := lightgray;        { reverse video bar }
   MenuSamp;                 { display menu screen }

   WITH Window^ DO
      MenuPick (WSx, WSy, WEx, WEy, '[', ']', Item, Blue, LightGray, 9, 3);

   { An Item Has Been Selected }
   { Use Your Imagination From Here }
   { A Case Statement Would Be Nice }


   PopWindow (COption);
   WRITELN;
   WRITELN;
   WRITELN ('Menu Item ', Item, ' Was Selected.');
   cursoron;
END.
