PROGRAM NSAMP12;   {File Pointers}

USES Crt, TPlus;

TYPE IOArea = RECORD
                Message : string [20];
                number  : INTEGER;
              END;

{ The following is an include compiler directive telling the compiler }
{ to include the User-Declared Procedure Definitions for the Turbo-Plus }
{ file handling procedures. }

{The User-Declared procedure definitions for Writef, and Readf, }
{have an untyped i/o area.  These definitions can be used with }
{any type of field.}

VAR Error     : INTEGER;
    PathName  : String65;
    Attribute : INTEGER;
    Access    : INTEGER;
    Handle    : INTEGER;
    Samp1Rec  : IOArea;
    SampLen   : WORD;
    PointOpt  : INTEGER;
    RecNum    : INTEGER;
    I         : INTEGER;


PROCEDURE Wait;

BEGIN
   WRITELN;
   WRITELN;
   WRITELN ('Press a key when ready...');
   PauseKb;
   ClearScnHome;
END;


BEGIN
   SetColorsn(lightgray,black);
   ClearScnHome;
   WRITELN ('Welcome to the demostration of POINTF.  In this demonstration');
   WRITELN ('a file will be created (you get to pick the name) and have   ');
   WRITELN ('several RECORDs written to it.  Next the RECORDs will be READ');
   WRITELN ('in a nonsequential order.');
   WRITELN;

   WRITELN('What is the path name of the file you wish to create for this');
   WRITELN('test?');
   REPEAT
      READLN (PathName);
      Attribute := 0;              { Normal file.  }
      CreateF (PathName, Attribute, Handle, Error);
      IF Error <> 0 THEN
         BEGIN
            WRITELN ('Create file Error is ',Error);
            WRITELN ('Since that path did not work, try another file path.')
         END
      ELSE
         WRITELN ('File Created. Handle = ',Handle);
   UNTIL Error = 0;


   { Write 6 different RECORDs to the file.  Notice that each    }
   { RECORD will have a unique value in it which corresponds to  }
   { the RECORD number relative to zero.                         }
   WRITELN ('Six RECORDs are being written to your test file.  Each RECORD');
   WRITELN ('has a field which has the RECORD number relative to 0.  I.e. ');
   WRITELN ('the field in the first RECORD has a 0, the second RECORD has ');
   WRITELN ('a 1, etc..');
   Samp1Rec.Message := 'Sample1 record';
   SampLen := SIZEOF (Samp1Rec); {area size}
   FOR I := 0 TO 5 DO
      BEGIN
         Samp1Rec.number := i;
         WRITEF (Handle, Samp1Rec, SampLen, Error);
         IF Error <> 0 THEN
            WRITELN ('WRITEF file error ', Error);
      END;

   { The file will be closed now so it can be reopened with the  }
   { correct Access code.                                        }
   CloseF (Handle, Error);
   IF Error <> 0 THEN
     WRITELN ('CLOSEF file error is ',Error);

   { The file will be opened with the correct Access code.       }
   Access := 2;                          { Read write Access.    }
   OpenF (PathName, Access, Handle, Error);
   IF Error <> 0 THEN
      WRITELN ('OPENF file error is ', Error);

   WRITELN ('Your test file has just been closed and reopened.  A READF will');
   WRITELN ('be done to read the first record, the one with 0 in it.');
   Wait;
   ReadF (Handle, Samp1Rec, SampLen, Error);
   IF Error <> 0 THEN
      WRITELN ('READF file Error ',Error)
   ELSE
      WRITELN ('The record number is ',Samp1Rec.number,' .');
   WRITELN;

   WRITELN ('In this next test POINTF will be used so the fifth record');
   WRITELN ('can be read next.  Placement option 0 will be used with a');
   WRITELN ('RECORD count of 4.  That should reset the pointer to the');
   WRITELN ('start of the file then skip 4 records.  The record number');
   WRITELN ('should be 4.');
   Wait;
   PointOpt := 0;
   RecNum := 4;
   PointF (Handle, SampLen, RecNum, PointOpt, Error);
   IF Error <> 0 THEN
      WRITELN ('POINTF error is ',Error,' .');
   ReadF (Handle, Samp1Rec, SampLen, Error);
   IF Error <> 0 THEN
      WRITELN ('READF file error ',Error)
   ELSE
      WRITELN ('The record number is ',Samp1Rec.number,' .');
   WRITELN;

   WRITELN ('In this next test POINTF will be used so the fourth record');
   WRITELN ('can be read.  The record pointer is at the sixth record (a');
   WRITELN ('read automatically moves the pointer forward).  Placement');
   WRITELN ('option 1 will be used with a record count of -2.  That should');
   WRITELN ('leave the record pointer as is, then back up 2 records.  The');
   WRITELN ('record number should be 3.');
   Wait;
   PointOpt := 1;
   RecNum := -2;
   POINTF (Handle, SampLen, RecNum, PointOpt, Error);
   IF Error <> 0 THEN
      WRITELN ('POINTF error is ',Error,' .');
   ReadF (Handle, Samp1Rec, SampLen, Error);
   IF Error <> 0 THEN
      WRITELN ('READF file error ',Error)
   ELSE
      WRITELN ('The record number is ',Samp1Rec.number,' .');
   WRITELN;

   WRITELN ('In the next test, POINTF will be used so the fourth record');
   WRITELN ('can be read.  Placement option 2 will be used with a record');
   WRITELN ('count of -3.  That should set the pointer to the END of the');
   WRITELN ('file THEN back up 3 records.  The record number should be 3.');
   Wait;
   PointOpt := 2;
   RecNum := -3;
   PointF (Handle, SampLen, RecNum, PointOpt, Error);
   IF Error <> 0 THEN
      WRITELN ('POINTF error is ',Error,' .');
   ReadF (Handle, Samp1Rec, SampLen, Error);
   IF Error <> 0 THEN
      WRITELN ('READF file error ',Error)
   ELSE
      WRITELN ('The record number is ',Samp1Rec.number,' .');
   WRITELN;

   WRITELN ('This is the end of the demonstration.  Your test file will be');
   WRITELN ('closed, and then deleted.');
   CloseF (Handle, Error);
   IF Error <> 0 THEN
     WRITELN ('CLOSEF error ',Error);
   DeleteF (PathName, Error);
   IF Error <> 0 THEN
     WRITELN ('DELETEF error ',Error);
   WRITELN;
   WRITELN ('Notice how easy it is to move around within files of records.');
   WRITELN ('It is also easy to use variable-length records, for optimum');
   WRITELN ('file storage efficiency.  See Nsamp11 and the WRITEF procedure');
   WRITELN ('description for more information on this aspect of using DOS-');
   WRITELN ('style files.');
END.
