{$R-,S-,I+,D+,F-,V-,B-,N-,L+ }
{$M 16384,75000,75000 }
PROGRAM TurboPlusPackageDemo;

USES Crt, Dos, Graph, TPlus, TPWindow, tpgraph, demodriv, demofont, NSamp1A;

{  Nsamp1 is the main Nostradamus Turbo Plus 5.5 Demo. It contains
   routines and special effects that you might find useful. }

CONST Dly = 15;                   { Twirly delay }


TYPE Pos = RECORD
              Sx : INTEGER;
              Sy : INTEGER;
              Ex : INTEGER;
              Ey : INTEGER;
           END;
     FgBgArray = ARRAY [0..15] OF BYTE; { Used for special window recoloring }


VAR PullStart : WindowPointer;
    PullIntro : WindowPointer;
    PullWelcm : WindowPointer;
    BlinkGo   : WindowPointer;
    Pull1E    : WindowPointer;
    Pull1F    : WindowPointer;
    Pull1G    : WindowPointer;
    Pull1H    : WindowPointer;
    Pull1I    : WindowPointer;
    PullFeat1 : WindowPointer;
    PullFeat2 : WindowPointer;
    PullFeat3 : WindowPointer;
    PullFeat4 : WindowPointer;
    PullFeat5 : WindowPointer;
    PullFeat6 : WindowPointer;        { Screen Genie and TGenie info }
    PullFeat7 : WindowPointer;
    PullModes : WindowPointer;
    PullHow   : ARRAY [1..8] OF WindowPointer;
    Wins      : ARRAY [1..8] OF WindowPointer;
    Closing   : ARRAY [1..23] OF WindowPointer;
    FileShow  : ARRAY [1..26] OF WindowPointer;

    Position  : INTEGER;
    Ch        : CHAR;
    NewColors : MapArray;
    FgMap, BgMap : FgBgArray;

    I,J,K,L   : INTEGER;
    OldPos    : ARRAY [1..128] OF Pos;
    SOption   : ShowMode;
    Scan      : BYTE;
    ASCII     : String1;

    SaveExit : Pointer;

PROCEDURE WINDOWERROR;
begin
  clearscn;
  writeln('Windowing error ',window_error,' occurred');
  pausekb;
  halt;
end;



PROCEDURE PrepSomeWindows;

function getwindows(i:integer):windowpointer;
var
workwindow:windowpointer;

begin
  workwindow:=getwindow(i);
  getwindows:=workwindow;
end;


VAR I : INTEGER;

BEGIN
   PullStart := GetWindows (1);
   PullWelcm := GetWindows (2);
   PullIntro := GetWindows (3);
   BlinkGo   := GetWindows (4);
   Pull1E    := GetWindows (5);
   Pull1F    := GetWindows (6);
   Pull1G    := GetWindows (7);
   Pull1H    := GetWindows (8);
   Pull1I    := GetWindows (9);
   PullFeat1 := GetWindows (10);
   PullFeat2 := GetWindows (11);
   PullFeat3 := GetWindows (12);
   PullFeat4 := GetWindows (13);
   PullFeat5 := GetWindows (14);
   PullModes := GetWindows (15);   { nsamp1j }
   FOR I := 16 TO 23 DO
      PullHow [I - 15] := GetWindows (I);  { Push/pop windows }
   FOR I := 24 TO 31 DO
      Wins [I - 23] := GetWindows (I);     { Twirls }
   FOR I := 32 TO 54 DO
      Closing [I - 31] := GetWindows (I);  { Closing sequence }
   FOR I := 55 TO 80 DO
      FileShow [I - 54] := GetWindows (I); { File Handling Show }
   PullFeat6 := GetWindows (81);           { Screen Genie }
   PullFeat7 := GetWindows (82);           { TGenie }
END;


PROCEDURE MakeWindow (VAR Window : WindowPointer;
                      ULx, ULy, LRx, LRy : INTEGER);

{ "Snags" a defined area on the screen, and turns it into a Turbo Plus
  uncompressed window. The WindowPointer has it's space allocated HERE!
  No checking is done: it is the callers responsibility to assure that
  ULx, ULy are less than or equal to LRx, LRy, and that all are valid.
  There is also a MakeWindow in TPWINDOW, but we thought it might be
  interesting to see how to write your own. }

VAR Ww, Wh, Wb, Wpos : INTEGER;

BEGIN
   { Compute Window width, height, and # of bytes of actual data }
   Ww := (LRx - ULx + 1) * 2;   { 2 bytes, char and attribute, per cell }
   Wh := LRy - ULy + 1;
   Wb := Ww * Wh;
   TPGetMem (POINTER (Window), Wb + TPWHdr);  { Data plus header room }
   IF Window_Error = Success THEN
      BEGIN
         Wpos := 1;     { Prepare to snag data }
         FOR I := ULy TO LRy DO
            BEGIN
               FMoveScreen (Display^ [I, ULx, 1],
                            Window^.WindowStart [WPos], Ww);
               Wpos := Wpos + Ww;
            END;
         { Now fill in the header }
         Window^.WRes := 'W';   { Mark it as a window }
         Window^.WID := 'S';    { Mark it as uncompressed }
         Window^.CompLen := 0;  { Not compressed, so CompressedLen = 0 }
         Window^.WLen := Wb;    { Number of bytes of window data }
         Window^.WSx := ULx;    { Save window coordinates }
         Window^.WSy := ULy;
         Window^.WEx := LRx;
         Window^.WEy := LRy;
         Window^.TPULx := TPMinXw; { Save global current window coords }
         Window^.TPULy := TPMinYw;
         Window^.TPLRx := TPMaxXw;
         Window^.TPLRy := TPMaxYw;
      END
   ELSE
      BEGIN
         MoveCursorf (1,25);
         WRITE ('Unable to create window area');
         DELAY (1000);
         Movecursorf(1, 25);
         WRITE ('                            ');
      END;
END;

Procedure ContinuePrompt;
var
  Scan:byte;
  ascii:string1;

BEGIN
   MoveCursorF(1,24);
   FastWrite(' Press Any Key To Continue... ', White, Red, 1);
   ClearKb;
   Readkb(Scan,Ascii);
   If (scan = 46) and (byte(ascii[1]) = 3) then halt; {Make our own Ctrl-C}
END;

Procedure PauseExit;
var
  Scan:byte;
  ascii:string1;

BEGIN
   ClearKb;
   Readkb(Scan,Ascii);
   If (scan = 46) and (byte(ascii[1]) = 3) then halt; {Make our own Ctrl-C}
END;

{ There is a ColorMap procedure in TPWINDOW, but this is an example of how
  it is done.
}


PROCEDURE CMap (Window : WindowPointer;
                FgMap  : FgBgArray;
                BgMap  : FgBgArray);

CONST TransparentChar : BYTE = 176; { Dotted box character, magenta on brown }
      TransparentAttr : BYTE = 101; { See the Screen Genie chapter in manual }

VAR I     : INTEGER;
    Ww    : INTEGER;
    Wh    : INTEGER;
    Wb    : INTEGER;

BEGIN
   WITH Window^ DO
      IF WID = 'C' THEN           { Compressed window/screen; use short-cut }
         BEGIN
            { Find out where attributes start for compressed window }
            { Do it by determining INTEGER length of characters.  The }
            { attributes begin right after the characters. }
            I := ((WindowStart [2] SHL 8) OR (WindowStart [1])) + 1;
            REPEAT
               { Don't touch potential transparent areas }
               IF WindowStart [I] <> TransparentAttr THEN
                  WindowStart [I] := ((BgMap [(WindowStart[I]) SHR 4]) SHL 4)
                                       OR FgMap [(WindowStart[I]) AND $0F];
               I := I + 2;
            UNTIL I >= CompLen;
         END
      ELSE                        { Uncompressed window, use different check }
         BEGIN
            Ww := WEx - WSx + 1;
            Wh := WEy - WSy + 1;
            Wb := Ww * Wh * 2;
            I  := 2;              { Window Data starts at 1, attribs at 2 }
            REPEAT
               IF (WindowStart [I] = TransparentAttr) AND
                  (WindowStart [I - 1] = TransparentChar) THEN
                  BEGIN  END      { Do nothing, it is truly transparent }
               ELSE
                  WindowStart [I] := ((BgMap [(WindowStart[I]) SHR 4]) SHL 4)
                                       OR FgMap [(WindowStart[I]) AND $0F];
               I := I + 2;
            UNTIL I > Wb;
         END;
END;


{
  This programmer must be stupid because alot of these routines
  are pre-written and available in the Turbo Plus Units; and they
  have better error checking. Oh well. }

PROCEDURE Reposition (    Bg : INTEGER;
                      VAR LIndex : INTEGER;
                          NewX, NewY : INTEGER;
                      VAR Window : WindowPointer);

{ Save info about current position of window in Position array,
  Repositions window, and changes background color for introduction, etc. }

VAR I : INTEGER;

BEGIN
   FOR I := 0 TO 15 DO
      BEGIN
         FgMap [I] := I;               { Don't change foreground colors }
         BgMap [I] := Bg;              { but do change background }
      END;
   CMap (Window, FgMap, BgMap);
   WITH Window^ DO
      BEGIN
         OldPos [LIndex].Sx := WSx;
         OldPos [LIndex].Ex := WEx;
         OldPos [LIndex].Sy := WSy;
         OldPos [LIndex].Ey := WEy;
         LIndex := LIndex + 1;
      END;
   MoveWindow (Window, NewX, NewY);
   PushShowWindow (SOption, Window);
   Click;
END;


PROCEDURE TwirlyIntro;

VAR I, J : INTEGER;
    Mover : WindowPointer;


   PROCEDURE DoWindows;

   VAR I : INTEGER;

   BEGIN
      FOR I := 1 TO 8 DO
         BEGIN
            PushShowWindow (Normal, Wins [I]);
            DELAY (Dly);
            PopWindow (Normal);
         END;
   END;

BEGIN
   SetColorsN (White, Black);
   ClearScn;
   for I:=1 to 8 do MoveWindow(wins[I],33,6);
   FOR I := 1 TO 10 DO DoWindows;
   ShowWindow (Normal, Wins [1]);
   MoveCursor (55, 8);
   FastWrite ('PRESENTS', White, Black, 2);
   DELAY (250);
   DrawFrame (ThinLine, 52,5, 64, 9);
   MakeWindow (Mover, 52, 5, 64, 9);
   WINDOW (52, 5, 64, 9);
   ClearWindow;
   WINDOW (1, 1, 80, 25);
   PushShowWindow (Normal, Mover);
   FOR I := 52 DOWNTO 32 DO
      BEGIN
         PopWindow (Normal);
         MoveWindow (Mover, I, 5);      { Slide left... }
         PushShowWindow (Normal, Mover);
      END;
   FOR I := 5 TO 10 DO
      BEGIN
         PopWindow (Normal);
         MoveWindow (Mover, 32, I);     { ...and down into place }
         PushShowWindow (Normal, Mover);
      END;
   ShowWindow (Normal, Wins [1]);
   NoShowPopWindow;                     { Be sure we leave last copy on screen,
                                          but don't cause heap "leak". }
   I := 1;
   J := 25;
   REPEAT
      MoveCursor (33, 11);
      ChangeAtt (11, I, Black);
      MoveCursor (35, 13);
      ChangeAtt (8, I + 1, Black);
      I := I + 1;
      IF I >= 15 THEN
         I := 1;
      J := J + 1;
      IF J < 200 THEN
         DELAY (J);
   UNTIL (J = 50) OR
         (KeyStruck);
   FreeWindow (Mover);
   ClearKb;
   Delay(550);
   SetColorsn(White,Black);
   ClearScn;
END;


PROCEDURE BlitIntroduction;

   { Repaint the PullStart window and move it around the outside edge of the
     screen.  Then put up Turbo Pascal/Turbo Plus message windows.  Finally,
     remove the multiple PullStart windows, leaving the center section of
     the other windows behind.  Wait for a keypress to exit.  }

BEGIN
   ClearScnHome;
   J := 1;
   K := 1;
   L := 1;
   REPEAT
      Reposition (L MOD 8, L, K, J, PullStart);
      K := K + 8;
   UNTIL K > 64;

   REPEAT
      Reposition (L MOD 8, L, K, J, PullStart);
      J := J + 2;
   UNTIL J > 19;

   REPEAT
      Reposition (L MOD 8, L, K, J, PullStart);
      K := K - 8;
   UNTIL K < 1;

   REPEAT
      Reposition (L MOD 8, L, K, J, PullStart);
      J := J - 2;
   UNTIL J < 1;

   DELAY (2000);
   SOption := FadeIn;
   ShowWindow (SOption, PullWelcm);
   DELAY (1000);
   SOption := FadeOut;
   ShowWindow (SOption, PullWelcm);
   DELAY (1000);
   SOption := FadeIn;
   ShowWindow (SOption, PullIntro);
   DELAY (6000);
   SOption := VerticalBlinds;
   DELAY (2000);

   REPEAT
      PopWindow (SOption);
      Click;
      L := L - 1;
      WITH PullStart^ DO
         BEGIN
            WSx := OldPos [L].Sx;
            WEx := OldPos [L].Ex;
            WSy := OldPos [L].Sy;
            WEy := OldPos [L].Ey;
         END;
   UNTIL L = 1;
   Soption:=Normal;
   ShowWindow (SOption, PullIntro);
   ContinuePrompt;
END;


PROCEDURE SliderBox;

   { Put up 4 windows with information about Turbo Plus.  As they are being
     displayed, "slide" a red box between them.  After the last window is
     displayed, change the slider box and wait until a key is pressed before
     going on.  }

BEGIN
   Zoink;
   MoveCursorf(1,24);
   fastwrite('                              ',white,black,3);
   CVA(Lightgray,Black,ShadeColor);
   MoveCursorf(1,1);
   SOption := Exploding;
   ShowWindow (SOption, Pull1E);
   DELAY (4000);
   SOption := Normal;
   FOR I := 1 TO 35 DO
      BEGIN
         MoveWindow (Pull1I, I, 11);
         PushShowWindow (SOption, Pull1I);
         Click;
         PopWindow (SOption);
      END;
   ShowWindow (SOption, Pull1I);

   DELAY (4000);
   SOption := Normal;
   FOR I := 11 DOWNTO 1 DO
      BEGIN
         MoveWindow (Pull1I, 35, I);
         PushShowWindow (SOption, Pull1I);
         Click;
         PopWindow (SOption);
      END;
   FOR I := 2 TO 11 DO
      BEGIN
         MoveWindow (Pull1I, 35, I);
         PushShowWindow (SOption, Pull1I);
         Click;
         PopWindow (SOption);
      END;
   SOption := CurtainOpen;
   ShowWindow (SOption, Pull1F);
   ShowWindow (SOption, Pull1I);

   DELAY (4000);
   SOption := Normal;
   FOR I := 35 TO 68 DO
      BEGIN
         MoveWindow (Pull1I, I, 11);
         PushShowWindow (SOption, Pull1I);
         Click;
         PopWindow (SOption);
      END;
   FOR I := 68 DOWNTO 35 DO
      BEGIN
         MoveWindow (Pull1I, I, 11);
         PushShowWindow (SOption, Pull1I);
         Click;
         PopWindow (SOption);
      END;
   SOption := Exploding;
   ShowWindow (SOption, Pull1G);
   ShowWindow (SOption, Pull1I);

   DELAY (4000);
   SOption := Normal;
   FOR I := 11 TO 20 DO
      BEGIN
         MoveWindow (Pull1I, 35, I);
         PushShowWindow (SOption, Pull1I);
         Click;
         PopWindow (SOption);
      END;
   FOR I := 20 DOWNTO 11 DO
      BEGIN
         MoveWindow (Pull1I, 35, I);
         PushShowWindow (SOption, Pull1I);
         Click;
         PopWindow (SOption);
      END;
   SOption := FadeIn;
   ShowWindow (SOption, Pull1H);
   ShowWindow (SOption, Pull1I);

   DELAY (500);
   MoveCursor (35,12);
   WRITE ('Press any');
   MoveCursor (35,13);
   WRITE (' key to  ');
   MoveCursor (35,13);
   WRITE ('continue.');
   FOR I := 0 TO 255 DO       { Reset all color mappings }
      NewColors [I] := I;
   I := 1;
   J := 1;
   SOption := Normal;
   ClearKb;
   ColorMap (BlinkGo, NewColors);
   DELAY (50);
   ShowWindow (SOption, BlinkGo);
   PauseExit;
END;


PROCEDURE ShowFeaturesList;

   { Show the screens which contain a complete list of the routines that are
     available in Turbo Plus.  Wait for a keypress after each screen is
     displayed before showing the next one.  Then show the Screen Genie and
     Turbo Genie screens. }

BEGIN
   ShowWindow (CurtainOpen, PullFeat1);
   ClearKb;
   PauseExit;
   ShowWindow (Exploding, PullFeat2);
   ClearKb;
   PauseExit;
   ShowWindow (FadeIn, PullFeat3);
   ClearKb;
   PauseExit;
   ShowWindow (VerticalBlinds, PullFeat4);
   ClearKb;
   PauseExit;
   ShowWindow (CurtainClose, PullFeat5);
   ClearKb;
   PauseExit;
   ClearScn;
   MoveCursor (10, 12);
   FastString ('Don''t forget Screen Genie and Turbo Genie are Included!', 2);
   NewLine;
   FastString ('      Here are two screens we "snagged" from those programs.  Please', 2);
   FastString ('      press a key after you have examined each of them, to go on....', 2);
   ContinuePrompt;
   ShowWindow (HorizBlinds, PullFeat6);
   ContinuePrompt;
   ShowWindow (Normal, PullFeat7);
   ContinuePrompt;
END;


{ Make and describe  some of the Turbo Plus Sound }
PROCEDURE QuickSounds;

BEGIN
   SetColorsN (White, Black);
   Clearscn;
   MoveCursor (25,9);
   WRITE ('TURBO PLUS also has SOUNDS!!');
   DELAY (1000);
   MoveCursor (30,12);
   WRITE ('Like a doorbuzzer...');
   DoorBuzzer;
   MoveCursor (34,14);
   WRITE ('a Phaser...');
   FOR I := 1 TO 4 DO
      Phaser;
   DELAY (500);
   MoveCursor (29,16);
   WRITE ('a ringing telephone...');
   PhoneRing;
   MoveCursor (31,18);
   WRITE ('Photon torpedoes...');
   FOR I := 1 TO 3 DO
      PhotonTorpedo;
   MoveCursor (30,24);
   ReverseOn;
   WRITE ('AND OVER 20 OTHERS!');
   ReverseOff;
   FOR I := 1 TO 60 DO
   BEGIN
     ElectronicSounds;
   END;
END;


PROCEDURE WindowPushAndPops;

   { Show the various window storage modes for pushing and popping windows,
     and actually demonstrate the Standard and SR routines (but not the EL
     routines, since we do not want to have to includes ".WIN" load files
     with the distributed demo.  }

VAR I : INTEGER;

BEGIN
   ClearScnHome;
   ShowWindow (Exploding, PullModes);
   PauseExit;
   ClearScnHome;

   FOR I := 1 TO 8 DO
      BEGIN
         PushShowWindow (Normal, PullHow [I]);
         DELAY (2000);
      END;
   DELAY (5000);
   FOR I := 1 TO 8 DO
      BEGIN
         DELAY (1000);
         PopWindow (FadeOut);
      END;
END;


{ Show how Screen Genie windows can be displayed in Bit Mapped Graphics modes. }

Procedure GraphDemo;

function myrandom(i : longint) : word;
begin
  if i <= 0 then
    myrandom := 0
  else
    myrandom := system.random(i);
end;

var
  Graphdriver, Graphmode : integer;
  f_goth:integer;
  MaxX, MaxY : word;
  MaxColors : word;
  nostsize : integer;
  Err : integer;

procedure PutPixelPlay;
var
  Ch : char;
  i : integer;
begin
  for i:=1 to 10000 do
    PutPixel(MyRandom(MaxX), MyRandom(MaxY), MyRandom(MaxColors));
end;

begin
  case active_video of
  1,3:
  begin
    graphdriver:=cga;
    graphmode:=cgac1;
  end;
  5:
  begin
    graphdriver:=ega;
    graphmode:=egahi;
  end;
  6:
  begin
    graphdriver:=vga;
    graphmode:=vgahi;
  end;
  else
    begin
      clearscn;
      showdelay:=0;
      showwindow(fadein,getwindow(121));
      PauseExit;
      exit;
    end;
  end;  {end case}
  if RegisterBGIdriver(@EGAVGADriverProc) < 0 then
  begin
    exit;
  end;
  if RegisterBGIdriver(@CGADriverProc) < 0 then
  begin
    exit;
  end;
  f_goth:=RegisterBGIfont(@GothicFontProc);
  InitGraph(Graphdriver, graphmode, '');
  Err := GraphResult;
  if Err <> grOk then exit;
  SetColor(1);
  SetBkColor(0);
  MaxX := GetMaxX;
  MaxY := GetMaxY;
  Randomize;
  if active_video = 1 then nostsize:=4 else nostsize:=7;
  SetTextStyle(4, HorizDir, nostsize);
  cleardevice;
  setcolor(10);
  moveto((maxx div 4),20);
  outtext('Nostradamus');
  PutPixelPlay;
  if active_video = 1 then
  GraphShowWindow(CurtainOpen,getwindow(122)) else
  GraphShowWindow(CurtainOpen,getwindow(121));
  clearkb;
  PauseKb;
  CloseGraph;
  Cursoroff;
end;


{ Demonstrate how Map fields will work relative to any window }

PROCEDURE MovingIOFields;

VAR sx,sy,ex,ey:integer;
    cursorpos,rcode,Current_Field:integer;
    Option:char;
    fld1:string80;
    fld2,fld3:real;
    i,n:integer;
    total_fields:integer;
    x1,y1,x2,y2:integer;
    actfg,actbg:integer;

BEGIN
   SetColorsN(white,black);
   ShowWindow(Exploding,getwindow(83));
   if stype='C' then
   begin
     actfg:=white;
     actbg:=red;
   end else
   begin
     actfg:=black;
     actbg:=lightgray;
   end;
   for i:=1 to 3 do
   begin
      sx:=10*i;
      sy:=5*i;
      ex:=sx+24;
      ey:=sy+6;
      DrawFrame(DoubleLine,sx,sy,ex,ey);
      WINDOW (sx, sy, ex, ey);
      Total_fields := 3;
      Current_Field := 1;
      Rcode := 0;
      Option := 'W';
      Fld1 := 'Turbo Plus 5.5';
      fld2 := 149.95;
      fld3 := 44.30;
      if istartline = startscanoff then
      CursorNormal else cursoron;    {use original cursor unless original off}
      REPEAT
         CursorPos := 1;
         MoveCursorF(1,25);
         If Option = 'C' then
            BEGIN
               if Current_Field = 1 then
                  write('             ')
               else
                  write('Numerics Only');
            END;
         CASE Current_Field of
            1:   Mapstring(Option,3,Current_Field+1,25,14,0,actfg,actbg,RCode,CursorPos,fld1,
                    '#####################');
      2 : begin
            if option <> 'W' then option := 'C';
            MapReal (Option,3,Current_Field+2,25,14,0,actfg,actbg,Rcode,CursorPos,fld2,
                      '$######.##');
          end;
      3 :  Begin
            if option <> 'W' then option := 'R';
             MapReal (Option,3,Current_Field+3,25,14,0,actfg,actbg,Rcode,CursorPos,fld3,
                    '#######.####');
           end;
    END; { END of CASE }

    IF Option = 'W' THEN
      BEGIN                          { WRITING FIELDS }
        IF Current_Field < Total_Fields THEN
           Current_Field := Current_Field + 1
        ELSE
        BEGIN
          Option := 'C';        { FIELDS DISPLAYED, SO SWITCH TO READ }
          Current_Field := 1;
        END;
      END
      ELSE
      BEGIN                          { READING FIELDS }
        { FORWARD FIELD }
        IF (RCode = arrowdnkey) OR (RCode = tabkey) THEN
        BEGIN
          IF Current_Field = Total_Fields THEN
          Current_Field := 1
          ELSE
          Current_Field := Current_Field + 1;
        END;

        { BACKWARD FIELD }
        IF (RCode = arrowupkey) OR (RCode = shifttabkey) THEN
        BEGIN
          IF Current_Field = 1 THEN
          Current_Field := Total_Fields
          ELSE
          Current_Field := Current_Field - 1;
        END;
      END;                         { END READS BLOCK }

    UNTIL (Rcode = esckey) or (Rcode = EnterKey);
    zoink;
    ClearWindow;
    CursorOff;
  end;

  WINDOW (1, 1, 80, 25);
  SetColorsN (White, Black);
  ClearScnHome;
  N:=1;
  FOR X1 := 7 TO 14 DO
     BEGIN
        N := N + 2;
        ElectronicSounds;
        SetColorsN (White, X1); { Turbo's TextColor and TextBackground drop
                                  blinks and brights; SetColorsN does not }
        X2 := X1 + 20 + N;
        Y1 := X1 - 5;
        Y2 := Y1 + 12;
        WINDOW (1, 1, 80, 25);
        CursorOff;
        DrawFrame (ThinLine, X1-1, Y1-1, X2+1, Y2+1);
        WINDOW (X1, Y1, X2, Y2);
        FOR I := 1 TO 30 DO
           FastWrite (' Turbo Plus ', White, X1, 1);
     END;
  Cva (White, 9, TextAttr);     { Bright Blue }
  NewLine;
  NewLine;
  FOR I := 1 TO 13 DO
     FastWrite('       Turbo Plus Version 5.5 ',white,9,2);
  NewLine;
  MoveCursor (WhereX+4, WhereY);
  FastWrite(' Press Any Key To Continue... ', White, Red, 2);
  Bright;
  PhotonTorpedo;
  ClearKb;
  PauseExit;
  WINDOW (1, 1, 80, 25);
  SetColorsN (White, Black);
  ClearScnHome;
END;


{ Show some of the File Handling procedures available }

PROCEDURE DemoFileHandling;

VAR SaveX1, SaveY1 : INTEGER;
    I : INTEGER;
    Timer : INTEGER;
BEGIN
   ClearScnHome;
   ShowWindow (Exploding, FileShow [1]);
   DELAY (1000);
   ShowDelay := 10;
   FOR I := 2 TO 26 DO
      WITH FileShow [I]^ DO
         BEGIN
            SaveX1 := WSx;
            SaveY1 := WSy;
            MoveWindow (FileShow [I], 33, 10);
            PushShowWindow (Normal, FileShow [I]);
            MoveWindow (FileShow [I], SaveX1, SaveY1);
            delay(300);
            PopWindow (CurtainClose);
            ShowWindow (CurtainOpen, FileShow [I]);
            DELAY (200);
       END;
   ContinuePrompt;
END;

{ Demonstrate more sounds with the use of a UniversalMenu }

PROCEDURE DemoSounds;

TYPE String14 = STRING [14];

CONST Choices : ARRAY [1..26] OF String14 = (
        '   Bats #1    ', '    Birds     ', '    Clock     ',
        ' Machinery #1 ', '   Crickets   ', '   Doorbell   ',
        '  Explosion   ', ' Generator #1 ', ' Machinery #2 ',
        '    Phaser    ', '  Ring phone  ', '  Busy phone  ',
        'Photon Torpedo', 'Random Sounds ', 'Invader Saucer',
        '   Siren #1   ', ' Leaky faucet ', 'Train passing ',
        '   Siren #2   ', '   Thinking   ', '   Bats #2    ',
        ' Machinery 3  ', '    Click     ', '    Zoink     ',
        ' Wolf whistle ', '    EXIT      ');

VAR Ch : CHAR;
    Item : INTEGER;
    I : INTEGER;

BEGIN
   ClearScnHome;
   SetColorsN (LightCyan, Black);
   MoveCursor (1,23);
   FastString ('           Use arrow keys to move select bar, RETURN to hear sound,', 2);
   FastString ('         and move to the "EXIT" heading, followed by RETURN, to exit.', 2);
   Item:=1;
   REPEAT
      UniversalMenu (ThinLine, 12, 6, White, green, black, lightgray,
                     Yellow, Blue, Choices [1] [1], 15, 26, 3, 14, 25,
                     'TURBO PLUS Sounds', Item);
      UniversalRedraw:=False;
      CASE Item OF
         1 : Screeches;
         2 : FOR I := 1 TO 3 DO
                Birds;
         3 : FOR I := 1 TO 3 DO
                ClockSound;
         4 : Machinery1;
         5 : FOR I := 1 TO 3 DO
                Chirps;
         6 : Doorbuzzer;
         7 : CrashAndBurn;
         8 : Generator1;
         9 : Machinery3;
         10 : FOR I := 1 TO 3 DO
                 Phaser;
         11 : PhoneRing;
         12 : DialBusyPhone;
         13 : FOR I := 1 TO 3 DO
                 PhotonTorpedo;
         14 : RandomSounds;
         15 : FOR I := 1 TO 3 DO
                 InvadersSaucer;
         16 : Siren1;
         17 : FOR I := 1 TO 4 DO
                 DrippingSpigot;
         18 : Train;
         19 : Siren2;
         20 : FOR I := 1 TO 30 DO
                 BEGIN
                    ElectronicSounds;
                 END;
         21 : Screeches2;
         22 : Machinery3;
         23 : Click;
         24 : Zoink;
         25 : WolfWhistle;
      END;   { CASE }
      NOSOUND;   { Be sure sound is off }
   UNTIL Item >= 26;
END;

{ Demonstrate the use of BuildMap for letting the user change colors }

PROCEDURE OtherWindowFeatures;

VAR FMap, BMap : MapArray;
    Changed : BOOLEAN;

BEGIN
   ClearScnHome;
   SetColorsN (LightGreen, Black);
   NewLine;
   FastString ('Would you like your users to change window colors or positions in your', 2);
   FastString ('programs?', 2);
   NewLine;
   FastString ('Just ONE Turbo Plus instruction can do this...', 2);
   ContinuePrompt;
   window_error:=0;
   BuildMap(PullIntro, FMap, Changed);
   if window_error <> 0 then WindowError;
   ColorMap(PullINtro, FMap);
   if window_error <> 0 then WindowError;
   ClearScnHome;
   SetColorsN (LightCyan, Black);
   NewLine;
   FastString ('You can also move windows, dynamically.  Use the Arrow Keys.', 2);
   FastString ('Then Press Enter To Continue With Demo.',1);
   ShowDelay:=0;
   PositionWindow (PullIntro, Changed);
   SetColorsN (LightGray, Black);
   ClearScnHome;
END;


{ Give a brief description of Sequential Files Libraries }

Procedure SflDemo;
var
  i:integer;
begin
  showdelay:=0;
  ShowWindow(curtainopen, getwindow(101));
  delay(500);
  movecursorf(12,13);
  Fastwrite('THIS...',white,black,3);
  showdelay:=5;
  Machinery3;
  for i:=1 to 8 do ShowWindow(fadein, getwindow(101+i));
  movecursorf(38,13);
  Fastwrite('BECOMES THIS',white,black,3);
  Zoink;
  ShowWindow(exploding, getwindow(110));
  delay(300);
  ShowWindow(horizblinds, getwindow(111));
  PauseExit;
end;

{ End the Demo with an array of feature windows }

PROCEDURE CloseOut;

VAR I : INTEGER;

BEGIN
   ClearScnHome;
   FOR I := 1 TO 23 DO
      BEGIN
         PushShowWindow (Normal, Closing [I]);
         DELAY (750);
      END;
   PauseExit;
   FOR I := 1 TO 23 DO
      BEGIN
         PopWindow (Exploding);
         Click;
      END;
   Zoink;
END;


{$F+}
Procedure MyExit;
begin
  ExitProc:=SaveExit;
  ClearKb;
  SetColorsN(lightgray,black);
  ClearScn;
  showdelay:=10;
  ShowWindow(Fadein,getwindow(84));
  CursorOn;
end;
{$F-}


BEGIN     { MAIN }
   SaveExit:=exitproc;
   Exitproc:=@MyExit;
   MonoShowFlag:=True;
   SetCBreak(True);
   CursorOff;
   SOption := Normal;
   TEXTCOLOR (White);
   TEXTBACKGROUND (Black);
   PrepSomeWindows;
   if window_error <> 0 then exit;
   ClearScn;


   TwirlyIntro;                    { Put up twirling "Nostradamus" }

   BlitIntroduction;               { Put up "blitted" boxes and start msg }

   SliderBox;                      { Slide a red box around between windows }

   ShowFeaturesList;               { Display the screens that show features }

   QuickSounds;                    { Give brief intro to sounds; more later }

   WindowPushAndPops;              { Show how windows push and pop; modes }

   GraphDemo;                      { Show Screen Genie window in graphics mode }

   MovingIOFields;                 { Show how windows with I/O fields move }

   DemoFileHandling;               { Show the many file handling routines }

   DemoSounds;                     { Give full intro to sounds, with UnivMenu }

   SflDemo;                        { Feature SFL facility }

   OtherWindowFeatures;            { Tell about color mapping, moving, etc. }

   CloseOut;                       { Features pop-up, and thanks for watching }

   ClearScnHome;
   CursorOn;
END.

