;******************************************************
;		   TPCASE.ASM 4.03
;	       String handling routines
;	 Copyright (c) TurboPower Software 1987.
; Portions copyright (c) Sunny Hill Software 1985, 1986
;     and used under license to TurboPower Software
;		 All rights reserved.
;******************************************************

	INCLUDE TPCOMMON.INC

;****************************************************** Data

DATA	SEGMENT WORD PUBLIC

DATA	ENDS

;****************************************************** Code

CODE	SEGMENT BYTE PUBLIC

	ASSUME	CS:CODE,DS:DATA

	PUBLIC	StUpcase, StLocase

;****************************************************** StUpcase

;function StUpcase(S : string) : string;
;Convert lower case letters in string to upper case.

StUpcase	PROC FAR

	StackFrame				;set up stack frame
	CLD					;go forward
	MOV	DX,DS				;Save DS in DX
	LDS	SI,SS:[BX+4]			;DS:SI => S
	LES	DI,SS:[BX+8]			;ES:DI => function result
	LODSB					;AL = Length(S)
	STOSB					;Set length of result
	SetZero CH				;CH = 0
	MOV	CL,AL				;CX = Length(S)
	JCXZ	SUDone				;Done if CX is 0
	MOV	BX,7A61h			;BL = 'a', BH = 'z'
SUNext:
	LODSB					;Next char into AL
	CMP	AL,BL				;AL < 'a'?
	JB	SUNotLow			;If so, don't change
	CMP	AL,BH				;AH > 'z'?
	JA	SUNotLow			;If so, don't change
	SUB	AL,32				;Convert to upper case
SUNotLow:
	STOSB					;Store char in result
	LOOP	SUNext				;repeat
SUDone:
	MOV	DS,DX				;Restore DS
	RET	4				;remove parameter and return

StUpcase	ENDP

;****************************************************** StLocase

;function StLocase(S : string) : string;
;Convert upper case letters in string to lower case

StLocase	PROC FAR

	StackFrame				;set up stack frame
	CLD					;go forward
	MOV	DX,DS				;Save DS in DX
	LDS	SI,SS:[BX+4]			;DS:SI => S
	LES	DI,SS:[BX+8]			;ES:DI => function result
	LODSB					;AL = Length(S)
	STOSB					;Set length of result
	SetZero CH				;CH = 0
	MOV	CL,AL				;CX = Length(S)
	JCXZ	SLDone				;Done if CX is 0
	MOV	BX,5A41h			;BL = 'A', BH = 'Z'
SLNext:
	LODSB					;Next char into AL
	CMP	AL,BL				;AL < 'A'?
	JB	SLNotUp 			;If so, don't change
	CMP	AL,BH				;AH > 'Z'?
	JA	SLNotUp 			;If so, don't change
	ADD	AL,32				;Convert to lower case
SLNotUp:
	STOSB					;Store char in result
	LOOP	SLNext				;repeat
SLDone:
	MOV	DS,DX				;Restore DS
	RET	4				;remove parameter and return

StLocase	ENDP


CODE	ENDS

	END
