unit TamUtil;

interface

uses  TPCrt,
      DOS,
      Tpstring,
      TPedit,
      Taccess,
      TamTypes,
      TamMsg,
      TamFrm,
      Unit_win;


function ValidRecord(var Customer : CustRec) : boolean;
procedure RebuildIndex1(VAR CustFile: DataFile;
                        VAR CodeIndex: IndexFile;
                            FileNm:FileName);

procedure RebuildIndex2(VAR CustFile: DataFile;
                       VAR NameIndx: IndexFile;
                       FileNm:FileName);

procedure CreateFiles(var CustFile:DataFile;
                          Fname:FileName;
                          size:integer);
procedure InputParams;
procedure Pack_lianiki;
procedure BackupFiles;
procedure RestoreFiles;
procedure CreateIndexFiles;
procedure RebuildIndexFiles;

procedure Get_tam_params;
procedure Write_tam_params;



implementation

function ValidRecord(var Customer : CustRec) : boolean;
begin
  ValidRecord := (Customer.CustStatus = 0);
end;

procedure RebuildIndex1(VAR CustFile: DataFile;
                        VAR CodeIndex: IndexFile;
                            FileNm : FileName);

var
  RecordNumber : LongInt;
begin
  MakeIndex(CodeIndx,FileNm,
            SizeOf(Customer.CodeK)-1,0);
  if not Ok then
    Abort('Could not Rebuild index file ' + FileNm);
  for RecordNumber := 1 to FileLen(CustFile) - 1 do
  begin
    GetRec(CustFile,RecordNumber,Customer);
    If ValidRecord(Customer)then
      AddKey(CodeIndx,RecordNumber,Customer.CodeK);
  end
end; { RebuildIndex }

procedure RebuildIndex2(VAR CustFile: DataFile;
                       VAR NameIndx: IndexFile;
                       FileNm : FileName);
var
  RecordNumber : LongInt;
begin
  MakeIndex(NameIndx,FileNm,
            SizeOf(Customer.Perigrafi)-1,1);
  if not Ok then
    Abort('Could not Rebuild index file ' + FileNm);
  for RecordNumber := 1 to FileLen(CustFile) - 1 do
  begin
    GetRec(CustFile,RecordNumber,Customer);
    If ValidRecord(Customer)then
      AddKey(NameIndx,RecordNumber,Customer.Perigrafi);
  end
end; { RebuildIndex2 }



procedure CreateFiles(var CustFile:DataFile;
                          Fname:FileName;
                          Size:integer);
begin
  Message(' , ⤜....',0);
  ClearMessage;
  Message(' 妬 FLAPO.DAT .......',0);
  MakeFile(CustFile,fname,107);
    if not Ok then
  Abort('  '  + Fname + '    . ');
  FastWrite('OK',24,38,$70);
  delay(1000);
  ClearMessage;
    Message(' 妬 FLTAMK.DAT .......',0);
    assign(TamFile,TamFileNm);
    Rewrite(TamFile);
    if not Ok then
  Abort('  '  + Fname + '    . ');
  FastWrite('OK',24,38,$70);
  delay(1000);
    ClearMessage;
    Message(' 妬 FLPART.DAT .......',0);
    assign(ParamFile,ParamFileNm);
    Rewrite(ParamFile);
    if not Ok then Abort('  '  + Fname + '    . ');
    with Param do begin

      {Standard  ⫨}

       Etair1:='';
       Etair2:='';
       Etair3:='';
       Etair4:='' ;
       Etair5:='';
       SN:='';
       FPA[1]:=8;
       FPA[2]:=18;
       FPA[3]:=36;
       FPA[4]:=4;
       FPA[5]:=0;

       { }

       par[1]:='  ';
       par[2]:=' ';

       {夘  }

       mon[1]:='';
       mon[2]:='';
       mon[3]:='';
       mon[4]:='';
       mon[5]:='';
       last_apo:=0;

       seek(ParamFile,1);
       write(ParamFile,Param);
     end;
    FastWrite('OK',24,38,$70);
    Message(' 妬 FLFPAC.DAT .......',0);
    assign(FpaFile,FpaFileNm);
    Rewrite(FpaFile);
    if not Ok then Abort('  '  + Fname + '    . ');
    with FpaCount do begin

      {Standard  ⫨}

       Ka1:=0;
       Ka2:=0;
       Ka3:=0;
       Ka4:=0;
       Ka5:=0;
       Fpa1:=0;
       Fpa2:=0;
       Fpa3:=0;
       Fpa4:=0;
       Fpa5:=0;
       seek(FpaFile,1);
       write(FpaFile,FpaCount);
     end;
    FastWrite('OK',24,38,$70);

  CreateIndexFiles;

end;

procedure InputParams;

begin

   Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
   done_win:=__DispWin(Form_win);
   draw_param_form;
   get_tam_params;

with Param do begin

  FastWrite(Etair1,5,5,$07);
  FastWrite(Etair2,6,5,$07);
  FastWrite(Etair3,7,5,$07);
  FastWrite(Etair4,8,5,$07);
  FastWrite(Etair5,9,5,$07);

  FastWrite(long2str(Fpa[1]),12,9,$07);
  FastWrite(long2str(Fpa[2]),13,9,$07);
  FastWrite(long2str(Fpa[3]),14,9,$07);
  FastWrite(long2str(Fpa[4]),15,9,$07);
  FastWrite(long2str(Fpa[5]),16,9,$07);

  FastWrite(Mon[1],12,44,$07);
  FastWrite(Mon[2],13,44,$07);
  FastWrite(Mon[3],14,44,$07);
  FastWrite(Mon[4],15,44,$07);
  FastWrite(Mon[5],16,44,$07);

  FastWrite(Par[1],5,44,$07);
  FastWrite(Par[2],6,44,$07);
  FastWrite(long2str(last_apo),7,60,$07);

  ReadString('',5,5,30,$07,$07,$07,esc,UpArr,DownArr,F10,Etair1);
  FastWrite(pad(Etair1,30),1,1,$70);
  ReadString('',6,5,30,$07,$07,$07,esc,UpArr,DownArr,F10,Etair2);
  ReadString('',7,5,30,$07,$07,$07,esc,UpArr,DownArr,F10,Etair3);
  ReadString('',8,5,30,$07,$07,$07,esc,UpArr,DownArr,F10,Etair4);
  ReadString('',9,5,30,$07,$07,$07,esc,UpArr,DownArr,F10,Etair5);

  ReadInteger('',12,9,2,$07,$07,0,36,esc,UpArr,DownArr,F10,FPA[1]);
  ReadInteger('',13,9,2,$07,$07,0,36,esc,UpArr,DownArr,F10,FPA[2]);
  ReadInteger('',14,9,2,$07,$07,0,36,esc,UpArr,DownArr,F10,FPA[3]);
  ReadInteger('',15,9,2,$07,$07,0,36,esc,UpArr,DownArr,F10,FPA[4]);
  ReadInteger('',16,9,2,$07,$07,0,36,esc,UpArr,DownArr,F10,FPA[5]);

  ReadString('',5,44,30,$07,$07,$07,esc,UpArr,DownArr,F10,Par[1]);
  ReadString('',6,44,30,$07,$07,$07,esc,UpArr,DownArr,F10,Par[2]);

  ReadLongInt('',7,60,8,$07,$07,0,99999999,esc,UpArr,DownArr,F10,last_apo);

  ReadString('',12,44,3,$07,$07,$07,esc,UpArr,DownArr,F10,Mon[1]);
  ReadString('',13,44,3,$07,$07,$07,esc,UpArr,DownArr,F10,Mon[2]);
  ReadString('',14,44,3,$07,$07,$07,esc,UpArr,DownArr,F10,Mon[3]);
  ReadString('',15,44,3,$07,$07,$07,esc,UpArr,DownArr,F10,Mon[4]);
  ReadString('',16,44,3,$07,$07,$07,esc,UpArr,DownArr,F10,Mon[5]);

   write_tam_params;
   done_win:=__RemWin;
end;

end;

procedure Pack_lianiki;
begin
end;

procedure BackupFiles;
var exitRoutine:Pointer;
    errorCode:Integer;
begin
{ exitRoutine:=nil;
 stemp:=''; ReadString('B᢫  ⫫  drive A: ,<enter>/<esc>..',24,1,1,$70,$70,$70,esc,UpArr,DownArr,F10,stemp);
 if esc then begin clearmessage;exit;end;
 message('  ,  ⤜ ....',0);
 errorCode:=ExecDos('copy *.dat a:>nul',True,exitRoutine);
 if errorCode<>0 then begin
    beep;
    message('ᢣ '+long2str(errorCode)+'   碘',1000);
 end;
 if errorCode=0 then begin
    beep;
    clearmessage;
    message('   ..',1000);
    clearmessage;
 end;}
end;

procedure RestoreFiles;
var exitRoutine:Pointer;
    errorCode:Integer;

begin
{  exitRoutine:=nil;
  stemp:=''; ReadString('B᢫  ⫫  drive A: ,<enter>/<esc>..',24,1,1,$70,$70,$70,esc,UpArr,DownArr,F10,stemp);
   if esc then begin clearmessage;exit;end;
   message('  ,  ⤜ ....',0);
   errorCode:=ExecDos('copy a:*.dat>nul ',True,exitRoutine);
  if errorCode<>0 then begin
    beep;
    message('ᢣ '+long2str(errorCode)+'  樫ਫ਼',1000);
 end;
 if errorCode=0 then begin
    beep;
    clearmessage;
    message('   ..',1000);
    clearmessage
 end;}
end;

procedure CreateIndexFiles;

begin
     Message('  INDEX , ⤜....',0);
     ClearMessage;
     Message(' 妬 FLCODX.DAT .......',0);
     RebuildIndex1(CustFile,CodeIndx, BaseIndexNm);
     FastWrite('OK',24,37,$70);
     delay(1000);
     ClearMessage;
     Message(' 妬 FLPERX.DAT .......',0);
     RebuildIndex2(CustFile,NameIndx,NameIndexNm);
     FastWrite('OK',24,37,$70);
     delay(1000);
     ClearMessage;
end;

procedure RebuildIndexFiles;

begin
     RebuildIndex1(CustFile,CodeIndx, BaseIndexNm);
     RebuildIndex2(CustFile,NameIndx, NameIndexNm);
end;

procedure get_tam_params;
var par_rec:longInt;
begin
     Assign(ParamFile,ParamFileNm);
     Reset(ParamFile);
     seek(ParamFile,1);
     read(ParamFile,Param);
     Close(paramFile);
end;

procedure write_tam_params;
var par_rec:longInt;
begin
     Assign(ParamFile,ParamFileNm);
     Reset(paramFile);
     seek(ParamFile,1);
     write(ParamFile,Param);
     Close(paramFile);
end;



begin {TamUtil}
end.