unit Tamsys;

interface

uses Dos,TpCrt,TpEdit,TPString,TamMsg,TamTypes,Unit_sup,Unit_fil;

type SysRecType=record
        NumberOfUses:integer;
        InstallDay:word;
        InstallMonth:word;
        InstallYear:word;
        CodeAsf:array[1..10] of integer;
        BiosDateID:string[8];
     end;

const SysFileNm='FLTAML.DAT';

var   SysFile:File of SysRecType;
      SysRec:SysRecType;
      Year,Month,Day,Week:word;
      ok:boolean;
      Code:string;
      test:integer;
      BiosDate:string[8];

procedure OpenSysFile;
procedure CloseSysFile;
procedure UpdateUses;
procedure GetSysParams;
procedure CheckSysParams;
procedure Trap;
procedure CompareCodes;
procedure InitUses;
procedure Get_ROM_date;


implementation

procedure Beep;
begin
  Sound(800);
  Delay(200);
  NoSound;
end; { Beep }

procedure OpenSysFile;
    begin
         __SetAtFil(SysFileNm,$00,Day);
         Assign(SysFile,SysFileNm);
         Reset(SysFile);
         if IOResult<>0 then begin
            beep;
            Message('ᤦ 嚨 ..>>>>',1000);
            clrscr;
            halt;
         end;
    end;


procedure CloseSysFile;
    begin
          Close(SysFile);
          __SetAtFil(SysFileNm,$03,Day);
    end;


procedure UpdateUses;
begin
 OpenSysFile;
              seek(SysFile,13);
              read(SysFile,SysRec);
      if SysRec.NumberOfUses>0 then begin
        dec(SysRec.NumberOfUses);
      end;
              seek(SysFile,13);
              write(SysFile,SysRec);
  CloseSysFile;
end;

procedure GetSysParams;
begin
  OpenSysFile;
              seek(SysFile,13);
              read(SysFile,SysRec);
  CloseSysFile;

end;

procedure CheckSysParams;
var Year,Month,Day,Week:word;
begin
     GetSysParams;
     Get_ROM_Date;
   with SysRec do
    begin
     if BiosDate<>BiosDateID then begin
            beep;
            Message('ᤦ 嚨 ..>>>>',1000);
            clrscr;
            halt;
      end;
     if NumberOfUses<=5 then trap;
    end;
  UpdateUses;
end;


procedure CompareCodes;
var NCode:array[1..10] of integer;
    SecretCode:array[1..10] of integer;
    flag:integer;
begin
    SecretCode[1]:=Sysrec.CodeAsf[1]+3;
    SecretCode[2]:=Sysrec.CodeAsf[2]+1;
    SecretCode[3]:=Sysrec.CodeAsf[3]+7;
    SecretCode[4]:=Sysrec.CodeAsf[4]+2;
    SecretCode[5]:=Sysrec.CodeAsf[5]+5;
    SecretCode[6]:=Sysrec.CodeAsf[6]+6;
    SecretCode[7]:=Sysrec.CodeAsf[7]+6;
    SecretCode[8]:=Sysrec.CodeAsf[8]+1;
    SecretCode[9]:=Sysrec.CodeAsf[9]+9;
    SecretCode[10]:=Sysrec.CodeAsf[10]+2;
    for i:=1 to 10 do begin
        if SecretCode[i]>=10 then SecretCode[i]:=SecretCode[i]-10;
        end;
ok:=true;

   for i:=1 to 10 do
       begin
          Val(Code[i],test,flag);
          if test<>SecretCode[i] then ok:=false;
       end;

end;


procedure Trap;
var
    esc,Uparr,DownArr,F10:boolean;
    i,checknum,NewCodeNum,flag:longint;

begin
   clrscr;
   Beep;Beep;Beep;Beep;
   gotoxy(1,23);
 with SysRec do
    begin
      ok:=false;
      Code:='';
      write('  : ',CodeAsf[1]:1,CodeAsf[2]:1,CodeAsf[3]:1,CodeAsf[4]:1,
          CodeAsf[5]:1,CodeAsf[6]:1,CodeAsf[7]:1,CodeAsf[8]:1,CodeAsf[9]:1,CodeAsf[10]);
      ReadString('  '+long2str(NumberOfUses)+ ' x㩜 .⦪  嘪:',
               24,1,10,$07,$07,$07,esc,UpArr,DownArr,F10,Code);

      CompareCodes;
      if ok=true then begin
            InitUses;
              end
               else
                begin
                     if NumberOfUses=0 then begin clrscr;halt;end;
                end;
  end; {with}

end;

procedure InitUses;
var rand:integer;
begin
with SysRec do
  begin
                       randSeed:=4;
                       Randomize;
                       NumberOfUses:=400;
                             for i:=1 to 10 do
                                begin
                                  rand:=random(10);
                                  CodeAsf[i]:=rand;
                             end;
                        OpenSysFile;
                        seek(SysFile,13);
                        write(SysFile,SysRec);
                        CloseSysfile;
   end;
end;

procedure Get_ROM_date;
begin
 for J:=0 to 7 do
  begin
    BiosDate[J+1]:=Chr(Mem[$F000:$FFF5+J]);
    BiosDate[0]:=Chr(8);
  end;
end;


begin
end.




