unit Tamcust;

interface

uses Dos,
     Tpcrt,
     TPstring,
     Tpedit,
     Taccess,
     Unit_win,
     TamTypes,
     TamMsg,
     TamFrm,
     TamUtil;


procedure InputInformation(var Customer : CustRec);
procedure DisplayInformation(var Customer:CustRec);
procedure EditInformation(var Customer:CustRec);

procedure FindCodeOrName(var  CustFile: DataFile;
                        var RecordNumber:LongInt;
                        var  CodeIndx: IndexFile;
                        var  NameIndx: IndexFile;
                        rowC,colC,rowName,Colname:integer);

procedure Clear_code(rowC,colC:integer);
procedure Clear_name(rowN,colN:integer);
procedure Zap_code_name;
procedure OpenDataFile(var CustFile : DataFile;
                       Fname: FileName;
                       Size : integer     );


procedure OpenIndexFile1(var CodeIndx : IndexFile;
                        Fname    : FileName;
                        KeySize  : integer;
                        Dups     : integer);

procedure OpenIndexFile2(var NameIndx : IndexFile;
                        Fname    : FileName;
                        KeySize  : integer;
                        Dups     : integer);

procedure ListCustomers(var CustFile: DataFile);
procedure NextCustomer(var CustFile: DataFile;
                         var  CodeIndx: IndexFile);
procedure PreviousCustomer(var CustFile: DataFile;
                         var  CodeIndx: IndexFile);

procedure Find_customer(var RecordNumber:LongInt;
                        var CustFile:DataFile;
                        var CodeIndx:IndexFile;
                        var CustomerCode:CodeStr);

procedure AddCustomer(var CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);

procedure DeleteCustomer(var CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);

procedure UpdateCustomer(var  CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);
procedure ShowCustomer(var  CustFile: DataFile;
                       var  CodeIndx: IndexFile;
                       var  NameIndx: IndexFile);
procedure CloseDataBase;
procedure CloseTamFiles;
procedure OpenDataBase;
function ValidRecord(var Customer:CustRec):boolean;

implementation

function ValidRecord(var Customer : CustRec) : boolean;

 begin
  ValidRecord := (Customer.CustStatus = 0);
 end;


procedure Clear_code;

          begin
               FastWrite('        ',rowC,colC,$07);
          end;

procedure Clear_name;
  begin
     FastWrite('                    ',rowN,colN,$07);
  end;


procedure InputInformation(var Customer : CustRec);

label loop,
      f1,f2,f3,f4,f5,f6,f7,f8,f9,f10A,f11;

var RecordNumber :LongInt;

begin
 with Customer do
  begin
    CustStatus := 0;
    CodeK:='';
    perigrafi:='';
    timi_ago:=0;
    timi_pol:=0;
    ypoloipo:=0;
    epi_ypoloipo:=0;
    markup_x:=0;
    mon_met:=0;
    Pos_FPA:=0;
    code_fact:='';
    proel:='';
    prom:='';
loop:    stemp:='';ReadString('',5,18,8,$07,$07,$07,esc,UpArr,DownArr,F10,stemp);CodeK:=stemp;
         if esc then exit;
         if Length(CodeK)=0 then goto loop;
         if add then begin
                          FindKey(CodeIndx,RecordNumber,stemp);
                          If OK then begin
                               beep;Message('O K ᨮ ! ',1000);
                               clearMessage;
                               goto loop;
                  end;
          end;
f1:    ReadString('',6,18,20,$07,$07,$07,esc,UpArr,DownArr,F10,Perigrafi);
         if esc then exit;if UpArr then goto f11;
         if F10 then exit;
f2:    ReadLongInt('',7,18,8,$07,$07,0,99999999,esc,UpArr,DownArr,F10,Timi_ago);
         if esc then exit;if UpArr then goto f1;
         if F10 then exit;
f3:    ReadLongInt('',8,18,8,$07,$07,0,99999999,esc,UpArr,DownArr,F10,Timi_pol);
         if esc then exit;if UpArr then goto f2;
         if F10 then exit;
f4:    ReadLongInt('',9,18,8,$07,$07,-99999999,99999999,esc,UpArr,DownArr,F10,Ypoloipo);
         if esc then exit;if UpArr then goto f3;
         if F10 then exit;
f5:    ReadLongInt('',10,18,8,$07,$07,-99999999,99999999,esc,UpArr,DownArr,F10,epi_ypoloipo);
         if esc then exit;if UpArr then goto f4;
         if F10 then exit;
f6:    ReadInteger('',11,18,3,$07,$07,0,500,esc,UpArr,DownArr,F10,Markup_x);
         if esc then exit;if UpArr then goto f5;
         if F10 then exit;
f7:    ReadInteger('',12,18,1,$07,$07,1,5,esc,UpArr,DownArr,F10,Pos_FPA);
         if esc then exit;if UpArr then goto f6;
         FastWrite(long2str(param.fpa[pos_fpa]),12,23,$07);
         if F10 then exit;
f8:    ReadInteger('',13,18,1,$07,$07,1,5,esc,UpArr,DownArr,F10,mon_met);
         if esc then exit;if UpArr then goto f7;
         FastWrite(param.mon[mon_met],13,23,$07);
         if F10 then exit;
f9:    ReadString('',14,18,8,$07,$07,$07,esc,UpArr,DownArr,F10,code_fact);
         if esc then exit;if UpArr then goto f8;
         if F10 then exit;
f10A:  ReadString('',15,18,10,$07,$07,$07,esc,UpArr,DownArr,F10,proel);
         if esc then exit;if UpArr then goto f9;
         if F10 then exit;
f11:   ReadString('',16,18,20,$07,$07,$07,esc,UpArr,DownArr,F10,prom);
         if esc then exit;if UpArr then goto f10A;
         if F10 then exit;
         if DownArr then goto f1;
         goto f1;
  end; {with}
end;


procedure DisplayInformation(var Customer:CustRec);

begin
 with customer do
   begin
    Clear_code(5,18);Clear_name(6,18);
    FastWrite(CodeK,5,18,$07);
    FastWrite(Perigrafi,6,18,$07);
    FastWrite(Long2str(Timi_ago),7,18,$07);
    FastWrite(Long2str(Timi_pol),8,18,$07);
    FastWrite(Long2str(Ypoloipo),9,18,$07);
    FastWrite(Long2str(Epi_ypoloipo),10,18,$07);
    FastWrite(Long2str(Markup_x),11,18,$07);
    FastWrite(Long2str(Pos_FPA),12,18,$07);
    FastWrite(long2str(param.fpa[pos_fpa]),12,23,$07);
    FastWrite(Long2str(Mon_met),13,18,$07);
    FastWrite(Param.mon[mon_met],13,23,$07);
    FastWrite(Code_fact,14,18,$07);
    FastWrite(Proel,15,18,$07);
    FastWrite(Prom,16,18,$07);
  end;
end; {DisplayInformation}


procedure EditInformation(var Customer:CustRec);

label
   f1,f2,f3,f4,f5,f6,f7,f8,f9,f10A,f11;
      begin
 with Customer do
  begin

f1:    ReadString('',6,18,20,$07,$07,$07,esc,UpArr,DownArr,F10,Perigrafi);
         if esc then exit;if UpArr then goto f11;
         if F10 then exit;
f2:    ReadLongInt('',7,18,8,$07,$07,0,99999999,esc,UpArr,DownArr,F10,Timi_ago);
         if esc then exit;if UpArr then goto f1;
         if F10 then exit;
f3:    ReadLongInt('',8,18,8,$07,$07,0,99999999,esc,UpArr,DownArr,F10,Timi_pol);
         if esc then exit;if UpArr then goto f2;
         if F10 then exit;
f4:    ReadLongInt('',9,18,8,$07,$07,-99999999,99999999,esc,UpArr,DownArr,F10,Ypoloipo);
         if esc then exit;if UpArr then goto f3;
         if F10 then exit;
f5:    ReadLongInt('',10,18,8,$07,$07,-99999999,99999999,esc,UpArr,DownArr,F10,epi_ypoloipo);
         if esc then exit;if UpArr then goto f4;
         if F10 then exit;
f6:    ReadInteger('',11,18,3,$07,$07,0,500,esc,UpArr,DownArr,F10,Markup_x);
         if esc then exit;if UpArr then goto f5;
         if F10 then exit;
f7:    ReadInteger('',12,18,1,$07,$07,1,5,esc,UpArr,DownArr,F10,Pos_FPA);
         if esc then exit;if UpArr then goto f6;
         FastWrite(long2str(param.fpa[pos_fpa]),12,23,$07);
         if F10 then exit;
f8:    ReadInteger('',13,18,1,$07,$07,1,5,esc,UpArr,DownArr,F10,mon_met);
         if esc then exit;if UpArr then goto f7;
         FastWrite(param.mon[mon_met],13,23,$07);
         if F10 then exit;
f9:    ReadString('',14,18,8,$07,$07,$07,esc,UpArr,DownArr,F10,code_fact);
         if esc then exit;if UpArr then goto f8;
         if F10 then exit;
f10A:  ReadString('',15,18,10,$07,$07,$07,esc,UpArr,DownArr,F10,proel);
         if esc then exit;if UpArr then goto f9;
         if F10 then exit;
f11:   ReadString('',16,18,20,$07,$07,$07,esc,UpArr,DownArr,F10,prom);
         if esc then exit;if UpArr then goto f10A;
         if F10 then exit;
         if DownArr then goto f1;
         goto f1;


 end;
end; {EditInformation}




procedure FindCodeOrName(var  CustFile: DataFile;
                        var  RecordNumber: LongInt;
                        var  CodeIndx: IndexFile;
                        var  NameIndx: IndexFile;
                        rowC,colC,rowName,colName:integer);

var
  CustomerCode    : CodeStr;
  CustomerName    : NameStr;
  TempCode        :string;
  TempName        :string;


label loopName;

procedure Find_Name_inWindow(var RecordNumber:longInt;
                                 CustomerName:NameStr);


var
  RecArray        :Array[1..100] of LongInt;

     begin
           i:=1;
           SWin:=__MakeWin(10,10,74,22,12,13,Black,LightGray,_DLBORD_WIN,Black,LightGray);
           stemp:=Trim(CustomerName);
           SearchKey(NameIndx,RecordNumber,stemp);
           if not OK then
              begin
                 beep;
                 Message(' ᨮ      !',1000);
                 ClearMessage;
                 Clear_Name(rowName,colName);
                 exit;
              end;
            N:=1;
                    SWin_check:=__DispWin(SWin);
                    Swin_title:='E㨠 ';
                    Swin_pos:=_TopCenter;
                    Swin_check:=__TitleWin(Swin,Swin_title,Black,LightGray,Swin_pos);
                    writeln(' ');
                    writeln(' /                    .    梦    ');
                    writeln(' ');
                 while true do
                    begin
                               GetRec(CustFile,RecordNumber,Customer);
writeln(N:3,Pad(Customer.Perigrafi,20):22,leftPad(Customer.CodeK,8):10,
        Customer.Timi_pol:12,Customer.Ypoloipo:12);
                               RecArray[N]:=RecordNumber;
                               N:=N+1;
                               NextKey(NameIndx,RecordNumber,stemp);
                               if (not OK) OR (N>8) then
                                 begin
                                    FastWrite('',21,11,$70);
                                    St:=0; ReadInteger('E  / : ',22,12,2,$07,$07,0,N-1,esc,UpArr,DownArr,F10,St);
                                    if St>0 then
                                       begin
                                          RecordNumber:=RecArray[St];
                                          GetRec(CustFile,RecordNumber,Customer);
                                          done:=true;
                                          SWin_check:=__RemWin;
                                          exit;
                                       end;
                                    if esc then begin SWin_check:=__RemWin;Clear_Name(rowName,colName);exit;end;
                                    if (St=0) AND OK then
                                          begin
                                           __ClearWin(Black,LightGray);
                                           __gotoWin(1,1);
                    writeln(' ');
                    writeln(' /                 .    梦       ');
                    writeln(' ');
                                           N:=1;
                                          end
                                            else  begin
                                              SWin_check:=__RemWin;
                                              Clear_name(rowName,colName);
                                              exit;
                                            end;
                                  end;
                          end; {Do}
 end; {Pr -Find_InWindow}

begin
     with Customer do
       begin
          done:=false;
              repeat
                CustStatus:=0;
                Zap_code_name;
                esc:=false;
                   TempCode:='';ReadString('',rowC,colC,8,$07,$70,$70,esc,UpArr,DownArr,F10,TempCode);
                    if esc then exit;
                    if f10 then exit;
                    CustomerCode:=TempCode;
                    if Length(CustomerCode)=0 then begin
                                                        Clear_code(rowC,colC);
                                                        goto loopName;
                                                   end;
                        FindKey(CodeIndx,RecordNumber,CustomerCode);
                            if OK then begin
                               CustStatus:=0;
                               GetRec(CustFile,RecordNumber,Customer);
                               done:=true;
                                  if NOT ValidRecord(Customer) then begin
                                     beep;Message('    ⟞..!',1000);
                                     ClearMessage;
                                     done:=false;
                                  end; {Valid}
                              end {OK}
                                else  begin
                                beep;Message('    ⟞..!',1000);
                                     ClearMessage;
                                     done:=false;
                                end;
                    if Length(CustomerCode)=0 then
                         begin
loopName:                  TempName:='';ReadString('',rowName,colName,20,$07,$70,$70,esc,UpArr,DownArr,F10,TempName);
                           CustomerName:=TempName;
                           if Length(CustomerName)=0 then
                                  begin
                                     Clear_name(rowName,colName);
                                     done:=false;
                                  end
                                    else
                                       begin
                                         Find_Name_inWindow(RecordNumber,CustomerName);
                                       end;
                            end;
            until done;
        end; {with}
end; { FindCodeOrName }




procedure OpenDataFile(var CustFile : DataFile;
                       Fname: FileName;
                       Size : integer     );
begin
  OpenFile(CustFile, fname, Size);
  if not OK then
    MakeFile(CustFile,fname,Size);
  if not Ok then
    Abort('  '  + Fname + '    . ');
end;  { OpenDataFile }



procedure OpenIndexFile1(var CodeIndx : IndexFile;
                        Fname    : FileName;
                        KeySize  : integer;
                        Dups     : integer);
begin
  OpenIndex(CodeIndx, Fname,KeySize,0);
  if not OK then
    MakeIndex(CodeIndx, Fname,KeySize,0);
  if not OK then
    Abort('  '  + Fname + '    . ');
end; { OpenIndexFile }

procedure OpenIndexFile2(var NameIndx : IndexFile;
                        Fname    : FileName;
                        KeySize  : integer;
                        Dups     : integer);
begin
  OpenIndex(NameIndx, Fname,KeySize,1);
  if not OK then
    MakeIndex(NameIndx, Fname,KeySize,1);
  if not OK then
    Abort('  '  + Fname + '    . ');
end; { OpenIndexFile2}


procedure ListCustomers(var CustFile: DataFile);

var
  NumberOfRecords,
  RecordNumber    : LongInt;
begin
  NumberOfRecords := FileLen(CustFile);
  Writeln('                   Customers  ');
  Writeln;
  for RecordNumber := 1 to NumberOfRecords - 1 do
  begin
    GetRec(CustFile,RecordNumber,Customer);
    if ValidRecord(Customer) then
  end;
end; { ListCustomers }



procedure NextCustomer(var CustFile: DataFile;
                       var CodeIndx: IndexFile);
var
  RecordNumber : LongInt;
  SearchCode   : CodeStr;
begin
  NextKey(CodeIndx,RecordNumber,SearchCode);
  if OK then
  begin
    GetRec(CustFile,RecordNumber,Customer);
    Write('The next customer is : ');
  end
  else
    Writeln('The end of the database has been reached.');
end; { NextCustomer }

procedure PreviousCustomer(var CustFile: DataFile;
                           var CodeIndx: IndexFile);
var
  RecordNumber : LongInt;
  SearchCode   : CodeStr;
begin
  PrevKey(CodeIndx,RecordNumber,SearchCode);
  if OK then
  begin
    GetRec(CustFile,RecordNumber,Customer);
    Write('The previous customer is : ');
  end
  else
    Writeln('The start of the database has been reached.');
end; { PreviousCustomer }


procedure Find_customer;

      begin
                        FindKey(CodeIndx,RecordNumber,CustomerCode);
                        GetRec(CustFile,RecordNumber,Customer);

      end;

procedure AddCustomer(var CustFile: DataFile;
                      var CodeIndx: IndexFile;
                      var NameIndx: IndexFile);

var
  RecordNumber    : LongInt;
  TempCode        : CodeStr;
begin

        Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
        done_win:=__DispWin(Form_win);

  repeat
    draw_forma1;
    Message('  ⦬ 囦',2);
      esc:=false;
      add:=true;
      f10:=false;

      InputInformation(Customer);
      if esc then begin ClearMessage;done_win:=__RemWin;exit; end;
       AddRec(CustFile,RecordNumber,Customer);
       AddKey(CodeIndx,RecordNumber,Customer.CodeK);
       AddKey(NameIndx,RecordNumber,Customer.Perigrafi);
       Message('       ',1000);
       ClearMessage;
       add:=false;
       done:=true;
  until not done;
 Finished:=false;
end; { AddCustomer }

procedure DeleteCustomer(var  CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);

var
  RecordNumber    : LongInt;
  CustomerCode    : CodeStr;
  CustomerName    : NameStr;
  TempCode        :string;
  TempName        :string;


begin
        Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
        done_win:=__DispWin(Form_win);
   repeat
                 draw_forma1;
                 F10:=false;
                 Message('  囦 ',2);
                 FindCodeOrName(CustFile,RecordNumber,CodeIndx,NameIndx,5,18,6,18);
         if esc then begin ClearMessage;done_win:=__RemWin;exit; end;
         DisplayInformation(Customer);
                   done:=YesOrNo(' 夜   ;',24,1,$70,'O');
                   ClearMessage;
                    if done then begin
                       CustomerCode:=Customer.CodeK;
                       CustomerName:=Customer.Perigrafi;
                       DeleteKey(CodeIndx,RecordNumber,CustomerCode);
                       DeleteKey(NameIndx,RecordNumber,CustomerName);
                       DeleteRec(CustFile,RecordNumber);
                       Message('  ..',1000);
                       ClearMessage;
                    end;  {if }
    until false;
end; { DeleteCustomer }



procedure UpdateCustomer(var  CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);
var
  RecordNumber    : LongInt;
  CustomerPrevName,Customername    : NameStr;
  CustomerPrevFirst:string[17];
  TempCode        :string;
begin
        esc:=false;
        f10:=false;
        Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
        done_win:=__DispWin(Form_win);

   repeat
            draw_forma1;
            F10:=false;
            Message('  囦 ',2);
            FindCodeOrName(CustFile,RecordNumber,CodeIndx,NameIndx,5,18,6,18);
               if esc then begin ClearMessage;done_win:=__RemWin;exit; end;
         DisplayInformation(Customer);

         CustomerPrevName:=Customer.Perigrafi;

         EditInformation(Customer);
               if esc then begin ClearMessage;done_win:=__RemWin;exit; end;
         PutRec(CustFile,RecordNumber,Customer);
              CustomerName:=Customer.Perigrafi;
              DeleteKey(NameIndx,RecordNumber,CustomerPrevName);
              AddKey(NameIndx,RecordNumber,CustomerName);
              Message('  ..',1000);
              ClearMessage;
    until false;
end; { UpdateCustomer }

procedure ShowCustomer(var  CustFile: DataFile;
                       var  CodeIndx: IndexFile;
                       var  NameIndx: IndexFile);
var
  RecordNumber    : LongInt;
  CustomerCode    : CodeStr;
  CustomerName    : NameStr;
  TempCode        :string;
  ch:Char;
begin
      Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
      done_win:=__DispWin(Form_win);

   repeat
         draw_forma1;
         Message(' 椘 囦 ',2);
         F10:=false;
         FindCodeOrName(CustFile,RecordNumber,CodeIndx,NameIndx,5,18,6,18);
            if esc then begin ClearMessage ;deluslines;done_win:=__RemWin;exit; end;
         DisplayInformation(Customer);
stemp:=''; ReadString('<Esc>  ⥦ ,<enter>  ⮜..',24,1,1,$70,$70,$70,esc,UpArr,DownArr,F10,stemp);
           if esc then begin Clearmessage;done_win:=__RemWin;exit; end;
         ClearMessage;
         FastWrite('                 ',6,15,$07);
   until false;
end; { ShowCustomer }

procedure Zap_code_name;
begin
     with Customer do begin
          CodeK:='';
          Perigrafi:='';
     end;
end;

{$F+}

procedure CloseDataBase;
begin
  CloseIndex(CodeIndx);
  CloseIndex(NameIndx);
  CloseFile(CustFile);
end;
{$F-}

Procedure CloseTamFiles;
begin
  Close(TamFile);
  Close(ParamFile);
end;

procedure OpenDatabase;
begin
  InitIndex;
  OpenDataFile(CustFile,BaseFileNm,SizeOf(CustRec));
  OpenIndexFile1(CodeIndx,BaseIndexNm,
                SizeOf(CodeStr)-1,0);
  OpenIndexFile2(NameIndx,NameIndexNm,
                SizeOf(NameStr)-1,1);
  TAerrorProc:=@CloseDatabase;

  Assign(TamFile,TamFileNm);
  reset(TamFile);
  if IOresult<>0 then begin
    beep;
    Message(' ⟞   㩜 !',2000);
    clearmessage;
  end;
  Assign(TamFile,TamFileNm);
  reset(TamFile);
  if IOresult<>0 then begin
    beep;
    Message(' ⟞   㩜 !',2000);
    clearmessage;
  end;

  Assign(FpaFile,FpaFileNm);
  reset(FpaFile);
  if IOresult<>0 then begin
    beep;
    Message(' ⟞    !',2000);
    clearmessage;
  end;
  seek(FpaFile,1);
  read(FpaFile,FpaCount);
end;


begin

end.