unit AsfUtil;

interface

uses  TPCrt,Tpstring,Taccess,AsfTypes,AsfMsg;


procedure RebuildIndex1(VAR CustFile: DataFile;
                        VAR CodeIndex: IndexFile;
                            FileNm : FileName);

procedure RebuildIndex2(VAR CustFile: DataFile;
                       VAR NameIndx: IndexFile;
                       FileNm : FileName);

function ValidRecord(var Customer : CustRec) : boolean;

procedure CreateFiles(var CustFile:DataFile;
                          Fname:FileName;
                          size:integer);
procedure StatusFiles;
procedure ZapFiles;
procedure BackupFiles;
procedure RestoreFiles;
procedure PackFiles;
procedure CreateIndexFiles;
procedure RebuildIndexFiles;

implementation


procedure RebuildIndex1(VAR CustFile: DataFile;
                        VAR CodeIndex: IndexFile;
                            FileNm : FileName);

var
  RecordNumber : LongInt;
begin
  MakeIndex(CodeIndx,FileNm,
            SizeOf(Customer.CodeK)-1,0);
  if not Ok then
    Abort('Could not Rebuild index file ' + FileNm);
  for RecordNumber := 1 to FileLen(CustFile) - 1 do
  begin
    GetRec(CustFile,RecordNumber,Customer);
    If ValidRecord(Customer)then
      AddKey(CodeIndx,RecordNumber,Customer.CodeK);
  end
end; { RebuildIndex }

procedure RebuildIndex2(VAR CustFile: DataFile;
                       VAR NameIndx: IndexFile;
                       FileNm : FileName);
var
  RecordNumber : LongInt;
begin
  MakeIndex(NameIndx,FileNm,
            SizeOf(Customer.LastName)-1,1);
  if not Ok then
    Abort('Could not Rebuild index file ' + FileNm);
  for RecordNumber := 1 to FileLen(CustFile) - 1 do
  begin
    GetRec(CustFile,RecordNumber,Customer);
    If ValidRecord(Customer)then
      AddKey(NameIndx,RecordNumber,Customer.LastName);
  end
end; { RebuildIndex2 }



function ValidRecord(var Customer : CustRec) : boolean;
begin
  ValidRecord := (Customer.CustStatus = 0);
end;


procedure CreateFiles(var CustFile:DataFile;
                          Fname:FileName;
                          size:integer);
begin
    Assign(AtyxFile,AtyxFileNm);
    Assign(SymbFile,SymbFileNm);
    Assign(PaymentFile,PaymentFileNm);
  Message(' , ⤜....',0);
  ClearMessage;
  Message(' 妬 FLCUST.DAT .......',0);
    MakeFile(CustFile,fname,Size);
    if not Ok then
  Abort('  '  + Fname + '    . ');
  FastWrite('OK',24,37,$70);
  delay(1000);
  ClearMessage;
  Message(' 妬 FLATYX.DAT .......',0);
    Rewrite(AtyxFile);
  FastWrite('OK',24,37,$70);
  delay(1000);
  ClearMessage;
  Message(' 妬 FLSYMB.DAT .......',0);
    Rewrite(SymbFile);
  FastWrite('OK',24,37,$70);
  delay(1000);
  ClearMessage;
  Message(' 妬 FLPAYM.DAT .......',0);
    Rewrite(PaymentFile);
  FastWrite('OK',24,37,$70);
  delay(1000);
  ClearMessage;

  CreateIndexFiles;

end;

procedure StatusFiles;

begin
end;

procedure ZapFiles;
begin
end;

procedure BackupFiles;

begin
end;

procedure RestoreFiles;
begin
end;

procedure CreateIndexFiles;

begin
     Message('  INDEX , ⤜....',0);
     ClearMessage;
     Message(' 妬 FLCODX.DAT .......',0);
     RebuildIndex1(CustFile,CodeIndx, BaseIndexNm);
     FastWrite('OK',24,37,$70);
     delay(1000);
     ClearMessage;
     Message(' 妬 FLNAMX.DAT .......',0);
     RebuildIndex2(CustFile,NameIndx, NameIndexNm);
     FastWrite('OK',24,37,$70);
     delay(1000);
     ClearMessage;
end;

procedure RebuildIndexFiles;

begin
     RebuildIndex1(CustFile,CodeIndx, BaseIndexNm);
     RebuildIndex2(CustFile,NameIndx, NameIndexNm);
end;

procedure PackFiles;
begin
end;

begin {AsfUtil}
end.