unit asfcust;

interface

uses Tpcrt,
     TPEdit,
     TPstring,
     Taccess,
     AsfTypes,
     AsfUtil,
     Asfmsg,
     AsfFrm,
     Unit_win;


procedure InputInformation(var Customer : CustRec);
procedure DisplayInformation(var Customer:CustRec);
procedure EditInformation(var Customer:CustRec);
procedure Update_symbfile(PrevName,PrevFirst,PrevPatr:string);

procedure FindCodeOrName(var  CustFile: DataFile;
                        var RecordNumber:LongInt;
                        var  CodeIndx: IndexFile;
                        var  NameIndx: IndexFile;
                        rowC,colC,rowName,Colname:integer);

procedure Clear_code(rowC,colC:integer);
procedure Clear_name(rowN,colN:integer);
procedure OpenDataFile(var CustFile : DataFile;
                       Fname: FileName;
                       Size : integer     );


procedure OpenIndexFile1(var CodeIndx : IndexFile;
                        Fname    : FileName;
                        KeySize  : integer;
                        Dups     : integer);

procedure OpenIndexFile2(var NameIndx : IndexFile;
                        Fname    : FileName;
                        KeySize  : integer;
                        Dups     : integer);

procedure ListCustomers(var CustFile: DataFile);
procedure NextCustomer(var CustFile: DataFile;
                         var  CodeIndx: IndexFile);
procedure PreviousCustomer(var CustFile: DataFile;
                         var  CodeIndx: IndexFile);

procedure Find_customer(var RecordNumber:LongInt;
                        var CustFile:DataFile;
                        var CodeIndx:IndexFile;
                        var CustomerCode:CodeStr);

procedure AddCustomer(var CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);

procedure DeleteCustomer(var CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);

procedure UpdateCustomer(var  CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);
procedure ShowCustomer(var  CustFile: DataFile;
                       var  CodeIndx: IndexFile;
                       var  NameIndx: IndexFile);

procedure Disp_code_name;

procedure CloseDataBase;
procedure OpenDataBase;


implementation

procedure Disp_code_name;
      begin
        with Customer do
         begin
             FastWrite(Customer.CodeK,5,24,$70);
             FastWrite(Customer.LastName,5,51,$70);
             FastWrite(Customer.FirstName,6,51,$07);
             Fastwrite(Customer.PatrName,7,51,$07);
        end;
       end;

procedure Clear_code;

          begin
               FastWrite('        ',rowC,colC,$07);
          end;

procedure Clear_name;
  begin
     FastWrite('                 ',rowN,colN,$07);
  end;


procedure InputInformation(var Customer : CustRec);

label loop,
      f1,f2,f3,f4,f5,f6,f7,f8,f9,f10A,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,
      f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32;

var RecordNumber :LongInt;

begin
 with Customer do
  begin
    CustStatus := 0;
    BirthDate:='';
    FirstName:='';
    LastName:='';
    PatrName:='';
    Epaggelma:='';
    Addr:='';
    Phone:='';
    ArDipl:='';
    DiplDate:='';
    OBirthDate:='';
    OFirstName:='';
    OLastName:='';
    OPatrName:='';
    OEpaggelma:='';
    OAddr:='';
    OPhone:='';
    OArDipl:='';
    ODiplDate:='';
    SymFirst:='';
    SymLast:='';
    SymPatr:='';
    ErgKat:='';
    HP:='';
    Xrisi:='';
    Xroma:='';
    SB:='';
    Pyros:='';
    YZ:='';
    IZ:='';
    Epod:='';
    Klopis:='';
    Epib:='';
    Ypoloipo:=0;
loop:    stemp:='';ReadString('',5,23,8,$07,$07,$07,esc,UpArr,DownArr,F10,stemp);CodeK:=stemp;
         if esc then exit;
         if Length(CodeK)=0 then goto loop;
         if add then begin
                          FindKey(CodeIndx,RecordNumber,stemp);
                          If OK then begin
                               beep;Message('O  ᨮ ! ',1000);
                               clearMessage;
                               goto loop;
                  end;
          end;
f1:    ReadString('',6,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,LastName);
         if esc then exit;if UpArr then goto f32;
         if F10 then exit;
f2:    ReadString('',7,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,FirstName);
         if esc then exit;if UpArr then goto f1;
         if F10 then exit;
f3:    ReadString('',8,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,PatrName);
         if esc then exit;if UpArr then goto f2;
         if F10 then exit;
f4:    ReadString('',9,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,Epaggelma);
         if esc then exit;if UpArr then goto f3;
         if F10 then exit;
f5:    ReadString('',10,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,Addr);
         if esc then exit;if UpArr then goto f4;
         if F10 then exit;
f6:    ReadString('',11,15,8,$07,$07,$07,esc,UpArr,DownArr,F10,BirthDate);
         if esc then exit;if UpArr then goto f5;
         if F10 then exit;
f7:    ReadString('',12,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,Phone);
         if esc then exit;if UpArr then goto f6;
         if F10 then exit;
f8:    ReadString('',13,15,10,$07,$07,$07,esc,UpArr,DownArr,F10,ArDipl);
         if esc then exit;if UpArr then goto f7;
         if F10 then exit;
f9:    ReadString('',14,15,8,$07,$07,$07,esc,UpArr,DownArr,F10,DiplDate);
         if esc then exit;if UpArr then goto f8;
         if F10 then exit;         if F10 then exit;
f10A:    ReadString('',6,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OLastName);
         if esc then exit;if UpArr then goto f9;
         if F10 then exit;
f11:    ReadString('',7,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OFirstName);
         if esc then exit;if UpArr then goto f10A;
         if F10 then exit;
f12:    ReadString('',8,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OPatrName);
         if esc then exit;if UpArr then goto f11;
         if F10 then exit;
f13:    ReadString('',9,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OEpaggelma);
         if esc then exit;if UpArr then goto f12;
         if F10 then exit;
f14:    ReadString('',10,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OAddr);
         if esc then exit;if UpArr then goto f13;
         if F10 then exit;
f15:    ReadString('',11,37,8,$07,$07,$07,esc,UpArr,DownArr,F10,OBirthDate);
         if esc then exit;if UpArr then goto f14;
         if F10 then exit;
f16:    ReadString('',12,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OPhone);
         if esc then exit;if UpArr then goto f15;
         if F10 then exit;
f17:    ReadString('',13,37,10,$07,$07,$07,esc,UpArr,DownArr,F10,OArDipl);
         if esc then exit;if UpArr then goto f16;
         if F10 then exit;
f18:    ReadString('',14,37,8,$07,$07,$07,esc,UpArr,DownArr,F10,ODiplDate);
         if esc then exit;if UpArr then goto f17;
         if F10 then exit;
f19:    ReadString('',6,59,17,$07,$07,$07,esc,UpArr,DownArr,F10,SymLast);
         if esc then exit;if UpArr then goto f18;
         if F10 then exit;
f20:    ReadString('',7,59,17,$07,$07,$07,esc,UpArr,DownArr,F10,SymFirst);
         if esc then exit;if UpArr then goto f19;
         if F10 then exit;
f21:    ReadString('',8,59,17,$07,$07,$07,esc,UpArr,DownArr,F10,SymPatr);
         if esc then exit;if UpArr then goto f20;
         if F10 then exit;
f22:    ReadString('',16,18,12,$07,$07,$07,esc,UpArr,DownArr,F10,ErgKat);
          if esc then exit;if UpArr then goto f21;
         if F10 then exit;
f23:    ReadString('',16,37,3,$07,$07,$07,esc,UpArr,DownArr,F10,HP);
          if esc then exit;if UpArr then goto f22;
         if F10 then exit;
f24:    ReadString('',16,52,4,$07,$07,$07,esc,UpArr,DownArr,F10,Xrisi);
          if esc then exit;if UpArr then goto f23;
         if F10 then exit;
f25:    ReadString('',16,65,10,$07,$07,$07,esc,UpArr,DownArr,F10,Xroma);
          if esc then exit;if UpArr then goto f24;
         if F10 then exit;
f26:    ReadString('',20,10,8,$07,$07,$07,esc,UpArr,DownArr,F10,SB);
          if esc then exit;if UpArr then goto f25;
         if F10 then exit;
f27:    ReadString('',20,28,8,$07,$07,$07,esc,UpArr,DownArr,F10,YZ);
          if esc then exit;if UpArr then goto f26;
         if F10 then exit;
f28:    ReadString('',20,49,8,$07,$07,$07,esc,UpArr,DownArr,F10,EpOd);
          if esc then exit;if UpArr then goto f27;
         if F10 then exit;
f29:    ReadString('',22,10,8,$07,$07,$07,esc,UpArr,DownArr,F10,Pyros);
          if esc then exit;if UpArr then goto f28;
         if F10 then exit;
f30:    ReadString('',22,28,8,$07,$07,$07,esc,UpArr,DownArr,F10,IZ);
          if esc then exit;if UpArr then goto f29;
         if F10 then exit;
f31:    ReadString('',22,49,8,$07,$07,$07,esc,UpArr,DownArr,F10,Klopis);
          if esc then exit;if UpArr then goto f30;
         if F10 then exit;
f32:    ReadString('',22,68,8,$07,$07,$07,esc,UpArr,DownArr,F10,Epib);
          if esc then exit;if UpArr then goto f31;
          goto f1;

  end; {with}
end;


procedure DisplayInformation(var Customer:CustRec);

begin
 with customer do
   begin
    Clear_code(5,23);Clear_name(6,15);
    FastWrite(CodeK,5,23,$07);
    FastWrite(LastName,6,15,$07);
    FastWrite(FirstName,7,15,$07);
    FastWrite(PatrName,8,15,$07);
    FastWrite(Epaggelma,9,15,$07);
    FastWrite(Addr,10,15,$07);
    FastWrite(BirthDate,11,15,$07);
    FastWrite(Phone,12,15,$07);
    FastWrite(ArDipl,13,15,$07);
    FastWrite(DiplDate,14,15,$07);
    FastWrite(OLastName,6,37,$07);
    FastWrite(OFirstName,7,37,$07);
    FastWrite(OPatrName,8,37,$07);
    FastWrite(OEpaggelma,9,37,$07);
    FastWrite(OAddr,10,37,$07);
    FastWrite(OBirthDate,11,37,$07);
    FastWrite(OPhone,12,37,$07);
    FastWrite(OArdipl,13,37,$07);
    FastWrite(ODiplDate,14,37,$07);

    FastWrite(SymLast,6,59,$07);
    FastWrite(SymFirst,7,59,$07);
    FastWrite(SymPatr,8,59,$07);

    FastWrite(ErgKat,16,18,$07);
    FastWrite(HP,16,37,$07);
    FastWrite(Xrisi,16,52,$07);
    FastWrite(Xroma,16,65,$07);

    FastWrite(SB,20,10,$07);
    FastWrite(YZ,20,28,$07);
    FastWrite(EpOd,20,49,$07);

    FastWrite(Pyros,22,10,$07);
    FastWrite(IZ,22,28,$07);
    FastWrite(Klopis,22,49,$07);
    FastWrite(Epib,22,68,$07);

  end;
end; {DisplayInformation}


procedure EditInformation(var Customer:CustRec);

label
      f1,f2,f3,f4,f5,f6,f7,f8,f9,f10A,f11,f12,f13,f14,f15,f16,f17,f18,f19,f20,
      f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32;
begin
 with Customer do
  begin

f1:    ReadString('',6,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,LastName);
         if esc then exit;if UpArr then goto f32;
         if F10 then exit;
f2:    ReadString('',7,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,FirstName);
         if esc then exit;if UpArr then goto f1;
         if F10 then exit;
f3:    ReadString('',8,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,PatrName);
         if esc then exit;if UpArr then goto f2;
         if F10 then exit;
f4:    ReadString('',9,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,Epaggelma);
         if esc then exit;if UpArr then goto f3;
         if F10 then exit;
f5:    ReadString('',10,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,Addr);
         if esc then exit;if UpArr then goto f4;
         if F10 then exit;
f6:    ReadString('',11,15,8,$07,$07,$07,esc,UpArr,DownArr,F10,BirthDate);
         if esc then exit;if UpArr then goto f5;
         if F10 then exit;
f7:    ReadString('',12,15,17,$07,$07,$07,esc,UpArr,DownArr,F10,Phone);
         if esc then exit;if UpArr then goto f6;
         if F10 then exit;
f8:    ReadString('',13,15,10,$07,$07,$07,esc,UpArr,DownArr,F10,ArDipl);
         if esc then exit;if UpArr then goto f7;
         if F10 then exit;
f9:    ReadString('',14,15,8,$07,$07,$07,esc,UpArr,DownArr,F10,DiplDate);
         if esc then exit;if UpArr then goto f8;
         if F10 then exit;
f10A:    ReadString('',6,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OLastName);
         if esc then exit;if UpArr then goto f9;
         if F10 then exit;
f11:    ReadString('',7,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OFirstName);
         if esc then exit;if UpArr then goto f10A;
         if F10 then exit;
f12:    ReadString('',8,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OPatrName);
         if esc then exit;if UpArr then goto f11;
         if F10 then exit;
f13:    ReadString('',9,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OEpaggelma);
         if esc then exit;if UpArr then goto f12;
         if F10 then exit;
f14:    ReadString('',10,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OAddr);
         if esc then exit;if UpArr then goto f13;
         if F10 then exit;
f15:    ReadString('',11,37,8,$07,$07,$07,esc,UpArr,DownArr,F10,OBirthDate);
         if esc then exit;if UpArr then goto f14;
         if F10 then exit;
f16:    ReadString('',12,37,17,$07,$07,$07,esc,UpArr,DownArr,F10,OPhone);
         if esc then exit;if UpArr then goto f15;
         if F10 then exit;
f17:    ReadString('',13,37,10,$07,$07,$07,esc,UpArr,DownArr,F10,OArDipl);
         if esc then exit;if UpArr then goto f16;
         if F10 then exit;
f18:    ReadString('',14,37,8,$07,$07,$07,esc,UpArr,DownArr,F10,ODiplDate);
         if esc then exit;if UpArr then goto f17;
         if F10 then exit;
f19:    ReadString('',6,59,17,$07,$07,$07,esc,UpArr,DownArr,F10,SymLast);
         if esc then exit;if UpArr then goto f18;
         if F10 then exit;
f20:    ReadString('',7,59,17,$07,$07,$07,esc,UpArr,DownArr,F10,SymFirst);
         if esc then exit;if UpArr then goto f19;
         if F10 then exit;
f21:    ReadString('',8,59,17,$07,$07,$07,esc,UpArr,DownArr,F10,SymPatr);
         if esc then exit;if UpArr then goto f20;
         if F10 then exit;
f22:    ReadString('',16,18,12,$07,$07,$07,esc,UpArr,DownArr,F10,ErgKat);
          if esc then exit;if UpArr then goto f21;
         if F10 then exit;
f23:    ReadString('',16,37,3,$07,$07,$07,esc,UpArr,DownArr,F10,HP);
          if esc then exit;if UpArr then goto f22;
         if F10 then exit;
f24:    ReadString('',16,52,4,$07,$07,$07,esc,UpArr,DownArr,F10,Xrisi);
          if esc then exit;if UpArr then goto f23;
         if F10 then exit;
f25:    ReadString('',16,65,10,$07,$07,$07,esc,UpArr,DownArr,F10,Xroma);
          if esc then exit;if UpArr then goto f24;
         if F10 then exit;
f26:    ReadString('',20,10,8,$07,$07,$07,esc,UpArr,DownArr,F10,SB);
          if esc then exit;if UpArr then goto f25;
         if F10 then exit;
f27:    ReadString('',20,28,8,$07,$07,$07,esc,UpArr,DownArr,F10,YZ);
          if esc then exit;if UpArr then goto f26;
         if F10 then exit;
f28:    ReadString('',20,49,8,$07,$07,$07,esc,UpArr,DownArr,F10,EpOd);
          if esc then exit;if UpArr then goto f27;
         if F10 then exit;
f29:    ReadString('',22,10,8,$07,$07,$07,esc,UpArr,DownArr,F10,Pyros);
          if esc then exit;if UpArr then goto f28;
         if F10 then exit;
f30:    ReadString('',22,28,8,$07,$07,$07,esc,UpArr,DownArr,F10,IZ);
          if esc then exit;if UpArr then goto f29;
         if F10 then exit;
f31:    ReadString('',22,49,8,$07,$07,$07,esc,UpArr,DownArr,F10,Klopis);
          if esc then exit;if UpArr then goto f30;
         if F10 then exit;
f32:    ReadString('',22,68,8,$07,$07,$07,esc,UpArr,DownArr,F10,Epib);
          if esc then exit;if UpArr then goto f31;
          goto f1;
 end;
end; {EditInformation}




procedure FindCodeOrName(var  CustFile: DataFile;
                        var  RecordNumber: LongInt;
                        var  CodeIndx: IndexFile;
                        var  NameIndx: IndexFile;
                        rowC,colC,rowName,colName:integer);

var
  CustomerCode    : CodeStr;
  CustomerName    : NameStr;
  TempCode        :string;
  TempName        :string;


label loopName;

procedure Find_Name_inWindow(var RecordNumber:longInt;
                                 CustomerName:NameStr);


var
  RecArray        :Array[1..100] of LongInt;

     begin
           i:=1;
           SWin:=__MakeWin(10,10,74,22,12,13,Black,LightGray,_DLBORD_WIN,Black,LightGray);
           stemp:=Trim(CustomerName);
           SearchKey(NameIndx,RecordNumber,stemp);
           if not OK then
              begin
                 beep;
                 Message(' ᨮ      !',1000);
                 ClearMessage;
                 Clear_Name(rowName,colName);
                 exit;
              end;
            N:=1;
                    SWin_check:=__DispWin(SWin);
                    Swin_title:='E ';
                    Swin_pos:=_TopCenter;
                    Swin_check:=__TitleWin(Swin,Swin_title,Black,LightGray,Swin_pos);
                    writeln(' ');
                    writeln(' /  餬                  餬    ..       ');
                    writeln(' ');
                 while true do
                    begin
                               GetRec(CustFile,RecordNumber,Customer);
writeln(N:3,Pad(Customer.LastName,17):20,Pad(Customer.FirstName,12):12,Pad(Customer.PatrName,12):12,
        LeftPad(Customer.CodeK,8):10);
                               RecArray[N]:=RecordNumber;
                               N:=N+1;
                               NextKey(NameIndx,RecordNumber,stemp);
                               if (not OK) OR (N>8) then
                                 begin
                                    FastWrite('',21,11,$70);
                                    St:=0; ReadInteger('E  / : ',22,12,2,$07,$07,0,N-1,esc,UpArr,DownArr,F10,St);
                                    if St>0 then
                                       begin
                                          RecordNumber:=RecArray[St];
                                          GetRec(CustFile,RecordNumber,Customer);
                                          done:=true;
                                          SWin_check:=__RemWin;
                                          exit;
                                       end;
                                    if esc then begin SWin_check:=__RemWin;Clear_Name(rowName,colName);exit;end;
                                    if (St=0) AND OK then
                                          begin
                                           __ClearWin(Black,LightGray);
                                           __gotoWin(1,1);
                    writeln(' ');
                    writeln(' /  餬                           ..     ');
                    writeln(' ');
                                           N:=1;
                                          end
                                            else  begin
                                              SWin_check:=__RemWin;
                                              Clear_name(rowName,colName);
                                              exit;
                                            end;
                                  end;
                          end; {Do}
 end; {Pr -Find_InWindow}

begin
     with Customer do
       begin
          done:=false;
              repeat
                CustStatus:=0;
                esc:=false;
                   TempCode:='';ReadString('',rowC,colC,8,$07,$70,$70,esc,UpArr,DownArr,F10,TempCode);
                    if esc then begin deluslines;exit;end;
                    CustomerCode:=TempCode;
                    if Length(CustomerCode)=0 then begin
                                                        Clear_code(rowC,colC);
                                                        goto loopName;
                                                   end;
                        FindKey(CodeIndx,RecordNumber,CustomerCode);
                            if OK then begin
                               CustStatus:=0;
                               GetRec(CustFile,RecordNumber,Customer);
                               done:=true;
                                  if NOT ValidRecord(Customer) then begin
                                     beep;Message('   ⟞..!',1000);
                                     ClearMessage;
                                     done:=false;
                                      end; {Valid}
                              end {OK}
                                else  begin
                                beep;Message('   ⟞..!',1000);
                                     ClearMessage;
                                     done:=false;
                                end;
                    if Length(CustomerCode)=0 then
                         begin
loopName:                  TempName:='';ReadString('',rowName,colName,17,$07,$70,$70,esc,UpArr,DownArr,F10,TempName);
                           CustomerName:=TempName;
                           if Length(CustomerName)=0 then
                                  begin
                                     Clear_name(rowName,colName);
                                     done:=false;
                                  end
                                    else
                                       begin
                                         Find_Name_inWindow(RecordNumber,CustomerName);
                                       end;
                            end;
            until done;
        end; {with}
end; { FindCodeOrName }




procedure OpenDataFile(var CustFile : DataFile;
                       Fname: FileName;
                       Size : integer     );
begin
  OpenFile(CustFile, fname, Size);
  if not OK then
    MakeFile(CustFile,fname,Size);
  if not Ok then
    Abort('  '  + Fname + '    . ');
end;  { OpenDataFile }







procedure OpenIndexFile1(var CodeIndx : IndexFile;
                        Fname    : FileName;
                        KeySize  : integer;
                        Dups     : integer);
begin
  OpenIndex(CodeIndx, Fname,KeySize,0);
  if not OK then
    MakeIndex(CodeIndx, Fname,KeySize,0);
  if not OK then
    Abort('  '  + Fname + '    . ');
end; { OpenIndexFile }

procedure OpenIndexFile2(var NameIndx : IndexFile;
                        Fname    : FileName;
                        KeySize  : integer;
                        Dups     : integer);
begin
  OpenIndex(NameIndx, Fname,KeySize,1);
  if not OK then
    MakeIndex(NameIndx, Fname,KeySize,1);
  if not OK then
    Abort('  '  + Fname + '    . ');
end; { OpenIndexFile2}

procedure ListCustomers(var CustFile: DataFile);

var
  NumberOfRecords,
  RecordNumber    : LongInt;
begin
  NumberOfRecords := FileLen(CustFile);
  Writeln('                   Customers  ');
  Writeln;
  for RecordNumber := 1 to NumberOfRecords - 1 do
  begin
    GetRec(CustFile,RecordNumber,Customer);
    if ValidRecord(Customer) then
    {  DisplayCustomer(Customer);}
  end;
end; { ListCustomers }



procedure NextCustomer(var CustFile: DataFile;
                       var CodeIndx: IndexFile);
var
  RecordNumber : LongInt;
  SearchCode   : CodeStr;
begin
  NextKey(CodeIndx,RecordNumber,SearchCode);
  if OK then
  begin
    GetRec(CustFile,RecordNumber,Customer);
    Write('The next customer is : ');
 {   DisplayCustomer(Customer);}
  end
  else
    Writeln('The end of the database has been reached.');
end; { NextCustomer }

procedure PreviousCustomer(var CustFile: DataFile;
                           var CodeIndx: IndexFile);
var
  RecordNumber : LongInt;
  SearchCode   : CodeStr;
begin
  PrevKey(CodeIndx,RecordNumber,SearchCode);
  if OK then
  begin
    GetRec(CustFile,RecordNumber,Customer);
    Write('The previous customer is : ');
{    DisplayCustomer(Customer);  }
  end
  else
    Writeln('The start of the database has been reached.');
end; { PreviousCustomer }


procedure Find_customer;

      begin
                        FindKey(CodeIndx,RecordNumber,CustomerCode);
                        GetRec(CustFile,RecordNumber,Customer);

      end;

procedure AddCustomer(var CustFile: DataFile;
                      var CodeIndx: IndexFile;
                      var NameIndx: IndexFile);

var
  RecordNumber    : LongInt;
  TempCode        : CodeStr;
begin

        Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
        done_win:=__DispWin(Form_win);

  repeat
    draw_forma1;
    Message('   ',2);
      esc:=false;
      add:=true;
      f10:=false;

      InputInformation(Customer);
      if esc then begin ClearMessage;done_win:=__RemWin;exit; end;
       AddRec(CustFile,RecordNumber,Customer);
       AddKey(CodeIndx,RecordNumber,Customer.CodeK);
       AddKey(NameIndx,RecordNumber,Customer.LastName);
       Message('   ',1000);
       ClearMessage;
       add:=false;
       done:=true;
  until not done;
 Finished:=false;
end; { AddCustomer }

procedure Update_symbfile(PrevName,PrevFirst,PrevPatr:string);
   var SymbRecNum,posit:longint;
        begin
            Message('Eਫ਼  ,⤜.......',10);
            Assign(SymbFile,SymbFileNm);
            reset(SymbFile);
            for SymbRecNum:=0 to FILESIZE(SymbFile)-1 do
                begin
                     seek(SymbFile,SymbRecNum);
                     read(SymbFile,Symb);
                       if Symb.CodeK=Customer.CodeK then begin
                                Symb.LastName:=Customer.LastName;
                                Symb.FirstName:=Customer.FirstName;
                                Symb.PatrName:=Customer.PatrName;
                                Seek(SymbFile,SymbRecNum);
                                write(SymbFile,Symb);
                        end;
                 end;
               Close(SymbFile);
               clearmessage;
            end;

procedure delete_symbfile;
   var SymbRecNum,MaxRec:longint;
          begin
            Message('  , ⤜ .......',10);
            Assign(SymbFile,SymbFileNm);
            reset(SymbFile);
            Maxrec:=FILESIZE(SYmbFile)-1;
            for SymbRecNum:=0 to MaxRec do
                begin
                     seek(SymbFile,SymbRecNum);
                     read(SymbFile,Symb);
                        if Symb.CodeK=Customer.CodeK then begin
                                          with Symb do begin
                                               CodeK:='';
                                               Lastname:='';
                                               FirstName:='';
                                               PatrName:='';
                                               BM:=0;
                                               Symbolaio:='';
                                               Ananeosi:='';
                                               ProsthPraxi:='';
                                               DiarApo:='';
                                               DiarEos:='';
                                               Kathara:=0;
                                               PosProm:=0.00;
                                               Prom:=0;
                                               Mikta:=0;
                                               Flag_exof:=false;
                                               Ypoloipo_symb:=0;
                                               Para:='';
                                               Pis:='';
                                               Eidop:='';
                                               Akyros:='';
                                          end;
                                seek(SymbFile,SymbRecNum);
                                write(SymbFile,Symb);
                         end;
                     end;
               Close(SymbFile);
               clearmessage;
            end;

procedure delete_paymfile;
   var PaymRecNum,MaxRec:longint;
          begin
            Message(' 㩜 , ⤜ .......',10);
            Assign(PaymentFile,PaymentFileNm);
            reset(PaymentFile);
            Maxrec:=FILESIZE(PaymentFile)-1;
            for PaymRecNum:=0 to MaxRec do
                begin
                     seek(PaymentFile,PaymRecNum);
                     read(PaymentFile,Payment);
                        if Payment.CodeK=Customer.CodeK then begin
                                 with Payment do begin
                                                   CodeK:='';
                                                   ArSymb:='';
                                                   ProkDate:='';
                                                   ProkApo:=0;
                                                   ProkAxia:=0;
                                                   ExofDate:='';
                                                   ExofApo:=0;
                                          end;
                                seek(PaymentFile,PaymRecNum);
                                write(PaymentFile,Payment);
                         end;
                     end;
               Close(PaymentFile);
               clearmessage;
            end;

procedure DeleteCustomer(var  CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);

var
  RecordNumber    : LongInt;
  CustomerCode    : CodeStr;
  CustomerName    : NameStr;
  TempCode        :string;
  TempName        :string;
  CustomerPrevName: NameStr;
  CustomerPrevFirst:string[17];
  CustomerPrevPatr:string[17];


begin
        Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
        done_win:=__DispWin(Form_win);
   repeat
                 draw_forma1;
                 Message('   ',2);
                 FindCodeOrName(CustFile,RecordNumber,CodeIndx,NameIndx,5,23,6,15);
         if esc then begin ClearMessage;done_win:=__RemWin;exit; end;
         DisplayInformation(Customer);
         CustomerPrevName:=Customer.LastName;
         CustomerPrevFirst:=Customer.FirstName;
         CustomerPrevPatr:=Customer.PatrName;
                   done:=YesOrNo(' 夜   ;',24,1,$70,'O');
                   ClearMessage;
                    if done then begin
                       CustomerCode:=Customer.CodeK;
                       CustomerName:=Customer.LastName;
                       DeleteKey(CodeIndx,RecordNumber,CustomerCode);
                       DeleteKey(NameIndx,RecordNumber,CustomerName);
                       DeleteRec(CustFile,RecordNumber);
                       delete_symbfile;
                       delete_paymfile;
                       Message('  ..',1000);
                       ClearMessage;
                    end;  {if }
    until false;
end; { DeleteCustomer }



procedure UpdateCustomer(var  CustFile: DataFile;
                         var  CodeIndx: IndexFile;
                         var  NameIndx: IndexFile);
var
  RecordNumber    : LongInt;
  CustomerPrevName,Customername    : NameStr;
  CustomerPrevFirst:string[17];
  CustomerPrevPatr:string[17];
  TempCode        :string;
begin
        esc:=false;
        f10:=false;
        Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
        done_win:=__DispWin(Form_win);

   repeat
            draw_forma1;
            Message('   ',2);
            FindCodeOrName(CustFile,RecordNumber,CodeIndx,NameIndx,5,23,6,15);
               if esc then begin ClearMessage;done_win:=__RemWin;exit; end;
         DisplayInformation(Customer);

         CustomerPrevName:=Customer.LastName;
         CustomerPrevFirst:=Customer.FirstName;
         CustomerPrevPatr:=Customer.PatrName;

         EditInformation(Customer);
               if esc then begin ClearMessage;done_win:=__RemWin;exit; end;
         PutRec(CustFile,RecordNumber,Customer);
              CustomerName:=Customer.LastName;
              DeleteKey(NameIndx,RecordNumber,CustomerPrevName);
              AddKey(NameIndx,RecordNumber,CustomerName);
              Update_symbfile(CustomerPrevName,CustomerPrevFirst,CustomerPrevPatr);
              Message('  ..',1000);
              ClearMessage;
    until false;
end; { UpdateCustomer }

procedure ShowCustomer(var  CustFile: DataFile;
                       var  CodeIndx: IndexFile;
                       var  NameIndx: IndexFile);
var
  RecordNumber    : LongInt;
  CustomerCode    : CodeStr;
  CustomerName    : NameStr;
  TempCode        :string;
  ch:Char;
begin
      Form_win:=__MakeWin(2,3,78,22,12,13,Red,Black,_DLBORD_WIN,Red,Black);
      done_win:=__DispWin(Form_win);

   repeat
         draw_forma1;
         Message(' IKONA  ',2);
         FindCodeOrName(CustFile,RecordNumber,CodeIndx,NameIndx,5,23,6,15);
            if esc then begin ClearMessage ;done_win:=__RemWin;exit; end;
         DisplayInformation(Customer);
stemp:=''; ReadString('<Esc>  ⥦ ,<enter>  ⮜..',24,1,1,$70,$70,$70,esc,UpArr,DownArr,F10,stemp);
           if esc then begin Clearmessage;done_win:=__RemWin;exit; end;
         ClearMessage;
         FastWrite('                 ',6,15,$07);
   until false;
end; { ShowCustomer }









{$F+} { Force far calls for the following routine which Turbo Access }
                          { will call in the event of a fatal error. }
procedure CloseDataBase;
begin
  CloseIndex(CodeIndx);
  CloseIndex(NameIndx);
  CloseFile(CustFile);
end;

{$F-}

procedure OpenDatabase;
begin
  InitIndex;
  OpenDataFile(CustFile,BaseFileNm,SizeOf(CustRec));
  OpenIndexFile1(CodeIndx,BaseIndexNm,
                SizeOf(CodeStr)-1,0);
  OpenIndexFile2(NameIndx,NameIndexNm,
                SizeOf(NameStr)-1,1);

  TAErrorProc := @CloseDatabase; { Set up fatal error handler }
end;


begin
end.