;******************************************************
;		   TP8087.ASM 4.03
;		80x87 support routines
;	 Copyright (c) TurboPower Software 1987.
; Portions copyright (c) Sunny Hill Software 1985, 1986
;     and used under license to TurboPower Software
;		 All rights reserved.
;******************************************************

;NOTE:	This file must be assembled with MASM's /R command line option

	INCLUDE TPCOMMON.INC

;****************************************************** Code

CODE	SEGMENT BYTE PUBLIC

	ASSUME	CS:CODE

	PUBLIC	Save8087, Restore8087, Installed8087
	PUBLIC	Exceptions8087, Error8087

;****************************************************** Save8087

;procedure Save8087(var SaveBuf : SaveBuffer8087);
;Saves the 8087 registers in the save buffer.

SaveBuf EQU	DWORD PTR SS:[BX+4]

Save8087	PROC FAR

	StackFrame			;Set up stack frame
	LES	DI,SaveBuf		;Point to save buffer
	FSAVE	ES:[DI] 		;Save contents of 8087 registers
	WAIT				;Wait
	RET	4			;Remove parameter and return

Save8087	ENDP

;****************************************************** Restore8087

;procedure Restore8087(var SaveBuf : SaveBuffer8087);
;Restores the 8087 registers from the save buffer.

Restore8087	PROC FAR

	StackFrame			;Set up stack frame
	LES	DI,SaveBuf		;Point to save buffer
	FRSTOR	ES:[DI] 		;Restore contents of 8087 registers
	WAIT				;Wait
	RET	4			;Remove parameter and return

Restore8087	ENDP

;****************************************************** Installed8087

;function Installed8087 : Boolean;
;Returns true if an 8087 or 80x87 coprocessor is installed

Installed8087	PROC FAR

	StackFrame			;Set up stack frame
	FNINIT				;Initialize co-processor
	SetZero AX			;Assume false
	PUSH	AX			;SS:[BX-2] = 0
	FNSTCW	SS:[BX-2]		;store control word
	CMP	BYTE PTR SS:[BX-1],3	;upper byte is 3 if math chip installed
	JNE	Done			;If not 3, no math chip installed
	INC	AX			;AX = 1 (True)
Done:
	BooleanResult			;Set zero flag
	MOV	SP,BX			;Restore the stack
	RET				;Return

Installed8087	ENDP


;****************************************************** Exceptions8087

;procedure Exceptions8087(on : boolean);
;Turn exception interrupts on or off

OnOff EQU BYTE PTR [BP+6]
CtrlWord EQU WORD PTR [BP-2]

Exceptions8087	 PROC FAR

	StackFrameBP			  ;Set up stack frame
	MOV	AL,OnOff
	OR	AL,AL
	JZ	ExceptionsOff

	MOV	CtrlWord,0372H		  ;Unmask IM,ZM,OM
	JMP SHORT ExceptionsDone

ExceptionsOff:
	FSTCW	CtrlWord		  ;Get current control word
	OR	CtrlWord,00FFh		  ;Mask all exceptions

ExceptionsDone:
	FLDCW	CtrlWord		  ;Change 8087 control word
	ExitCode 2

Exceptions8087	 ENDP

;****************************************************** Error8087

;function Error8087 : Word;
;Return the Error status of the 8087

StatWord EQU WORD PTR [BP-2]

Error8087   PROC FAR

	StackFrameBP			  ;Set up stack frame
	FSTSW	StatWord		  ;Get current status word
	MOV	AX,StatWord		  ;Return in AX
	AND	AX,03Fh 		  ;Just the exception indicators
	FCLEX				  ;Clear exception indicators
	ExitCode 0

Error8087   ENDP

CODE	ENDS

	END
