;***********************************************************************
;
; IsHerc      Return presence of Hercules Graphics adapter
;
; function    IsHerc : boolean;
;
;	      The return value of the function is TRUE if
;	      a Hercules card is installed, FALSE otherwise.
;
; Description This function performs a presence test for the Hercules
;	      Graphics Card.  It is called from __EquipScn during its
;	      initialization.  The Hercules Graphics Card is originally
;	      detected as a monochrome adapter, either by calling BIOS
;	      or by writing to its port address.  __EquipScn calls this
;	      function last to determine whether a monochrome adapter
;	      previously found is in fact a Hercules card.
;
;	      This function uses the algorithm advocated by Hercules
;	      Computer Technology.
;
; Version     4.00 (C)Copyright Blaise Computing Inc. 1987
;_______________________________________________________________________

code	   segment
	   assume cs:code,ds:nothing

status_port  equ   03bah

	   public  IsHerc
isherc	   proc    near 	       ; NEAR because not exported
	   mov	   dx,status_port      ; Record state
	   in	   al,dx
	   and	   al,80h	       ; Save bit 7 for test
	   mov	   ah,al
	   mov	   cx,8000h	       ; Set counter for loop
examine:
	   in	   al,dx	       ; Take another reading
	   and	   al,80h	       ; Again save bit 7
	   cmp	   al,ah	       ;
	   jne	   found	       ; If bit 7 changes, then it
	   loop    examine	       ;   is a Hercules Graphics Card
	   xor	   ax,ax	       ; After this long it must be some-
	   jmp	   exit 	       ;   thing else, so not found.
found:
	   mov	   ax,1 	       ; Found, return TRUE
exit:
	   ret
IsHerc	   endp

code	   ends
	   end
