(****************************************************************)
(*                     DATABASE TOOLBOX 4.0                     *)
(*     Copyright (c) 1984, 87 by Borland International, Inc.    *)
(*                                                              *)
(*                          TAInst                              *)
(*                                                              *)
(*  Purpose: Directory Installation program for TABuild         *)
(*                                                              *)
(****************************************************************)
program TAInStall;
uses CRT,
     MiscTool,
{    If a compiler error occurs here, you need to unpack the source
     to the MiscTool unit from the archived file Tools.arc.  See the
     README file on disk 1 for detailed instructions. }

     EditLn,
     Config;

{$V-}
{$I Paths.inc}

const
  Version = '4.00';
  CopyrightMsg = 'Copyright (C)';
  Year = '1987';
  Company = 'Borland International';
  ProgName = 'TAInst';
  TABuild = 'TABuild.exe';
  LoadDefaults = true;
  StoreDefaults = false;

const
  Terminators : CharSet = [Esc, CR, UpKey, DownKey];

type
   InstallNames = (TurboPathName, TAccessPathName);
   InstallRec = record
                  Prompt : String[30];
                  X, Y : byte;
                  P : PathName;
                end;
const
   TABuildPaths : array[InstallNames] of InstallRec =
     ((Prompt : 'Turbo Pascal Directory: '; X : 0; Y : 0; P : ''),
      (Prompt : 'Turbo Access Directory: '; X : 0; Y : 0; P : ''));

procedure GetPath(var CurPath : InstallRec;
                  var TC : char);
const
  Printable : CharSet = [#32..#127];

var
  Path : PathName;

begin
  with CurPath do
  begin
    Path := P;
    EditLine(Path, SizeOf(PathName) - 1, x, y,
             Printable, Terminators, TC);
    if TC <> Esc then
    begin
      Path := UpCaseStr(Path);
      if (Path <> '') and (Path[Length(Path)] <> '\') then
        Path := Path + '\';
    end
    else
      Path := P;
    P := Path;
  end;
end;


procedure InstallPaths(var TurboPath, TAccessPath : PathName);
var
  TC : char;
  CurPath : InstallNames;
  done : boolean;

begin
  CfgReplace(TABuild, head, tail, LoadDefaults);
  if TAccessPath = '' then
    GetDir(0, TAccessPath);
  TABuildPaths[TurboPathName].P := TurboPath;
  TABuildPaths[TAccessPathName].P := TAccessPath;
  for CurPath := TurboPathName to TAccessPathName do
    with TABuildPaths[CurPath] do
    begin
      Write(Prompt);
      X := WhereX; Y := WhereY;
      Writeln(P);
      Writeln;
    end;
  CurPath := TurboPathName;
  done := false;
  repeat
    GetPath(TABuildPaths[CurPath], TC);
    case TC of
      CR : if CurPath = TAccessPathName then
            done := true
           else
             CurPath := succ(CurPath);
      DownKey,
      UpKey : if CurPath = TurboPathName then
                 CurPath := TAccessPathName
               else
                 CurPath := TurboPathName;
      Esc : ;
    end;
  until done;
  TurboPath := TABuildPaths[TurboPathName].P;
  TAccessPath := TABuildPaths[TAccessPathName].P;
end; { InstallPaths }

procedure StartUp;
begin
  ClrScr;
  Writeln(ProgName, ' version ', Version);
  Writeln(CopyrightMsg, ' ', Year, ' ', Company);
  Writeln;
  Writeln(Progname, ' installs ', TABuild, ' with your system information so that');
  Writeln('TABuild will be able to find the Turbo Pascal command line compiler');
  Writeln('and the necessary Turbo Access files.');
  Writeln;
  if not CFGExist(TABuild) then
    CfgAbort(TABuild + ' must be in the current directory');
end;

begin
  StartUp;
  InstallPaths(TurboPath, TAccessPath);
  CfgReplace(TABuild , head, tail, StoreDefaults);
end.
