(****************************************************************)
(*                     DATABASE TOOLBOX 4.0                     *)
(*     Copyright (c) 1984, 87 by Borland International, Inc.    *)
(*                                                              *)
(*                        GenType                               *)
(*                                                              *)
(*  Purpose: Generates a type definition file (a .TYP file)     *)
(*  from the corresponding Field definition file which is       *)
(*  created by IMPORTR.                                         *)
(*                                                              *)
(****************************************************************)
program GenType;
uses DOS,
     CRT,
     MiscTool,
{    If a compiler error occurs here, you need to unpack the source
     to the MiscTool unit from the archived file Tools.arc.  See the
     README file on disk 1 for detailed instructions. }

     FileUtil,
     FieldDef;
const
  Version = '4.00';
  CopyrightMsg = 'Copyright (C)';
  Year = '1987';
  Company = 'Borland International';
  ProgName = 'GenType';
  Description = ' generates record/key(s) type definition file from an FD file';

procedure ProgramInfo;
begin
  Writeln;
  Writeln(ProgName, ' version ', Version);
  Writeln(CopyrightMsg, ' ', Year, ' ', Company);
  Writeln;
  Writeln(ProgName, Description);
  Writeln;
end;

procedure SyntaxHelp;
begin
  Writeln('Syntax: ', ProgName, ' FieldDefFile');
  Writeln;
end;

var
  FD : FieldDirectory;
  FDFileNm : FileName;
  FDFileSpec : FileSpec;

begin
  ProgramInfo;
  if ParamCount = 0 then
  begin
    SyntaxHelp;
    Halt;
  end
  else
  begin
    FDFileNm := ParamStr(1);
    GetFileSpec(FDFileSpec, FDFileNm);
    with FDFileSpec do
    begin
      if Ext = '' then
        Ext := FDExt;
      LoadFD(FD, Path + Name + Ext);
      Writeln('Writing type defintion(s) to ', Path + Name + TypExt);
      Writeln;
      GenPascalTypeDef(FD, Path + Name + TypExt);
    end;
  end;
end.
