(****************************************************************)
(*                     DATABASE TOOLBOX 4.0                     *)
(*     Copyright (c) 1984, 87 by Borland International, Inc.    *)
(*                                                              *)
(*                         TAConvert                            *)
(*                                                              *)
(*                                                              *)
(*  This program is used to convert your Turbo Access 1.0 data  *)
(*  and index files to the equivalent version 4.0 files.  By    *)
(*  using the file TEMPLATE.NFO as a template, you specify the  *)
(*  configuration of your database by setting some constants.   *)
(*  You then include the resulting file in this program and     *)
(*  compile and run it to translate your data.                  *)
(*                                                              *)
(*                                                              *)
(*  You should have the following available before you proceed: *)
(*    a) Your record and key definitions for your Turbo Access  *)
(*       1.XX database.                                         *)
(*    b) The Turbo Acccess 1.XX constant declarations from      *)
(*       1.XX program.                                          *)
(*                                                              *)
(*    c) Your MYPROG.TYP file which contains your 4.0 record    *)
(*       and key type definitions.                              *)
(*                                                              *)
(*                                                              *)
(*  To convert your data and index files:                       *)
(*                                                              *)
(*  1) Run TABuild MYPROG.TYP where MyProg.typ is your 4.0 type *)
(*     def. file for this database.                             *)
(*  2) Create a new file called for example MyProg.nfo and load *)
(*     it into the Turbo editor.                                *)
(*  3) Block read (^KR) in TEMPLATE.NFO.                        *)
(*  4) Modify the constants in MYPROG.NFO to match the          *)
(*     declarations in your database program.  Look at          *)
(*     BTREE.NFO for an example.                                *)
(*  5) Change the include directive below to MYPROG.NFO         *)
(*  6) Compile and run this program to translate your files     *)
(*                                                              *)
(*                                                              *)
(****************************************************************)

(****************************************************************)
(*        CONVERT - Steps to run and convert BTREE files        *)
(*                                                              *)
(*                                                              *)
(*  1)  Put your Turbo Pascal Database Toolbox Disk 2 in drive  *)
(*      A, and at the DOS prompt type:                          *)
(*                                                              *)
(*      A:\UNPACK A:\BTREE                                      *)
(*                                                              *)
(*      This will extract BTREE.TYP, BTREE.EXE, and several     *)
(*      other files used by the new BTREE program.              *)
(*                                                              *)
(*  2)  If you have installed the Turbo Access system with      *)
(*      TAINST, you can now type at the DOS prompt:             *)
(*                                                              *)
(*      TABUILD /H- BTREE                                       *)
(*                                                              *)
(*      This will configure the Turbo Access system for the new *)
(*      BTREE file format.                                      *)
(*                                                              *)
(*                                                              *)
(*  3)  Now you can load Convert.pas into the Turbo Pascal      *)
(*      integrated environment and press Alt-R to execute the   *)
(*      program.  The data and index files for BTREE will be    *)
(*      converted to the Turbo Access 4.0 format.               *)
(*                                                              *)
(*                                                              *)
(*  4)  After Convert.pas has finished running, you may         *)
(*      execute BTREE.EXE to see the contents of the converted  *)
(*      data and index files.                                   *)
(*                                                              *)
(*                                                              *)
(****************************************************************)




program TAConvert;
uses
  DOS,
  CRT,
  TAccess,
{ If a compiler error occurs here, the Turbo Pascal compiler cannot
  find the TAccess unit.  You can compile and configure the TAccess
  unit for your database project by using the TABuild utility. See
  the top of this file for detailed instructions }

  Turbo3,
  MiscTool;
{ If a compiler error occurs here, you need to unpack the source
  to the MiscTool unit from the archived file Tools.arc.  See the
  README file on disk 1 for detailed instructions. }


{$I BTREE.NFO}
{ This file contains information necessary to convert the data
  and index files used by the BTREE program.  BTREE.NFO is a
  modification of the file TEMPLATE.NFO. Create a .NFO file which
  matches your database structure and set the above directive
  to that file name. }

{$I ACCESS.BOX}
{$I GETKEY.BOX}

procedure ConvertDataFile;
{ Opens and converts a Turbo Access 1.0 data file into it's equivalent
  Turbo Access 4.0 data file. }
type
  BytePtr = ^Byte;
  IntPtr = ^Integer;
  LongPtr = ^LongInt;

var
  DataFile1 : DataFile; { Turbo Access 1.0 DataFile }
  DataFile4 : TAccess.DataFile;
  OrigDataPtr,
  NewDataPtr,
  Source,
  Dest : BytePtr;
  DataSize : Word;

procedure OpenDataFiles;
begin
  with MyDataFile do
  begin
    OpenFile(DataFile1, OrigFileNm, OrigRecordSize);
    if not OK then
      Abort('Could not open ' + OrigFileNm);
    TAccess.MakeFile(DataFile4, NewFileNm, NewRecordSize);
    if not OK then
      Abort('Could not create ' + NewFileNm);
    Writeln('Converting 1.0 data file ', OrigFileNm, ' to ', NewFileNm);
  end;
end; { OpenDataFiles }

procedure ConvertRecord(var D1;
                        var D4);
const
  EndOfList = -1;
begin
  with MyDataFile do
  begin
    if NewStatusField then
    begin
      LongPtr(D4)^ := 0;
      if OrigStatusField and (IntPtr(D1)^ <> 0) then
        LongPtr(D4)^ := EndOfList;
    end;
    Move(Source^, Dest^, DataSize);
  end;
end; { ConvertRecord }

procedure ConvertDataRecords(var DataFile1 : DataFile;
                             var DataFile4 : TAccess.DataFile);
var
  RecNum1 : word;
  RecNum4 : LongInt;

begin
  for RecNum1 := 1 to pred(FileLen(DataFile1)) do
  with MyDataFile do
  begin
    GetRec(DataFile1, RecNum1, OrigDataPtr^);
    ConvertRecord(OrigDataPtr, NewDataPtr);
    TAccess.AddRec(DataFile4, RecNum4, NewDataPtr^);
    Write(RecNum4:4, #13);
    if NewStatusField and (LongPtr(NewDataPtr)^ <> 0) then
      TAccess.DeleteRec(DataFile4, RecNum4);
  end;
end; { ConvertDataRecords }


begin { ConvertDataFiles }
  with MyDataFile do
  begin
    OpenDataFiles;
    GetMem(OrigDataPtr, OrigRecordSize);
    Source := OrigDataPtr;
    DataSize := OrigRecordSize;
    if OrigStatusField then
    begin
      Source := BytePtr(LongInt(Source) + 2);
      Dec(DataSize, 2);
    end;
    GetMem(NewDataPtr, NewRecordSize);
    Dest := NewDataPtr;
    if NewStatusField then
      Dest := BytePtr(LongInt(Dest) + 4);
    ConvertDataRecords(DataFile1, DataFile4);
    CloseFile(DataFile1);
    TAccess.CloseFile(DataFile4);
    Writeln;
  end;
end;  { ConvertDataFiles }


procedure ConvertIndexFiles;
var
  IndexFile1 : IndexFile;
  IndexFile4 : TAccess.IndexFile;
  CurIndexF : byte;

procedure ConvertKeys(var IndexFile1 : IndexFile;
                      var IndexFile4 : TAccess.IndexFile);
{ This will convert any 1.0 index file to its 4.0 equivalent.
  It is not dependent on your key definitions. }
var
  Count : word;
  i : integer;
  L : LongInt;
  K : String;
begin
  ClearKey(IndexFile1);
  TAccess.ClearKey(IndexFile4);
  Count := 1;
  repeat
    NextKey(IndexFile1, i, K);
    if Ok then
    begin
      Write(Count:4, #13);
      Inc(Count, 1);
      L := word(i);
      TAccess.AddKey(IndexFile4, L, K);
      if not TAccess.Ok then
        Abort('Could not add the key ' + K);
    end;
  until not OK;
  CloseIndex(IndexFile1);
  TAccess.CloseIndex(IndexFile4);
  Writeln;
end; { ConvertKeys }


begin { ConvertIndexFiles }
  InitIndex; { required by Turbo Access 1.XX }
  for CurIndexF := 1 to NumIndexFiles do
    with MyIndexFiles[CurIndexF] do
    begin
      OpenIndex(IndexFile1, OrigFileNm, KeyLength, Status);
      if not OK then
        Abort('Could not open ' + OrigFileNm);
      TAccess.MakeIndex(IndexFile4, NewFileNm, KeyLength, Status);
      if not OK then
        Abort('Could not create ' + NewFileNm);
      Writeln('Converting 1.0 index file ', OrigFileNm, ' to ', NewFileNm);
      ConvertKeys(IndexFile1, IndexFile4);
    end;
end;

begin
  ConvertDataFile;
  ConvertIndexFiles;
end.
